/*
 * Decompiled with CFR 0.152.
 */
package frankv.jmi.ftbchunks.client;

import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.math.XZ;
import frankv.jmi.JMIOverlayHelper;
import frankv.jmi.ftbchunks.client.ClaimedChunkPolygon;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.IThemeButton;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.display.ThemeButtonDisplay;
import journeymap.client.api.event.forge.FullscreenDisplayEvent;
import journeymap.client.api.model.MapPolygon;
import journeymap.client.api.model.MapPolygonWithHoles;
import journeymap.client.api.model.ShapeProperties;
import journeymap.client.api.util.PolygonHelper;
import journeymap.client.ui.component.JmUI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClaimingMode {
    private IClientAPI jmAPI;
    private ClaimedChunkPolygon claimedChunkPolygon;
    public static boolean activated = false;
    private static Minecraft mc = Minecraft.m_91087_();
    public static PolygonOverlay claimAreaPolygon = null;
    public static Set<ChunkPos> area = new HashSet<ChunkPos>();

    public ClaimingMode(IClientAPI jmAPI, ClaimedChunkPolygon claimedChunkPolygon) {
        this.jmAPI = jmAPI;
        this.claimedChunkPolygon = claimedChunkPolygon;
    }

    @SubscribeEvent
    public void onAddonButtonDisplay(FullscreenDisplayEvent.AddonButtonDisplayEvent event) {
        ThemeButtonDisplay buttonDisplay = event.getThemeButtonDisplay();
        buttonDisplay.addThemeToggleButton("FTBChunks Claiming Mode", "FTBChunks Claiming Mode", "grid", activated, b -> this.buttonControl(b));
    }

    @SubscribeEvent
    public void onGuiScreen(ScreenOpenEvent event) {
        if (!activated) {
            return;
        }
        if (event.getScreen() instanceof JmUI && event.getScreen() != null) {
            return;
        }
        activated = false;
        this.removeOverlays();
    }

    private void buttonControl(IThemeButton button) {
        if (ClaimingMode.mc.f_91074_ == null) {
            return;
        }
        if (!activated) {
            activated = true;
            this.createClaimingAreaOverlays();
            button.setToggled(Boolean.valueOf(true));
        } else {
            activated = false;
            this.removeOverlays();
            button.setToggled(Boolean.valueOf(false));
        }
    }

    private void removeOverlays() {
        if (claimAreaPolygon == null) {
            return;
        }
        this.jmAPI.remove((Displayable)claimAreaPolygon);
        this.claimedChunkPolygon.showForceLoadedByArea(false);
        claimAreaPolygon = null;
        area.clear();
    }

    public static PolygonOverlay dragPolygon(XZ xz) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        String displayId = "drag_polygon_" + xz.x + "_" + xz.z;
        ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth(0.0f).setFillColor(0xFFFFFF).setFillOpacity(0.3f);
        MapPolygon polygon = PolygonHelper.createChunkPolygon((int)xz.x, (int)10, (int)xz.z);
        return new PolygonOverlay("jmi", displayId, player.f_108545_.m_46472_(), shapeProps, polygon);
    }

    public static PolygonOverlay forceLoadedPolygon(ChunkDimPos pos) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        String displayId = "ftb_force_loaded_" + pos.x + "_" + pos.z;
        ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth(2.0f).setStrokeColor(0xFF0000).setFillOpacity(0.0f);
        MapPolygon polygon = PolygonHelper.createChunkPolygon((int)pos.x, (int)10, (int)pos.z);
        return new PolygonOverlay("jmi", displayId, player.f_108545_.m_46472_(), shapeProps, polygon);
    }

    private void createClaimingAreaOverlays() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ChunkPos startPoint = new ChunkPos(player.m_146902_().f_45578_ - 7, player.m_146902_().f_45579_ - 7);
        String displayId = "claim_mode";
        ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth(3.0f).setStrokeColor(0xFFFFFF).setStrokeOpacity(1.0f).setFillOpacity(0.0f);
        for (int x = 0; x < 15; ++x) {
            for (int z = 0; z < 15; ++z) {
                area.add(new ChunkPos(startPoint.f_45578_ + x, startPoint.f_45579_ + z));
            }
        }
        this.claimedChunkPolygon.showForceLoadedByArea(true);
        List polygons = PolygonHelper.createChunksPolygon(area, (int)100);
        PolygonOverlay overlay = new PolygonOverlay("jmi", displayId, player.f_19853_.m_46472_(), shapeProps, (MapPolygonWithHoles)polygons.get(0));
        if (JMIOverlayHelper.createPolygon(overlay)) {
            claimAreaPolygon = overlay;
        }
    }
}

