/*
 * Decompiled with CFR 0.152.
 */
package frankv.jmi.ftbchunks.client;

import dev.ftb.mods.ftbchunks.net.RequestChunkChangePacket;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import frankv.jmi.JMIOverlayHelper;
import frankv.jmi.ftbchunks.client.ClaimingMode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.event.FullscreenMapEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClaimingModeHandler {
    private static boolean doRecord = false;
    public static Map<XZ, PolygonOverlay> dragPolygons = new HashMap<XZ, PolygonOverlay>();
    public static HashSet<XZ> chunks = new HashSet();

    public static void preClick(FullscreenMapEvent.ClickEvent event) {
        if (!ClaimingMode.activated) {
            return;
        }
        XZ xz = XZ.chunkFromBlock((int)event.getLocation().m_123341_(), (int)event.getLocation().m_123343_());
        if (!ClaimingMode.area.contains(new ChunkPos(xz.x, xz.z))) {
            return;
        }
        doRecord = true;
        ClaimingModeHandler.addToWaitingList(xz);
        event.cancel();
    }

    public static void preDrag(FullscreenMapEvent.MouseDraggedEvent event) {
        if (!ClaimingMode.activated) {
            return;
        }
        XZ xz = XZ.chunkFromBlock((int)event.getLocation().m_123341_(), (int)event.getLocation().m_123343_());
        if (doRecord || ClaimingMode.area.contains(new ChunkPos(xz.x, xz.z))) {
            event.cancel();
        }
    }

    public static void mouseMove(FullscreenMapEvent.MouseMoveEvent event) {
        if (!doRecord) {
            return;
        }
        XZ xz = XZ.chunkFromBlock((int)event.getLocation().m_123341_(), (int)event.getLocation().m_123343_());
        if (ClaimingMode.area.contains(new ChunkPos(xz.x, xz.z)) || chunks.contains(xz)) {
            ClaimingModeHandler.addToWaitingList(xz);
        }
    }

    private static void addToWaitingList(XZ xz) {
        PolygonOverlay polygon = ClaimingMode.dragPolygon(xz);
        if (!JMIOverlayHelper.createPolygon(polygon)) {
            return;
        }
        dragPolygons.put(xz, polygon);
        chunks.add(xz);
    }

    private static void applyChanges(int mouseButton) {
        doRecord = false;
        if (chunks.isEmpty()) {
            return;
        }
        new RequestChunkChangePacket(Screen.m_96638_() ? mouseButton + 2 : mouseButton, chunks).sendToServer();
        JMIOverlayHelper.removePolygons(dragPolygons.values());
        chunks.clear();
        dragPolygons.clear();
        GuiHelper.playSound((SoundEvent)SoundEvents.f_12490_, (float)1.0f);
    }

    @SubscribeEvent
    public static void mouse(InputEvent.MouseInputEvent event) {
        if (!doRecord) {
            return;
        }
        if (event.getAction() != 0 || event.getButton() > 1) {
            return;
        }
        ClaimingModeHandler.applyChanges(event.getButton());
    }
}

