/*
 * Decompiled with CFR 0.152.
 */
package frankv.jmi.ftbchunks.client;

import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import frankv.jmi.JMI;
import java.util.Objects;
import java.util.UUID;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.model.MapPolygon;
import journeymap.client.api.model.ShapeProperties;
import journeymap.client.api.model.TextProperties;
import journeymap.client.api.util.PolygonHelper;

public class FTBClaimedChunkData {
    public final SendChunkPacket.SingleChunk chunk;
    public final ChunkDimPos chunkDimPos;
    public final boolean forceLoaded;
    public final UUID teamId;
    public final ClientTeam team;
    public final PolygonOverlay overlay;

    public FTBClaimedChunkData(MapDimension dim, SendChunkPacket.SingleChunk chunk, UUID teamId) {
        this.chunk = chunk;
        this.chunkDimPos = new ChunkDimPos(dim.dimension, chunk.x, chunk.z);
        this.forceLoaded = chunk.forceLoaded;
        this.teamId = teamId;
        this.team = ClientTeamManager.INSTANCE.getTeam(teamId);
        this.overlay = this.team == null ? null : this.makeOverlay();
    }

    private PolygonOverlay makeOverlay() {
        int color = this.team.getColor();
        String displayId = "claimed_" + this.chunkDimPos.x + "," + this.chunkDimPos.z;
        ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth(0.0f).setFillColor(color).setFillOpacity((float)JMI.CLIENT_CONFIG.getClaimedChunkOverlayOpacity());
        TextProperties textProps = new TextProperties().setColor(color).setOpacity(1.0f).setFontShadow(true);
        MapPolygon polygon = PolygonHelper.createChunkPolygon((int)this.chunkDimPos.x, (int)1, (int)this.chunkDimPos.z);
        PolygonOverlay overlay = new PolygonOverlay("jmi", displayId, this.chunkDimPos.dimension, shapeProps, polygon);
        overlay.setOverlayGroupName("Claimed Chunks").setTitle(this.team.getDisplayName()).setTextProperties(textProps);
        return overlay;
    }

    public void updateOverlayProps() {
        int color = this.team.getColor();
        this.overlay.getTextProperties().setColor(color);
        this.overlay.getShapeProperties().setFillColor(color);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FTBClaimedChunkData chunkData = (FTBClaimedChunkData)o;
        return this.forceLoaded == chunkData.forceLoaded && Objects.equals(this.chunk, chunkData.chunk) && Objects.equals(this.chunkDimPos, chunkData.chunkDimPos) && Objects.equals(this.teamId, chunkData.teamId);
    }

    public int hashCode() {
        return Objects.hash(this.chunk, this.chunkDimPos, this.forceLoaded, this.teamId);
    }
}

