/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.core.LootManager;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.items.CoinItem;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final List<String> CLIENT_DEFAULT_RENDER_AS_BLOCK = ImmutableList.of((Object)"minecraft:oak_sapling", (Object)"minecraft:birch_sapling", (Object)"minecraft:spruce_sapling", (Object)"minecraft:jungle_sapling", (Object)"minecraft:acacia_sapling", (Object)"minecraft:dark_oak_sapling", (Object)"minecraft:cobweb", (Object)"minecraft:grass", (Object)"minecraft:dead_bush", (Object)"minecraft:fern", (Object)"minecraft:seagrass", (Object)"minecraft:sea_pickle", (Object[])new String[]{"minecraft:dandelion", "minecraft:poppy", "minecraft:blue_orchid", "minecraft:allium", "minecraft:azure_bluet", "minecraft:red_tulip", "minecraft:orange_tulip", "minecraft:white_tulip", "minecraft:pink_tulip", "minecraft:oxeye_daisy", "minecraft:cornflower", "minecraft:lily_of_the_valley", "minecraft:wither_rose", "minecraft:brown_mushroom", "minecraft:red_mushroom", "minecraft:crimson_fungus", "minecraft:warped_fungus", "minecraft:crimson_roots", "minecraft:warped_roots", "minecraft:nether_sprouts", "minecraft:weeping_vines", "minecraft:twisting_vines", "minecraft:sugar_cane", "minecraft:kelp", "minecraft:bamboo", "minecraft:torch", "minecraft:end_rod", "minecraft:soul_torch", "minecraft:chain", "minecraft:vine", "minecraft:lily_pad", "minecraft:flower_pot", "minecraft:sunflower", "minecraft:lilac", "minecraft:rose_bush", "minecraft:peony", "minecraft:tall_grass", "minecraft:large_fern", "minecraft:glass_pane", "minecraft:white_stained_glass_pane", "minecraft:orange_stained_glass_pane", "minecraft:magenta_stained_glass_pane", "minecraft:light_blue_stained_glass_pane", "minecraft:yellow_stained_glass_pane", "minecraft:lime_stained_glass_pane", "minecraft:pink_stained_glass_pane", "minecraft:gray_stained_glass_pane", "minecraft:light_gray_stained_glass_pane", "minecraft:cyan_stained_glass_pane", "minecraft:purple_stained_glass_pane", "minecraft:blue_stained_glass_pane", "minecraft:brown_stained_glass_pane", "minecraft:green_stained_glass_pane", "minecraft:red_stained_glass_pane", "minecraft:black_stained_glass_pane", "minecraft:tube_coral", "minecraft:brain_coral", "minecraft:bubble_coral", "minecraft:fire_coral", "minecraft:horn_coral", "minecraft:dead_brain_coral", "minecraft:dead_bubble_coral", "minecraft:dead_horn_coral", "minecraft:dead_tube_coral", "minecraft:tube_coral_fan", "minecraft:brain_coral_fan", "minecraft:bubble_coral_fan", "minecraft:fire_coral_fan", "minecraft:horn_coral_fan", "minecraft:dead_tube_coral_fan", "minecraft:dead_brain_coral_fan", "minecraft:dead_bubble_coral_fan", "minecraft:dead_fire_coral_fan", "minecraft:dead_horn_coral_fan", "minecraft:oak_sign", "minecraft:spruce_sign", "minecraft:birch_sign", "minecraft:jungle_sign", "minecraft:acacia_sign", "minecraft:dark_oak_sign", "minecraft:crimson_sign", "minecraft:warped_sign", "minecraft:campfire", "minecraft:lantern", "minecraft:soul_lantern", "minecraft:bell", "minecraft:soul_campfire", "minecraft:redstone_torch", "minecraft:lever", "minecraft:tripwire_hook", "minecraft:string", "minecraft:hopper", "minecraft:iron_door", "minecraft:oak_door", "minecraft:spruce_door", "minecraft:birch_door", "minecraft:jungle_door", "minecraft:acacia_door", "minecraft:dark_oak_door", "minecraft:crimson_door", "minecraft:warped_door", "minecraft:repeater", "minecraft:comparator", "minecraft:redstone", "minecraft:rail", "minecraft:powered_rail", "minecraft:detector_rail", "minecraft:activator_rail", "minecraft:cake", "lightmanscurrency:coinpile_copper", "lightmanscurrency:coinpile_iron", "lightmanscurrency:coinpile_gold", "lightmanscurrency:coinpile_emerald", "lightmanscurrency:coinpile_diamond", "lightmanscurrency:coinpile_netherite"});
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    public static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    public static boolean canMint(Item item) {
        if (item == ModItems.COIN_COPPER) {
            return (Boolean)Config.SERVER.mintCopper.get();
        }
        if (item == ModItems.COIN_IRON) {
            return (Boolean)Config.SERVER.mintIron.get();
        }
        if (item == ModItems.COIN_GOLD) {
            return (Boolean)Config.SERVER.mintGold.get();
        }
        if (item == ModItems.COIN_EMERALD) {
            return (Boolean)Config.SERVER.mintEmerald.get();
        }
        if (item == ModItems.COIN_DIAMOND) {
            return (Boolean)Config.SERVER.mintDiamond.get();
        }
        if (item == ModItems.COIN_NETHERITE) {
            return (Boolean)Config.SERVER.mintNetherite.get();
        }
        return true;
    }

    public static boolean canMelt(Item item) {
        if (item == ModItems.COIN_COPPER) {
            return (Boolean)Config.SERVER.meltCopper.get();
        }
        if (item == ModItems.COIN_IRON) {
            return (Boolean)Config.SERVER.meltIron.get();
        }
        if (item == ModItems.COIN_GOLD) {
            return (Boolean)Config.SERVER.meltGold.get();
        }
        if (item == ModItems.COIN_EMERALD) {
            return (Boolean)Config.SERVER.meltEmerald.get();
        }
        if (item == ModItems.COIN_DIAMOND) {
            return (Boolean)Config.SERVER.meltDiamond.get();
        }
        if (item == ModItems.COIN_NETHERITE) {
            return (Boolean)Config.SERVER.meltNetherite.get();
        }
        return true;
    }

    public static String formatValueDisplay(double value) {
        return ((String)Config.SERVER.valueFormat.get()).replace("{value}", Config.formatValueOnly(value));
    }

    public static String formatValueOnly(double value) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(Config.getMaxDecimal());
        return df.format(value);
    }

    private static int getMaxDecimal() {
        double minFraction = MoneyUtil.getData(new CoinValue((long)1L).coinValues.get((int)0).coin).getDisplayValue() % 1.0;
        if (minFraction > 0.0) {
            return Double.toString(minFraction).length() - 2;
        }
        return 0;
    }

    public static Item getBaseCoinItem() {
        Item coinItem = null;
        try {
            coinItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)Config.SERVER.valueBaseCoin.get()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (coinItem != null && MoneyUtil.isCoin(coinItem)) {
            return coinItem;
        }
        return ModItems.COIN_GOLD;
    }

    static {
        Pair clientPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)clientPair.getRight();
        CLIENT = (Client)clientPair.getLeft();
        Pair commonPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)commonPair.getRight();
        COMMON = (Common)commonPair.getLeft();
        Pair serverPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)serverPair.getRight();
        SERVER = (Server)serverPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.IntValue logLimit;
        public final ForgeConfigSpec.BooleanValue allowCoinMinting;
        public final ForgeConfigSpec.BooleanValue allowCoinMelting;
        public final ForgeConfigSpec.BooleanValue mintCopper;
        public final ForgeConfigSpec.BooleanValue mintIron;
        public final ForgeConfigSpec.BooleanValue mintGold;
        public final ForgeConfigSpec.BooleanValue mintEmerald;
        public final ForgeConfigSpec.BooleanValue mintDiamond;
        public final ForgeConfigSpec.BooleanValue mintNetherite;
        public final ForgeConfigSpec.BooleanValue meltCopper;
        public final ForgeConfigSpec.BooleanValue meltIron;
        public final ForgeConfigSpec.BooleanValue meltGold;
        public final ForgeConfigSpec.BooleanValue meltEmerald;
        public final ForgeConfigSpec.BooleanValue meltDiamond;
        public final ForgeConfigSpec.BooleanValue meltNetherite;
        public final ForgeConfigSpec.IntValue walletConvertLevel;
        public final ForgeConfigSpec.IntValue walletPickupLevel;
        public final ForgeConfigSpec.IntValue walletBankLevel;
        public final ForgeConfigSpec.EnumValue<CoinItem.CoinItemTooltipType> coinTooltipType;
        public final ForgeConfigSpec.EnumValue<CoinValue.ValueType> coinValueType;
        public final ForgeConfigSpec.EnumValue<CoinValue.ValueType> coinValueInputType;
        public final ForgeConfigSpec.ConfigValue<String> valueBaseCoin;
        public final ForgeConfigSpec.ConfigValue<String> valueFormat;
        public final ForgeConfigSpec.IntValue itemUpgradeCapacity1;
        public final ForgeConfigSpec.IntValue itemUpgradeCapacity2;
        public final ForgeConfigSpec.IntValue itemUpgradeCapacity3;
        public final ForgeConfigSpec.ConfigValue<String> currencyChannel;
        public final ForgeConfigSpec.ConfigValue<String> currencyCommandPrefix;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Server Config Settings").push("server");
            this.logLimit = builder.comment(new String[]{"The maximum number of text log entries allowed before old entries are deleted.", "Lower if you encounter packet size problems."}).defineInRange("logLimit", 100, 0, Integer.MAX_VALUE);
            this.allowCoinMinting = builder.comment("Determines whether or not coins should be craftable via the Coin Minting Machine.").translation("lightmanscurrency.configgui.canMintCoins").define("canMintCoins", true);
            this.allowCoinMelting = builder.comment("Determines whether or not coins can be melted back into their source material in the Coin Minting Machine.").translation("lightmanscurrency.configgui.canMeltCoins").define("canMeltCoins", false);
            builder.comment("Specific Coin Minting Settings.").push("coin_minting");
            this.mintCopper = builder.comment("Whether copper coins can be minted.").define("canMintCopper", true);
            this.mintIron = builder.comment("Whether iron coins can be minted.").define("canMintIron", true);
            this.mintGold = builder.comment("Whether gold coins can be minted.").define("canMintGold", true);
            this.mintEmerald = builder.comment("Whether emerald coins can be minted.").define("canMintEmerald", true);
            this.mintDiamond = builder.comment("Whether diamond coins can be minted.").define("canMintDiamond", true);
            this.mintNetherite = builder.comment("Whether netherite coins can be minted.").define("canMintNetherite", true);
            builder.pop();
            builder.comment("Specific Coin Melting Settings.").push("coin_melting");
            this.meltCopper = builder.comment("Whether copper coins can be melted.").define("canMeltCopper", true);
            this.meltIron = builder.comment("Whether iron coins can be melted.").define("canMeltIron", true);
            this.meltGold = builder.comment("Whether gold coins can be melted.").define("canMeltGold", true);
            this.meltEmerald = builder.comment("Whether emerald coins can be melted.").define("canMeltEmerald", true);
            this.meltDiamond = builder.comment("Whether diamond coins can be melted.").define("canMeltDiamond", true);
            this.meltNetherite = builder.comment("Whether netherite coins can be melted.").define("canMeltNetherite", true);
            builder.pop();
            builder.comment("Wallet Settings.").push("wallet");
            this.walletConvertLevel = builder.comment(new String[]{"The lowest level wallet capable of converting coins in the UI.", "0-Copper Wallet; 1-Iron Wallet; 2-Gold Wallet; 3-Emerald Wallet; 4-Diamond Wallet; 5-Netherite Wallet", "Must be less than or equal to 'pickupLevel'."}).defineInRange("convertLevel", 1, 0, 5);
            this.walletPickupLevel = builder.comment(new String[]{"The lowest level wallet capable of automatically collecting coins while equipped.", "0-Copper Wallet; 1-Iron Wallet; 2-Gold Wallet; 3-Emerald Wallet; 4-Diamond Wallet; 5-Netherite Wallet"}).defineInRange("pickupLevel", 2, 0, 5);
            this.walletBankLevel = builder.comment(new String[]{"The lowest level wallet capable of allowing transfers to/from your bank account.", "0-Copper Wallet; 1-Iron Wallet; 2-Gold Wallet; 3-Emerald Wallet; 4-Diamond Wallet; 5-Netherite Wallet"}).defineInRange("bankLevel", 5, 0, 5);
            builder.pop();
            builder.comment("Coin value display settings.").push("coin_value_display");
            this.coinTooltipType = builder.comment(new String[]{"Tooltip type displayed on coin items.", "DEFAULT: Conversion tooltips, explaining it's value based on the coins it can be converted to/from.", "VALUE: Coins numerical display value as defined by the coinValueType option below. Not recommend if using the DEFAULT coinValueType."}).defineEnum("coinTooltipType", (Enum)CoinItem.CoinItemTooltipType.DEFAULT);
            this.coinValueType = builder.comment(new String[]{"Value display method used throughout the mod.", "DEFAULT: Coin Count & Icon aglomerate (1n5g for 1 netherite and 5 gold)", "VALUE: Coin numerical display value as defined by the baseValueCoin and valueFormat config options below."}).defineEnum("coinValueType", (Enum)CoinValue.ValueType.DEFAULT);
            this.coinValueInputType = builder.comment(new String[]{"Input method used for the Coin Value Input.", "DEFAULT: Default coin input with up/down buttons for each coin type.", "VALUE: Text box input for the coins display value."}).defineEnum("coinValueInputType", (Enum)CoinValue.ValueType.DEFAULT);
            this.valueBaseCoin = builder.comment("Coin item defined as 1 value unit for display purposes. Any coins worth less than the base coin will have a decimal value.").define("baseValueCoin", (Object)"lightmanscurrency:coin_copper");
            this.valueFormat = builder.comment(new String[]{"Value display format. Used to add currency signs to coin value displays.", "{value} will be replaced with the coins numerical value. Only 1 should be present at any given time."}).define("valueFormat", (Object)"${value}");
            builder.pop();
            builder.comment("Item Capacity Upgrade Settings").push("upgrades");
            this.itemUpgradeCapacity1 = builder.comment("The amount of item storage added by the first Item Capacity upgrade (Iron).").defineInRange("upgradeCapacity1", 192, 1, 1728);
            this.itemUpgradeCapacity2 = builder.comment("The amount of item storage added by the second Item Capacity upgrade (Gold).").defineInRange("upgradeCapacity2", 384, 1, 1728);
            this.itemUpgradeCapacity3 = builder.comment("The amount of item storage added by the third Item Capacity upgrade (Diamond).").defineInRange("upgradeCapacity3", 576, 1, 1728);
            builder.pop();
            builder.comment("Discord bot settings. Requires lightmansdiscord v0.0.3.0+ to use.").push("discord");
            this.currencyChannel = builder.comment("The channel where users can run the currency commands and where currency related announcements will be made.").define("channel", (Object)"000000000000000000");
            this.currencyCommandPrefix = builder.comment("Prefix for currency commands.").define("prefix", (Object)"!");
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> renderBlocksAsItems;
        public final ForgeConfigSpec.EnumValue<TraderRenderType> traderRenderType;
        public final ForgeConfigSpec.BooleanValue renderWalletButton;
        public final ForgeConfigSpec.IntValue walletButtonX;
        public final ForgeConfigSpec.IntValue walletButtonY;
        public final ForgeConfigSpec.IntValue walletButtonCreativeX;
        public final ForgeConfigSpec.IntValue walletButtonCreativeY;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client configuration settings").push("client");
            this.renderBlocksAsItems = builder.comment("BlockItems that should be spaced out as though they were normal items.").defineList("renderBlocksAsItems", CLIENT_DEFAULT_RENDER_AS_BLOCK, o -> o instanceof String);
            builder.comment("Quality Settings").push("settings");
            this.traderRenderType = builder.comment(new String[]{"How many items the traders should render as stock. Useful to avoid lag in trader-rich areas.", "FULL: Renders all items based on stock as intended.", "PARTIAL: Renders only 1 item per trade slot regardless of stock.", "NONE: Traders do not render items."}).defineEnum("traderRenderType", (Enum)TraderRenderType.FULL);
            builder.pop();
            builder.comment("Wallet Button Settings").push("wallet_button");
            this.renderWalletButton = builder.comment("Whether a wallet button should appear on the inventory screen, allowing you to open the wallet screen without use of the keybind.").define("renderButton", true);
            this.walletButtonX = builder.comment("The x position that the button should be placed at.").defineInRange("buttonX", 176, -50, 255);
            this.walletButtonY = builder.comment("The y position that the button should be placed at.").defineInRange("buttonY", 0, -50, 255);
            this.walletButtonCreativeX = builder.comment("The x position that the button should be placed at in the creative screen.").defineInRange("buttonCreativeX", 195, -50, 255);
            this.walletButtonCreativeY = builder.comment("The y position that the button should be placed at.").defineInRange("buttonCreativeY", 0, -50, 255);
            builder.pop();
        }

        public static enum TraderRenderType {
            FULL,
            PARTIAL,
            NONE;

        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue addCustomWanderingTrades;
        public final ForgeConfigSpec.BooleanValue addBankerVillager;
        public final ForgeConfigSpec.BooleanValue addCashierVillager;
        public final ForgeConfigSpec.IntValue debugLevel;
        public final ForgeConfigSpec.BooleanValue enableEntityDrops;
        public final ForgeConfigSpec.BooleanValue enableSpawnerEntityDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> copperEntityDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> ironEntityDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> goldEntityDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> emeraldEntityDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> diamondEntityDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> netheriteEntityDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> bossCopperEntityDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> bossIronEntityDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> bossGoldEntityDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> bossEmeraldEntityDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> bossDiamondEntityDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> bossNetheriteEntityDrops;
        public final ForgeConfigSpec.BooleanValue enableChestLoot;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> copperChestDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> ironChestDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> goldChestDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> emeraldChestDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> diamondChestDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> netheriteChestDrops;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common configuration settings").push("common");
            builder.comment("Villager Related Settings.").push("villagers");
            this.addCustomWanderingTrades = builder.comment("Whether the wandering trader will have additional trades that allow you to buy misc items with money.").define("addCustomWanderingTrades", true);
            this.addBankerVillager = builder.comment("Whether the banker villager profession will have any registered trades. The banker sells Lightman's Currency items for coins.").define("addBanker", true);
            this.addCashierVillager = builder.comment("Whether the cashier villager profession will have any registered trades.. The cashier sells an amalgamation of vanilla traders products for coins.").define("addCashier", true);
            builder.pop();
            this.debugLevel = builder.comment(new String[]{"Level of debug messages to be shown in the logs.", "0-All debug messages. 1-Warnings/Errors only. 2-Errors only. 3-No debug messages.", "Note: All debug messages will still be sent debug.log regardless of settings."}).defineInRange("debugLevel", 0, 0, 3);
            builder.comment("Entity loot settings. Accepts entity ids (i.e. minecraft:zombie)").push("entity_loot");
            this.enableEntityDrops = builder.comment("Whether coins can be dropped by entities. Does not effect chest loot generation.").define("enableEntityDrops", true);
            this.enableSpawnerEntityDrops = builder.comment("Whether coins can be dropped by entities that were spawned by the vanilla spawner.").define("enableSpawnerEntityDrops", false);
            this.copperEntityDrops = builder.comment("Entities that will occasionally drop copper coins.").defineList("copper", LootManager.ENTITY_COPPER_DROPLIST, o -> o instanceof String);
            this.ironEntityDrops = builder.comment("Entities that will occasionally drop copper -> iron coins.").defineList("iron", LootManager.ENTITY_IRON_DROPLIST, o -> o instanceof String);
            this.goldEntityDrops = builder.comment("Entities that will occasionally drop copper -> gold coins.").defineList("gold", LootManager.ENTITY_GOLD_DROPLIST, o -> o instanceof String);
            this.emeraldEntityDrops = builder.comment("Entities that will occasionally drop copper -> emerald coins.").defineList("emerald", LootManager.ENTITY_EMERALD_DROPLIST, o -> o instanceof String);
            this.diamondEntityDrops = builder.comment("Entities that will occasionally drop copper -> diamond coins.").defineList("diamond", LootManager.ENTITY_DIAMOND_DROPLIST, o -> o instanceof String);
            this.netheriteEntityDrops = builder.comment("Entities that will occasionally drop copper -> netherite coins.").defineList("netherite", LootManager.ENTITY_NETHERITE_DROPLIST, o -> o instanceof String);
            this.bossCopperEntityDrops = builder.comment("Entities that will drop a large amount of copper coins.").defineList("boss_copper", LootManager.ENTITY_BOSS_COPPER_DROPLIST, o -> o instanceof String);
            this.bossIronEntityDrops = builder.comment("Entities that will drop a large amount of copper -> iron coins.").defineList("boss_iron", LootManager.ENTITY_BOSS_IRON_DROPLIST, o -> o instanceof String);
            this.bossGoldEntityDrops = builder.comment("Entities that will drop a large amount of copper -> gold coins.").defineList("boss_gold", LootManager.ENTITY_BOSS_GOLD_DROPLIST, o -> o instanceof String);
            this.bossEmeraldEntityDrops = builder.comment("Entities that will drop a large amount of copper -> emerald coins.").defineList("boss_emerald", LootManager.ENTITY_BOSS_EMERALD_DROPLIST, o -> o instanceof String);
            this.bossDiamondEntityDrops = builder.comment("Entities that will drop a large amount of copper -> diamond coins.").defineList("boss_diamond", LootManager.ENTITY_BOSS_DIAMOND_DROPLIST, o -> o instanceof String);
            this.bossNetheriteEntityDrops = builder.comment("Entities that will drop a large amount of copper -> netherite coins.").defineList("boss_netherite", LootManager.ENTITY_BOSS_NETHERITE_DROPLIST, o -> o instanceof String);
            builder.pop();
            builder.comment("Chest loot settings.").push("chest_loot");
            this.enableChestLoot = builder.comment("Whether coins can spawn in chests Does not effect entity loot drops.").define("enableChestLoot", true);
            this.copperChestDrops = builder.comment("Chests that will occasionally spawn copper coins.").defineList("copper", LootManager.CHEST_COPPER_DROPLIST, o -> o instanceof String);
            this.ironChestDrops = builder.comment("Chests that will occasionally spawn copper -> iron coins.").defineList("iron", LootManager.CHEST_IRON_DROPLIST, o -> o instanceof String);
            this.goldChestDrops = builder.comment("Chests that will occasionally spawn copper -> gold coins.").defineList("gold", LootManager.CHEST_GOLD_DROPLIST, o -> o instanceof String);
            this.emeraldChestDrops = builder.comment("Chests that will occasionally spawn copper -> emerald coins.").defineList("emerald", LootManager.CHEST_EMERALD_DROPLIST, o -> o instanceof String);
            this.diamondChestDrops = builder.comment("Chests that will occasionally spawn copper -> diamond coins.").defineList("diamond", LootManager.CHEST_DIAMOND_DROPLIST, o -> o instanceof String);
            this.netheriteChestDrops = builder.comment("Chests that will occasionally spawn copper -> netherite coins.").defineList("netherite", LootManager.CHEST_NETHERITE_DROPLIST, o -> o instanceof String);
            builder.pop();
        }
    }
}

