/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blockentity;

import io.github.lightman314.lightmanscurrency.blockentity.UniversalTraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.blockentity.handler.ItemInterfaceHandler;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.menus.ItemInterfaceMenu;
import io.github.lightman314.lightmanscurrency.menus.containers.LockableContainer;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.common.TradeContext;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class UniversalItemTraderInterfaceBlockEntity
extends UniversalTraderInterfaceBlockEntity<ItemTradeData> {
    public static final int BUFFER_SIZE = 9;
    private LockableContainer itemBuffer = new LockableContainer(9, this::setItemBufferDirty);
    ItemInterfaceHandler itemHandler = this.addHandler(new ItemInterfaceHandler(this, this::getItemBuffer));

    public LockableContainer getItemBuffer() {
        return this.itemBuffer;
    }

    public ItemInterfaceHandler getItemHandler() {
        return this.itemHandler;
    }

    public UniversalItemTraderInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.TRADER_INTERFACE_ITEM, pos, state, ItemTradeData::loadData);
    }

    @Override
    public TradeContext getRemoteTradeData() {
        return TradeContext.create((ITrader)this.getTrader(), this.owner).withBankAccount(this.getBankAccount()).withItemHandler(this.itemBuffer).build();
    }

    public boolean allowAnyInput() {
        IItemTrader trader;
        if (this.getInteractionType().trades) {
            ItemTradeData trade = (ItemTradeData)this.getReferencedTrade();
            return trade != null && (trade.isPurchase() || trade.isBarter());
        }
        if (this.getInteractionType().restocks && (trader = this.getItemTrader()) != null) {
            for (int i = 0; i < trader.getTradeCount(); ++i) {
                ItemTradeData trade = (ItemTradeData)trader.getTrade(i);
                if (!trade.isValid() || !trade.isSale() && !trade.isBarter()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean allowItemInput(ItemStack item) {
        IItemTrader trader;
        if (this.getInteractionType().trades) {
            ItemTradeData trade = (ItemTradeData)this.getReferencedTrade();
            if (trade != null) {
                if (trade.isPurchase()) {
                    return InventoryUtil.ItemMatches(item, trade.getSellItem(0)) || InventoryUtil.ItemMatches(item, trade.getSellItem(1));
                }
                if (trade.isBarter()) {
                    return InventoryUtil.ItemMatches(item, trade.getBarterItem(0)) || InventoryUtil.ItemMatches(item, trade.getBarterItem(1));
                }
            }
        } else if (this.getInteractionType().restocks && (trader = this.getItemTrader()) != null) {
            for (int i = 0; i < trader.getTradeCount(); ++i) {
                ItemTradeData trade = (ItemTradeData)trader.getTrade(i);
                if ((!trade.isValid() || !trade.isSale() && !trade.isBarter() || !InventoryUtil.ItemMatches(item, trade.getSellItem(0))) && !InventoryUtil.ItemMatches(item, trade.getSellItem(1))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean allowAnyOutput() {
        if (this.getInteractionType().trades) {
            ItemTradeData trade = (ItemTradeData)this.getReferencedTrade();
            return trade != null && (trade.isSale() || trade.isBarter());
        }
        if (this.getInteractionType().drains) {
            IItemTrader trader = this.getItemTrader();
            for (int i = 0; i < trader.getTradeCount(); ++i) {
                ItemTradeData trade = (ItemTradeData)trader.getTrade(i);
                if (!trade.isValid() || !trade.isSale() && !trade.isBarter()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean allowItemOutput(ItemStack item) {
        return !this.allowItemInput(item);
    }

    @Override
    protected ItemTradeData deserializeTrade(CompoundTag compound) {
        return ItemTradeData.loadData(compound);
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.saveItemBuffer(compound);
    }

    protected final CompoundTag saveItemBuffer(CompoundTag compound) {
        compound.m_128365_("ItemBuffer", (Tag)this.itemBuffer.save(new CompoundTag()));
        return compound;
    }

    public void setItemBufferDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveItemBuffer(new CompoundTag()));
        }
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128425_("ItemBuffer", 10)) {
            this.itemBuffer.load(compound.m_128469_("ItemBuffer"));
        }
    }

    @Override
    protected boolean validTraderType(UniversalTraderData trader) {
        return trader instanceof IItemTrader;
    }

    protected final IItemTrader getItemTrader() {
        UniversalTraderData trader = this.getTrader();
        if (trader instanceof IItemTrader) {
            return (IItemTrader)((Object)trader);
        }
        return null;
    }

    @Override
    protected void drainTick() {
        IItemTrader trader = this.getItemTrader();
        if (trader != null && trader.hasPermission(this.owner, "interactionLink")) {
            for (int i = 0; i < trader.getTradeCount(); ++i) {
                ItemTradeData trade = (ItemTradeData)trader.getTrade(i);
                if (!trade.isValid()) continue;
                ArrayList<ItemStack> drainItems = new ArrayList<ItemStack>();
                if (trade.isPurchase()) {
                    drainItems.add(trade.getSellItem(0));
                    drainItems.add(trade.getSellItem(1));
                }
                if (trade.isBarter()) {
                    drainItems.add(trade.getBarterItem(0));
                    drainItems.add(trade.getBarterItem(1));
                }
                for (ItemStack drainItem : drainItems) {
                    int drainableAmount;
                    if (drainItem.m_41619_() || (drainableAmount = trader.getStorage().getItemCount(drainItem)) <= 0) continue;
                    ItemStack movingStack = drainItem.m_41777_();
                    movingStack.m_41764_(Math.min(movingStack.m_41741_(), drainableAmount));
                    ItemStack removed = trader.getStorage().removeItem(movingStack);
                    ItemStack leftovers = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemBuffer, (ItemStack)removed, (boolean)false);
                    if (!leftovers.m_41619_()) {
                        trader.getStorage().forceAddItem(leftovers);
                    }
                    trader.markStorageDirty();
                }
            }
        }
    }

    @Override
    protected void restockTick() {
        IItemTrader trader = this.getItemTrader();
        if (trader != null && trader.hasPermission(this.owner, "interactionLink")) {
            for (int i = 0; i < trader.getTradeCount(); ++i) {
                ItemTradeData trade = (ItemTradeData)trader.getTrade(i);
                if (!trade.isValid() || !trade.isBarter() && !trade.isSale()) continue;
                for (int s = 0; s < 2; ++s) {
                    int stockableAmount;
                    ItemStack stockItem = trade.getSellItem(s);
                    if (stockItem.m_41619_() || (stockableAmount = InventoryUtil.GetItemCount((Container)this.itemBuffer.getContainer(), stockItem)) <= 0) continue;
                    ItemStack movingStack = stockItem.m_41777_();
                    movingStack.m_41764_(Math.min(movingStack.m_41741_(), stockableAmount));
                    if (InventoryUtil.RemoveItemCount((Container)this.itemBuffer.getContainer(), movingStack)) {
                        ItemStack leftovers;
                        trader.getStorage().tryAddItem(movingStack);
                        if (!(movingStack.m_41619_() || (leftovers = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemBuffer, (ItemStack)movingStack, (boolean)false)).m_41619_() || (leftovers = InventoryUtil.TryPutItemStack((Container)this.itemBuffer.getContainer(), leftovers)).m_41619_() || leftovers.m_41619_())) {
                            InventoryUtil.dumpContents(this.f_58857_, this.f_58858_, leftovers);
                        }
                    }
                    trader.markStorageDirty();
                }
            }
        }
    }

    @Override
    protected void tradeTick() {
        ItemTradeData trade = (ItemTradeData)this.getTrueTrade();
        if (trade != null && trade.isValid()) {
            this.itemBuffer.dontHonorFullLocks();
            this.itemBuffer.setAdditionalRules(null);
            if (trade.isSale()) {
                if (ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemBuffer, (ItemStack)trade.getSellItem(0), (boolean)true).m_41619_()) {
                    this.interactWithTrader();
                    this.setItemBufferDirty();
                }
            } else if (trade.isPurchase()) {
                if (InventoryUtil.GetItemCount((Container)this.itemBuffer.getContainer(), trade.getSellItem(0)) >= trade.getSellItem(0).m_41613_()) {
                    this.interactWithTrader();
                    this.setItemBufferDirty();
                }
            } else if (trade.isBarter() && InventoryUtil.GetItemCount((Container)this.itemBuffer.getContainer(), trade.getBarterItem(0)) > trade.getBarterItem(0).m_41613_() && ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemBuffer, (ItemStack)trade.getSellItem(0), (boolean)true).m_41619_()) {
                this.interactWithTrader();
                this.setItemBufferDirty();
            }
            this.itemBuffer.honorFullLocks();
        }
    }

    @Override
    protected MenuProvider getMenuProvider() {
        return new Provider(this);
    }

    @Override
    public void dumpContents(Level level, BlockPos pos) {
        InventoryUtil.dumpContents(level, pos, (Container)this.itemBuffer.getContainer());
    }

    private static class Provider
    implements MenuProvider {
        private final UniversalItemTraderInterfaceBlockEntity blockEntity;

        Provider(UniversalItemTraderInterfaceBlockEntity blockEntity) {
            this.blockEntity = blockEntity;
        }

        public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
            return new ItemInterfaceMenu(windowId, inventory, this.blockEntity);
        }

        public Component m_5446_() {
            return new TextComponent("");
        }
    }
}

