/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.itemInterface.InfoTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.itemInterface.InputOutputTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.itemInterface.ItemInterfaceTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.itemInterface.TraderSelectTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TabButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.menus.ItemInterfaceMenu;
import io.github.lightman314.lightmanscurrency.menus.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.interfacebe.MessageToggleInteractionActive;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ItemInterfaceScreen
extends AbstractContainerScreen<ItemInterfaceMenu> {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/container/item_interface.png");
    int currentTabIndex = 0;
    List<ItemInterfaceTab> tabs = Lists.newArrayList((Object[])new ItemInterfaceTab[]{new InfoTab(this), new InputOutputTab(this), new TraderSelectTab(this)});
    List<AbstractWidget> tabWidgets = Lists.newArrayList();
    List<GuiEventListener> tabListeners = Lists.newArrayList();
    List<TabButton> tabButtons = Lists.newArrayList();
    IconButton buttonActivate;
    boolean logError = true;

    public List<ItemInterfaceTab> getTabs() {
        return this.tabs;
    }

    public ItemInterfaceTab currentTab() {
        return this.tabs.get(this.currentTabIndex);
    }

    public ItemInterfaceScreen(ItemInterfaceMenu container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.f_97727_ = 212;
        this.f_97726_ = 176;
    }

    protected void m_7286_(PoseStack pose, float partialTicks, int mouseX, int mouseY) {
        block3: {
            RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.m_93228_(pose, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
            if (this.currentTab().hideItemSlots) {
                this.m_93228_(pose, this.f_97735_ + 7, this.f_97736_ + 97, 7, 79, 162, 18);
            }
            try {
                this.currentTab().preRender(pose, mouseX, mouseY, partialTicks);
                this.tabWidgets.forEach(widget -> widget.m_6305_(pose, mouseX, mouseY, partialTicks));
            }
            catch (Exception e) {
                if (!this.logError) break block3;
                LightmansCurrency.LogError("Error rendering " + this.currentTab().getClass().getName() + " tab.", e);
                this.logError = false;
            }
        }
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(poseStack, this.f_169604_, 8.0f, (float)(this.f_97727_ - 94), 0x404040);
    }

    protected void m_7856_() {
        super.m_7856_();
        for (int i = 0; i < this.tabs.size(); ++i) {
            TabButton button = (TabButton)this.m_142416_((GuiEventListener)new TabButton(this::clickedOnTab, this.f_96547_, this.tabs.get(i)));
            button.reposition(this.f_97735_ - 25, this.f_97736_ + i * 25, 3);
            button.f_93623_ = i != this.currentTabIndex;
            this.tabButtons.add(button);
        }
        this.buttonActivate = (IconButton)this.m_142416_((GuiEventListener)IconAndButtonUtil.interfaceActiveToggleButton(this.f_97735_ + this.f_97726_, this.f_97736_, this::ToggleActive, ((ItemInterfaceMenu)this.f_97732_).blockEntity::interactionActive));
        this.validateTabs();
        this.currentTab().init();
        this.m_181908_();
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        block3: {
            this.m_7333_(pose);
            super.m_6305_(pose, mouseX, mouseY, partialTicks);
            try {
                this.currentTab().postRender(pose, mouseX, mouseY);
            }
            catch (Exception e) {
                if (!this.logError) break block3;
                LightmansCurrency.LogError("Error rendering " + this.currentTab().getClass().getName() + " tab.", e);
                this.logError = false;
            }
        }
        this.m_7025_(pose, mouseX, mouseY);
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            if (!this.tabButtons.get(i).m_5953_(mouseX, mouseY)) continue;
            this.m_96602_(pose, this.tabButtons.get((int)i).tab.getTooltip(), mouseX, mouseY);
        }
    }

    public void changeTab(int tabIndex) {
        this.currentTab().onClose();
        if (this.currentTab().hideItemSlots) {
            SimpleSlot.SetActive(this.f_97732_);
        }
        this.tabButtons.get((int)this.currentTabIndex).f_93623_ = true;
        this.currentTabIndex = tabIndex;
        this.tabButtons.get((int)this.currentTabIndex).f_93623_ = false;
        this.tabWidgets.clear();
        this.tabListeners.clear();
        this.currentTab().init();
        if (this.currentTab().hideItemSlots) {
            SimpleSlot.SetInactive(this.f_97732_);
        }
        this.logError = true;
    }

    private void clickedOnTab(Button tab) {
        int tabIndex = this.tabButtons.indexOf(tab);
        if (tabIndex < 0) {
            return;
        }
        this.changeTab(tabIndex);
    }

    public void m_181908_() {
        this.buttonActivate.f_93623_ = this.validState();
        this.validateTabs();
        this.currentTab().tick();
    }

    private void validateTabs() {
        boolean changed = false;
        for (int i = 0; i < this.tabs.size() && i < this.tabButtons.size(); ++i) {
            boolean valid = this.tabs.get(i).valid(((ItemInterfaceMenu)this.f_97732_).blockEntity.getInteractionType());
            if (valid == this.tabButtons.get((int)i).f_93624_) continue;
            this.tabButtons.get((int)i).f_93624_ = valid;
            changed = true;
        }
        if (changed) {
            int pos = 0;
            for (TabButton button : this.tabButtons) {
                if (!button.f_93624_) continue;
                button.reposition(this.f_97735_ - 25, this.f_97736_ + pos++ * 25, 3);
            }
        }
    }

    public <T extends AbstractWidget> T addRenderableTabWidget(T widget) {
        this.tabWidgets.add(widget);
        return widget;
    }

    public void removeRenderableTabWidget(AbstractWidget widget) {
        if (this.tabWidgets.contains(widget)) {
            this.tabWidgets.remove(widget);
        }
    }

    public <T extends GuiEventListener> T addTabListener(T listener) {
        this.tabListeners.add(listener);
        return listener;
    }

    public void removeTabListener(GuiEventListener listener) {
        if (this.tabListeners.contains(listener)) {
            this.tabListeners.remove(listener);
        }
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public List<? extends GuiEventListener> m_6702_() {
        List coreListeners = super.m_6702_();
        ArrayList listeners = Lists.newArrayList();
        for (int i = 0; i < coreListeners.size(); ++i) {
            listeners.add((GuiEventListener)coreListeners.get(i));
        }
        listeners.addAll(this.tabWidgets);
        listeners.addAll(this.tabListeners);
        return listeners;
    }

    public boolean m_5534_(char c, int code) {
        if (this.currentTab().charTyped(c, code)) {
            return true;
        }
        return super.m_5534_(c, code);
    }

    public boolean m_7933_(int key, int scanCode, int mods) {
        if (this.currentTab().keyPressed(key, scanCode, mods)) {
            return true;
        }
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)key, (int)scanCode);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey) && this.currentTab().blockInventoryClosing()) {
            return true;
        }
        return super.m_7933_(key, scanCode, mods);
    }

    private void ToggleActive(Button button) {
        ((ItemInterfaceMenu)this.f_97732_).blockEntity.toggleActive();
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageToggleInteractionActive(((ItemInterfaceMenu)this.f_97732_).blockEntity.m_58899_(), ((ItemInterfaceMenu)this.f_97732_).blockEntity.interactionActive()));
    }

    public ItemTradeData getReferencedTrade() {
        ItemTradeData trade = (ItemTradeData)((ItemInterfaceMenu)this.f_97732_).blockEntity.getReferencedTrade();
        if (trade == null) {
            trade = new ItemTradeData();
        }
        return trade;
    }

    public ItemTradeData getTrueTrade() {
        ItemTradeData trade = (ItemTradeData)((ItemInterfaceMenu)this.f_97732_).blockEntity.getTrueTrade();
        if (trade == null) {
            trade = new ItemTradeData();
        }
        return trade;
    }

    public boolean validState() {
        if (((ItemInterfaceMenu)this.f_97732_).blockEntity.getInteractionType().requiresPermissions) {
            return ((ItemInterfaceMenu)this.f_97732_).blockEntity.validTrader();
        }
        if (((ItemInterfaceMenu)this.f_97732_).blockEntity.getInteractionType().trades) {
            return ((ItemInterfaceMenu)this.f_97732_).blockEntity.validTrade();
        }
        return false;
    }

    public boolean changeInTrades() {
        ItemTradeData referencedTrade = (ItemTradeData)((ItemInterfaceMenu)this.f_97732_).blockEntity.getReferencedTrade();
        ItemTradeData trueTrade = (ItemTradeData)((ItemInterfaceMenu)this.f_97732_).blockEntity.getTrueTrade();
        if (referencedTrade == null) {
            return false;
        }
        if (trueTrade == null) {
            return true;
        }
        return !referencedTrade.compare(trueTrade).Identical();
    }

    public List<Component> getTradeChangeMessage() {
        ArrayList<Component> list = new ArrayList<Component>();
        ItemTradeData referencedTrade = (ItemTradeData)((ItemInterfaceMenu)this.f_97732_).blockEntity.getReferencedTrade();
        ItemTradeData trueTrade = (ItemTradeData)((ItemInterfaceMenu)this.f_97732_).blockEntity.getTrueTrade();
        if (referencedTrade == null) {
            return list;
        }
        if (trueTrade == null) {
            list.add((Component)new TranslatableComponent("gui.lightmanscurrency.interface.item.difference.missing"));
            return list;
        }
        TradeData.TradeComparisonResult differences = referencedTrade.compare(trueTrade);
        if (!differences.TypeMatches()) {
            list.add((Component)new TranslatableComponent("gui.lightmanscurrency.interface.item.difference.type"));
            return list;
        }
        if (!differences.PriceMatches()) {
            long difference = differences.priceDifference();
            if (difference < 0L) {
                list.add((Component)new TranslatableComponent("gui.lightmanscurrency.interface.item.difference.expensive", new Object[]{MoneyUtil.getStringOfValue(-difference)}));
            } else {
                list.add((Component)new TranslatableComponent("gui.lightmanscurrency.interface.item.difference.cheaper", new Object[]{MoneyUtil.getStringOfValue(difference)}));
            }
        }
        for (int i = 0; i < differences.getProductResultCount(); ++i) {
            TranslatableComponent slotName = new TranslatableComponent("gui.lightmanscurrency.interface.item.difference.product." + i);
            TradeData.TradeComparisonResult.ProductComparisonResult productCheck = differences.getProductResult(i);
            if (!productCheck.SameProductType()) {
                list.add((Component)new TranslatableComponent("gui.lightmanscurrency.interface.item.difference.itemtype", new Object[]{slotName}));
                continue;
            }
            if (!productCheck.SameProductNBT()) {
                list.add((Component)new TranslatableComponent("gui.lightmanscurrency.interface.item.difference.itemnbt"));
                continue;
            }
            if (productCheck.SameProductQuantity()) continue;
            int quantityDifference = productCheck.ProductQuantityDifference();
            if (quantityDifference < 0) {
                list.add((Component)new TranslatableComponent("gui.lightmanscurrency.interface.item.difference.quantity.more", new Object[]{slotName, -quantityDifference}));
                continue;
            }
            list.add((Component)new TranslatableComponent("gui.lightmanscurrency.interface.item.difference.quantity.less", new Object[]{slotName, quantityDifference}));
        }
        return list;
    }
}

