/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.widget.BankAccountWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.menus.WalletMenu;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.wallet.MessageWalletConvertCoins;
import io.github.lightman314.lightmanscurrency.network.message.wallet.MessageWalletToggleAutoConvert;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.anti_ad.mc.ipn.api.IPNIgnore;

@IPNIgnore
public class WalletScreen
extends AbstractContainerScreen<WalletMenu>
implements BankAccountWidget.IBankAccountWidget {
    private final int BASEHEIGHT = 114;
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/container/wallet.png");
    private boolean walletSlotChanged = false;
    IconButton buttonToggleAutoConvert;
    Button buttonConvert;
    boolean autoConvert = false;
    BankAccountWidget bankWidget;

    public WalletScreen(WalletMenu container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        container.addListener(this::onContainerReload);
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        int y;
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int yOffset = ((WalletMenu)this.f_97732_).getVerticalOffset();
        this.m_93228_(poseStack, this.f_97735_ - 28, this.f_97736_ + yOffset, 18, 132, 28, 28);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_ + yOffset, 0, 0, this.f_97726_, 17);
        for (y = 0; y < ((WalletMenu)this.f_97732_).getRowCount(); ++y) {
            this.m_93228_(poseStack, this.f_97735_, this.f_97736_ + 17 + y * 18 + yOffset, 0, 17, this.f_97726_, 18);
        }
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_ + 17 + ((WalletMenu)this.f_97732_).getRowCount() * 18 + yOffset, 0, 35, this.f_97726_, 97);
        y = 0;
        while (y * 9 < ((WalletMenu)this.f_97732_).getSlotCount()) {
            for (int x = 0; x < 9 && x + y * 9 < ((WalletMenu)this.f_97732_).getSlotCount(); ++x) {
                this.m_93228_(poseStack, this.f_97735_ + 7 + x * 18, this.f_97736_ + 17 + y * 18 + yOffset, 0, 132, 18, 18);
            }
            ++y;
        }
        if (((WalletMenu)this.f_97732_).hasBankAccess() && this.bankWidget != null) {
            int yOff;
            int thisHeight;
            int startX = this.f_96543_ / 2 - 70 - 10;
            int startY = this.f_97736_ + 69;
            int width = 160;
            int height = 40;
            int xOff = 0;
            for (yOff = 0; yOff < height; yOff += thisHeight) {
                thisHeight = MathUtil.clamp(height - yOff, 0, 32);
                this.m_93228_(poseStack, startX, startY + yOff, 0, 8, 7, thisHeight);
            }
            for (yOff = 0; yOff < height; yOff += thisHeight) {
                thisHeight = MathUtil.clamp(height - yOff, 0, 32);
                this.m_93228_(poseStack, startX + width - 7, startY + yOff, 169, 8, 7, thisHeight);
            }
            while (xOff < width - 14) {
                int thisHeight2;
                int thisWidth = MathUtil.clamp(width - xOff - 14, 0, 18);
                for (yOff = 0; yOff < height; yOff += thisHeight2) {
                    thisHeight2 = MathUtil.clamp(height - yOff, 0, 32);
                    this.m_93228_(poseStack, startX + 7 + xOff, startY + yOff, 7, 8, thisWidth, thisHeight2);
                }
                xOff += thisWidth;
            }
            this.bankWidget.renderInfo(poseStack, -1);
        }
    }

    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(pose, ((WalletMenu)this.f_97732_).getTitle(), 8.0f, 6.0f + (float)((WalletMenu)this.f_97732_).getVerticalOffset(), 0x404040);
        this.f_96547_.m_92889_(pose, this.f_169604_, 8.0f, (float)(this.f_97727_ - 94), 0x404040);
    }

    protected void m_7856_() {
        int yOffset = ((WalletMenu)this.f_97732_).getVerticalOffset();
        this.f_97727_ = 114 + ((WalletMenu)this.f_97732_).getRowCount() * 18 + yOffset;
        this.f_97726_ = 176;
        super.m_7856_();
        this.m_169413_();
        this.buttonConvert = null;
        this.buttonToggleAutoConvert = null;
        this.bankWidget = null;
        if (((WalletMenu)this.f_97732_).canConvert()) {
            this.buttonConvert = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ - 20, this.f_97736_ + 28 + yOffset, this::PressConvertButton, IconData.of(GUI_TEXTURE, this.f_97726_, 0)));
            if (((WalletMenu)this.f_97732_).canPickup()) {
                this.buttonToggleAutoConvert = (IconButton)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ - 20, this.f_97736_ + 48 + yOffset, this::PressAutoConvertToggleButton, IconData.of(GUI_TEXTURE, this.f_97726_, 16)));
                this.updateToggleButton();
            }
        }
        if (((WalletMenu)this.f_97732_).hasBankAccess()) {
            this.bankWidget = new BankAccountWidget(this.f_97736_, this, -1);
            this.bankWidget.allowEmptyDeposits = false;
        }
    }

    private void onContainerReload() {
        this.walletSlotChanged = true;
    }

    public void m_181908_() {
        ((WalletMenu)this.f_97732_).clientTick();
        if (this.walletSlotChanged) {
            this.walletSlotChanged = false;
            this.m_7856_();
        }
        if (this.buttonToggleAutoConvert != null && ((WalletMenu)this.f_97732_).getAutoConvert() != this.autoConvert) {
            this.updateToggleButton();
        }
        if (this.bankWidget != null) {
            this.bankWidget.tick();
        }
    }

    private void updateToggleButton() {
        this.autoConvert = ((WalletMenu)this.f_97732_).getAutoConvert();
        this.buttonToggleAutoConvert.setIcon(IconData.of(GUI_TEXTURE, this.f_97726_, this.autoConvert ? 16 : 32));
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
        if (this.buttonConvert != null && this.buttonConvert.m_5953_((double)mouseX, (double)mouseY)) {
            this.m_96602_(matrixStack, (Component)new TranslatableComponent("tooltip.lightmanscurrency.wallet.convert"), mouseX, mouseY);
        } else if (this.buttonToggleAutoConvert != null && this.buttonToggleAutoConvert.m_5953_(mouseX, mouseY)) {
            if (this.autoConvert) {
                this.m_96602_(matrixStack, (Component)new TranslatableComponent("tooltip.lightmanscurrency.wallet.autoconvert.disable"), mouseX, mouseY);
            } else {
                this.m_96602_(matrixStack, (Component)new TranslatableComponent("tooltip.lightmanscurrency.wallet.autoconvert.enable"), mouseX, mouseY);
            }
        }
    }

    public void PressConvertButton(Button button) {
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageWalletConvertCoins());
    }

    public void PressAutoConvertToggleButton(Button button) {
        ((WalletMenu)this.f_97732_).ToggleAutoConvert();
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageWalletToggleAutoConvert());
    }

    @Override
    public <T extends GuiEventListener & Widget> T addCustomWidget(T widget) {
        return (T)this.m_142416_(widget);
    }

    @Override
    public Font getFont() {
        return this.f_96547_;
    }

    @Override
    public Screen getScreen() {
        return this;
    }

    @Override
    public int getWidth() {
        return this.f_96543_;
    }

    @Override
    public BankAccount getAccount() {
        return ((WalletMenu)this.f_97732_).getAccount();
    }

    @Override
    public Container getCoinAccess() {
        return ((WalletMenu)this.f_97732_).getCoinInput();
    }
}

