/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.ATMTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TeamButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.menus.ATMMenu;
import io.github.lightman314.lightmanscurrency.menus.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageATMSetAccount;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageATMSetPlayerAccount;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class SelectionTab
extends ATMTab {
    Button buttonPersonalAccount;
    TeamSelectWidget teamSelection;
    Button buttonToggleAdminMode;
    EditBox playerAccountSelect;
    Button buttonSelectPlayerAccount;
    Component responseMessage = new TextComponent("");
    boolean adminMode = false;
    boolean selectedSelf = true;
    UUID selectedTeam = null;

    public SelectionTab(ATMScreen screen) {
        super(screen);
    }

    @Override
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42516_);
    }

    @Override
    public Component getTooltip() {
        return new TranslatableComponent("tooltip.lightmanscurrency.atm.selection");
    }

    @Override
    public void init() {
        this.adminMode = false;
        this.responseMessage = new TextComponent("");
        SimpleSlot.SetInactive(this.screen.m_6262_());
        this.teamSelection = this.screen.addRenderableTabWidget(new TeamSelectWidget(this.screen.getGuiLeft() + 79, this.screen.getGuiTop() + 15, 5, TeamButton.Size.NARROW, this::getTeamList, this::selectedTeam, this::SelectTeam));
        this.teamSelection.init(this.screen::addRenderableTabWidget, this.screen.getFont());
        this.buttonPersonalAccount = this.screen.addRenderableTabWidget(new Button(this.screen.getGuiLeft() + 7, this.screen.getGuiTop() + 15, 70, 20, (Component)new TranslatableComponent("gui.button.bank.playeraccount"), this::PressPersonalAccount));
        this.buttonPersonalAccount.f_93623_ = this.selectedTeam != null;
        this.buttonToggleAdminMode = this.screen.addRenderableTabWidget(new IconButton(this.screen.getGuiLeft() + this.screen.getXSize(), this.screen.getGuiTop(), this::ToggleAdminMode, IconData.of((ItemLike)Items.f_42116_)));
        this.buttonToggleAdminMode.f_93624_ = TradingOffice.isAdminPlayer(((ATMMenu)this.screen.m_6262_()).getPlayer());
        this.playerAccountSelect = this.screen.addRenderableTabWidget(new EditBox(this.screen.getFont(), this.screen.getGuiLeft() + 7, this.screen.getGuiTop() + 20, 162, 20, (Component)new TextComponent("")));
        this.playerAccountSelect.f_93624_ = false;
        this.buttonSelectPlayerAccount = this.screen.addRenderableTabWidget(new Button(this.screen.getGuiLeft() + 7, this.screen.getGuiTop() + 45, 162, 20, (Component)new TranslatableComponent("gui.button.bank.admin.playeraccount"), this::PressSelectPlayerAccount));
        this.buttonSelectPlayerAccount.f_93624_ = false;
    }

    private List<Team> getTeamList() {
        ArrayList results = Lists.newArrayList();
        for (Team team : ClientTradingOffice.getTeamList()) {
            if (!team.hasBankAccount() || !team.canAccessBankAccount(((ATMMenu)this.screen.m_6262_()).getPlayer())) continue;
            results.add(team);
        }
        return results;
    }

    public Team selectedTeam() {
        if (this.selectedTeam != null) {
            return ClientTradingOffice.getTeam(this.selectedTeam);
        }
        return null;
    }

    public void SelectTeam(int teamIndex) {
        try {
            Team team = this.getTeamList().get(teamIndex);
            if (team.getID().equals(this.selectedTeam)) {
                return;
            }
            this.selectedTeam = team.getID();
            BankAccount.AccountReference accountSource = BankAccount.GenerateReference(true, team);
            ((ATMMenu)this.screen.m_6262_()).SetAccount(accountSource);
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageATMSetAccount(accountSource));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void PressPersonalAccount(Button button) {
        this.selectedTeam = null;
        this.selectedSelf = true;
        BankAccount.AccountReference accountSource = BankAccount.GenerateReference(((ATMMenu)this.screen.m_6262_()).getPlayer());
        ((ATMMenu)this.screen.m_6262_()).SetAccount(accountSource);
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageATMSetAccount(accountSource));
    }

    private void ToggleAdminMode(Button button) {
        this.adminMode = !this.adminMode;
        this.buttonPersonalAccount.f_93624_ = !this.adminMode;
        this.teamSelection.setVisible(!this.adminMode);
        this.buttonSelectPlayerAccount.f_93624_ = this.adminMode;
        this.playerAccountSelect.f_93624_ = this.adminMode;
    }

    private void PressSelectPlayerAccount(Button button) {
        String playerName = this.playerAccountSelect.m_94155_();
        this.playerAccountSelect.m_94144_("");
        if (!playerName.isBlank()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageATMSetPlayerAccount(playerName));
        }
    }

    public void ReceiveSelectPlayerResponse(BankAccount.AccountReference account, Component message) {
        if (account != null) {
            this.selectedSelf = false;
            ((ATMMenu)this.screen.m_6262_()).SetAccount(account);
        }
        this.responseMessage = message;
    }

    @Override
    public void preRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)ATMScreen.GUI_TEXTURE);
        this.screen.m_93228_(pose, this.screen.getGuiLeft() + 7, this.screen.getGuiTop() + 97, 7, 79, 162, 18);
        this.screen.getFont().m_92889_(pose, this.getTooltip(), (float)this.screen.getGuiLeft() + 8.0f, (float)this.screen.getGuiTop() + 6.0f, 0x404040);
        if (this.adminMode) {
            List lines = this.screen.getFont().m_92865_().m_92414_((FormattedText)this.responseMessage, this.screen.getXSize() - 15, Style.f_131099_);
            for (int i = 0; i < lines.size(); ++i) {
                Font font = this.screen.getFont();
                String string = ((FormattedText)lines.get(i)).getString();
                float f = this.screen.getGuiLeft() + 7;
                int n = this.screen.getGuiTop() + 70;
                Objects.requireNonNull(this.screen.getFont());
                font.m_92883_(pose, string, f, (float)(n + 9 * i), 0x404040);
            }
        }
    }

    @Override
    public void postRender(PoseStack pose, int mouseX, int mouseY) {
    }

    @Override
    public void tick() {
        this.buttonPersonalAccount.f_93623_ = this.selectedTeam != null || !this.selectedSelf;
        this.buttonToggleAdminMode.f_93624_ = TradingOffice.isAdminPlayer(((ATMMenu)this.screen.m_6262_()).getPlayer());
        if (this.adminMode) {
            this.playerAccountSelect.m_94120_();
        }
    }

    @Override
    public void onClose() {
        SimpleSlot.SetActive(this.screen.m_6262_());
    }
}

