/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.itemInterface;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.blockentity.UniversalTraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ItemInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.itemInterface.ItemInterfaceTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.DropdownWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollTextDisplay;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.ItemTradeButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.menus.ItemInterfaceMenu;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.interfacebe.MessageSetInteractionType;
import io.github.lightman314.lightmanscurrency.trader.common.TradeContext;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.ItemLike;

public class InfoTab
extends ItemInterfaceTab {
    ScrollTextDisplay changesDisplay;
    DropdownWidget interactionDropdown;

    public InfoTab(ItemInterfaceScreen screen) {
        super(screen, false);
    }

    @Override
    public IconData getIcon() {
        return IconData.of((ItemLike)ModItems.TRADING_CORE);
    }

    @Override
    public Component getTooltip() {
        return new TranslatableComponent("tooltip.lightmanscurrency.interface.info");
    }

    @Override
    public boolean valid(UniversalTraderInterfaceBlockEntity.InteractionType interaction) {
        return true;
    }

    @Override
    public void init() {
        this.changesDisplay = this.screen.addRenderableTabWidget(new ScrollTextDisplay(this.screen.getGuiLeft() + 10, this.screen.getGuiTop() + 15 + 18, 79, 30, this.screen.getFont(), (Supplier<List<? extends Component>>)((Supplier)this.screen::getTradeChangeMessage)));
        this.changesDisplay.backgroundColor = 0;
        this.interactionDropdown = this.screen.addRenderableTabWidget(IconAndButtonUtil.interactionTypeDropdown(this.screen.getGuiLeft() + 92, this.screen.getGuiTop() + 15 + 18, 80, this.screen.getFont(), ((ItemInterfaceMenu)this.screen.m_6262_()).blockEntity.getInteractionType(), this::onInteractionSelect, this.screen::addRenderableTabWidget));
    }

    @Override
    public void preRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        TradeContext.TradeResult lastResult;
        ItemTradeButton.renderItemTradeButton(pose, (Screen)this.screen, this.screen.getFont(), this.screen.getGuiLeft() + 10, this.screen.getGuiTop() + 10, this.screen.getReferencedTrade());
        if (this.screen.changeInTrades()) {
            ItemTradeButton.renderItemTradeButton(pose, (Screen)this.screen, this.screen.getFont(), this.screen.getGuiLeft() + this.screen.getXSize() - 79 - 10, this.screen.getGuiTop() + 10, this.screen.getTrueTrade());
        }
        this.changesDisplay.f_93624_ = this.screen.changeInTrades();
        if (((ItemInterfaceMenu)this.screen.m_6262_()).blockEntity.getInteractionType().trades && (lastResult = ((ItemInterfaceMenu)this.screen.m_6262_()).blockEntity.mostRecentTradeResult()).hasMessage()) {
            int messageWidth = this.screen.getFont().m_92852_((FormattedText)lastResult.failMessage);
            this.screen.getFont().m_92889_(pose, lastResult.failMessage, (float)(this.screen.getGuiLeft() + this.screen.getXSize() / 2 - messageWidth / 2), (float)(this.screen.getGuiTop() + 80), 0xFF0000);
        }
    }

    @Override
    public void postRender(PoseStack pose, int mouseX, int mouseY) {
        ItemTradeButton.tryRenderTooltip(pose, (Screen)this.screen, this.screen.getReferencedTrade(), this.screen.getGuiLeft() + 10, this.screen.getGuiTop() + 10, mouseX, mouseY);
        if (this.screen.changeInTrades()) {
            ItemTradeButton.tryRenderTooltip(pose, (Screen)this.screen, this.screen.getReferencedTrade(), this.screen.getGuiLeft() + this.screen.getXSize() - 79 - 10, this.screen.getGuiTop() + 10, mouseX, mouseY);
        }
    }

    @Override
    public void tick() {
    }

    @Override
    public void onClose() {
    }

    private void onInteractionSelect(int newTypeIndex) {
        UniversalTraderInterfaceBlockEntity.InteractionType newType = UniversalTraderInterfaceBlockEntity.InteractionType.fromIndex(newTypeIndex);
        ((ItemInterfaceMenu)this.screen.m_6262_()).blockEntity.setInteractionType(newType);
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageSetInteractionType(((ItemInterfaceMenu)this.screen.m_6262_()).blockEntity.m_58899_(), newType));
    }
}

