/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.settings.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TraderSettingsScreen;
import io.github.lightman314.lightmanscurrency.client.gui.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.trader.settings.CoreTraderSettings;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class OwnershipTab
extends SettingsTab {
    public static final OwnershipTab INSTANCE = new OwnershipTab();
    EditBox newOwnerInput;
    Button buttonSetOwner;
    TeamSelectWidget teamSelection;
    Button buttonSetTeamOwner;
    UUID selectedTeam = null;
    List<Team> teamList = Lists.newArrayList();

    @Override
    public int getColor() {
        return 0xFFFFFF;
    }

    @Override
    public IconData getIcon() {
        return IconData.of(ItemRenderUtil.getAlexHead());
    }

    @Override
    public Component getTooltip() {
        return new TranslatableComponent("tooltip.lightmanscurrency.settings.owner");
    }

    private OwnershipTab() {
    }

    @Override
    public ImmutableList<String> requiredPermissions() {
        return ImmutableList.of((Object)"transferOwnership");
    }

    @Override
    public void initTab() {
        TraderSettingsScreen screen = this.getScreen();
        this.newOwnerInput = screen.addRenderableTabWidget(new EditBox(screen.getFont(), screen.guiLeft() + 20, screen.guiTop() + 20, 160, 20, (Component)new TextComponent("")));
        this.newOwnerInput.m_94199_(16);
        this.buttonSetOwner = screen.addRenderableTabWidget(new Button(screen.guiLeft() + 20, screen.guiTop() + 41, 160, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.set_owner"), this::setOwner));
        this.buttonSetOwner.f_93623_ = false;
        this.teamSelection = screen.addRenderableTabWidget(new TeamSelectWidget(screen.guiLeft() + 10, screen.guiTop() + 65, 5, () -> this.teamList, this::getSelectedTeam, this::selectTeam));
        this.teamSelection.init(screen::addRenderableTabWidget, this.getFont());
        this.buttonSetTeamOwner = screen.addRenderableTabWidget(new Button(screen.guiLeft() + 20, screen.guiTop() + 170, 160, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.set_owner"), this::setTeamOwner));
        this.buttonSetTeamOwner.f_93623_ = false;
    }

    private Team getTeam(int teamIndex) {
        if (teamIndex < this.teamList.size()) {
            return this.teamList.get(teamIndex);
        }
        return null;
    }

    private Team getSelectedTeam() {
        if (this.selectedTeam == null) {
            return null;
        }
        return ClientTradingOffice.getTeam(this.selectedTeam);
    }

    private void refreshTeamList() {
        this.teamList = Lists.newArrayList();
        List<Team> allTeams = ClientTradingOffice.getTeamList();
        allTeams.forEach(team -> {
            if (team.isMember(this.getPlayer())) {
                this.teamList.add((Team)team);
            }
        });
        this.teamList.sort(Team.sorterFor(this.getPlayer()));
    }

    @Override
    public void preRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        TraderSettingsScreen screen = this.getScreen();
        CoreTraderSettings coreSettings = this.getSetting(CoreTraderSettings.class);
        this.getFont().m_92889_(pose, (Component)new TranslatableComponent("gui.button.lightmanscurrency.team.owner", new Object[]{coreSettings.getOwnerName()}), (float)(screen.guiLeft() + 20), (float)(screen.guiTop() + 10), 0x404040);
    }

    @Override
    public void postRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        TraderSettingsScreen screen = this.getScreen();
        if (this.buttonSetOwner.m_5953_((double)mouseX, (double)mouseY) || this.buttonSetTeamOwner.m_5953_((double)mouseX, (double)mouseY)) {
            screen.m_96602_(pose, (Component)new TranslatableComponent("tooltip.lightmanscurrency.warning").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW}), mouseX, mouseY);
        }
    }

    @Override
    public void tick() {
        this.refreshTeamList();
        this.newOwnerInput.m_94120_();
        this.buttonSetOwner.f_93623_ = !this.newOwnerInput.m_94155_().isBlank();
        this.buttonSetTeamOwner.f_93623_ = this.getSelectedTeam() != null;
    }

    @Override
    public void closeTab() {
        this.selectedTeam = null;
        this.teamList = Lists.newArrayList();
    }

    private void selectTeam(int teamIndex) {
        Team newTeam = this.getTeam(teamIndex);
        if (newTeam != null) {
            this.selectedTeam = newTeam.getID().equals(this.selectedTeam) ? null : newTeam.getID();
        }
    }

    private void setOwner(Button button) {
        if (this.newOwnerInput.m_94155_().isBlank()) {
            return;
        }
        CoreTraderSettings settings = this.getSetting(CoreTraderSettings.class);
        CompoundTag updateInfo = settings.setOwner(this.getPlayer(), this.newOwnerInput.m_94155_());
        settings.sendToServer(updateInfo);
        this.newOwnerInput.m_94144_("");
    }

    private void setTeamOwner(Button button) {
        if (this.getSelectedTeam() == null) {
            return;
        }
        CoreTraderSettings settings = this.getSetting(CoreTraderSettings.class);
        CompoundTag updateInfo = settings.setTeam(this.getPlayer(), this.selectedTeam);
        settings.sendToServer(updateInfo);
        this.selectedTeam = null;
    }
}

