/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.money.CoinData;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CoinValueInput
extends AbstractWidget {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/coinvalueinput.png");
    public static final int HEIGHT = 69;
    public static final int DISPLAY_WIDTH = 176;
    private static final int SEGMENT_WIDTH = 20;
    private static final int SEGMENT_SPACING = 5;
    private static final int SEGMENT_TOTAL = 25;
    private final int leftOffset;
    private final ICoinValueInput parent;
    private final CoinValue.ValueType inputType;
    private CoinValue coinValue;
    Button toggleFree;
    private List<Button> increaseButtons;
    private List<Button> decreaseButtons;
    private Component title;
    String lastInput = "";
    EditBox valueInput;
    String prefix;
    String postfix;
    public boolean allowFreeToggle = true;
    public boolean drawBG = true;

    public void setTitle(Component title) {
        this.title = title;
    }

    public CoinValueInput(int y, Component title, CoinValue startingValue, @Nonnull ICoinValueInput parent) {
        super(0, y, CoinValueInput.calculateWidth(), 69, title);
        this.inputType = (CoinValue.ValueType)((Object)Config.SERVER.coinValueInputType.get());
        this.title = title;
        this.leftOffset = this.f_93618_ == parent.getWidth() ? 0 : (parent.getWidth() - this.f_93618_) / 2;
        this.parent = parent;
        this.coinValue = startingValue.copy();
        if (this.inputType == CoinValue.ValueType.VALUE) {
            this.setPrefixAndPostfix();
        }
    }

    private void setPrefixAndPostfix() {
        String format = (String)Config.SERVER.valueFormat.get();
        String[] splitFormat = format.replace("{value}", "`").split("`", 2);
        if (splitFormat.length < 2) {
            if (format.startsWith("{value}")) {
                this.prefix = "";
                this.postfix = splitFormat[0];
            } else {
                this.prefix = splitFormat[0];
                this.postfix = "";
            }
        } else {
            this.prefix = splitFormat[0];
            this.postfix = splitFormat[1];
        }
    }

    public void init() {
        this.toggleFree = this.parent.addCustomWidget(new PlainButton(this.leftOffset + this.f_93618_ - 14, this.f_93621_ + 4, 10, 10, this::ToggleFree, GUI_TEXTURE, 40, 69));
        this.increaseButtons = new ArrayList<Button>();
        this.decreaseButtons = new ArrayList<Button>();
        if (this.inputType == CoinValue.ValueType.DEFAULT) {
            int buttonCount = MoneyUtil.getAllData("main").size();
            for (int x = 0; x < buttonCount; ++x) {
                Button newButton = this.parent.addCustomWidget(new PlainButton(this.leftOffset + 10 + x * 25, this.f_93621_ + 15, 20, 10, this::IncreaseButtonHit, GUI_TEXTURE, 0, 69));
                newButton.f_93623_ = true;
                this.increaseButtons.add(newButton);
                newButton = this.parent.addCustomWidget(new PlainButton(this.leftOffset + 10 + x * 25, this.f_93621_ + 53, 20, 10, this::DecreaseButtonHit, GUI_TEXTURE, 20, 69));
                newButton.f_93623_ = false;
                this.decreaseButtons.add(newButton);
            }
        } else {
            int postfixWidth;
            int prefixWidth = this.parent.getFont().m_92895_(this.prefix);
            if (prefixWidth > 0) {
                prefixWidth += 2;
            }
            if ((postfixWidth = this.parent.getFont().m_92895_(this.postfix)) > 0) {
                postfixWidth += 2;
            }
            this.valueInput = this.parent.addCustomWidget(new EditBox(this.parent.getFont(), this.leftOffset + 10 + prefixWidth, this.f_93621_ + 20, 156 - prefixWidth - postfixWidth, 20, (Component)new TextComponent("")));
        }
        this.tick();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.toggleFree.f_93624_ = this.allowFreeToggle && this.f_93624_;
        this.increaseButtons.forEach(button -> {
            button.f_93624_ = this.f_93624_;
        });
        this.decreaseButtons.forEach(button -> {
            button.f_93624_ = this.f_93624_;
        });
        if (!this.f_93624_) {
            return;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int startX = this.f_93620_ + this.leftOffset;
        int startY = this.f_93621_;
        if (this.inputType == CoinValue.ValueType.DEFAULT) {
            int x;
            List<CoinData> coinData = MoneyUtil.getAllData("main");
            int buttonCount = coinData.size();
            if (this.drawBG) {
                this.m_93228_(poseStack, startX, startY, 0, 0, 10, 69);
                for (x = 0; x < buttonCount; ++x) {
                    this.m_93228_(poseStack, startX + 10 + x * 25, startY, 10, 0, 20, 69);
                    if (x >= buttonCount - 1) continue;
                    this.m_93228_(poseStack, startX + 30 + x * 25, startY, 30, 0, 5, 69);
                }
                this.m_93228_(poseStack, startX + 30 + (buttonCount - 1) * 25, startY, 40, 0, 10, 69);
            }
            for (x = 0; x < buttonCount; ++x) {
                ItemRenderUtil.drawItemStack((GuiComponent)this, this.parent.getFont(), new ItemStack((ItemLike)coinData.get((int)x).coinItem), startX + x * 25 + 12, startY + 26);
                String countString = String.valueOf(this.coinValue.getEntry(coinData.get((int)x).coinItem));
                int width = this.parent.getFont().m_92895_(countString);
                this.parent.getFont().m_92883_(poseStack, countString, (float)(startX + x * 25 + 20 - width / 2), (float)(startY + 43), 0x404040);
            }
        } else if (this.drawBG) {
            int xPos;
            int xSize;
            this.m_93228_(poseStack, startX, startY, 0, 0, 10, 69);
            for (xPos = startX + 10; xPos < startX + 176 - 10; xPos += xSize) {
                xSize = Math.min(30, startX + 176 - 10 - xPos);
                this.m_93228_(poseStack, xPos, startY, 10, 0, xSize, 69);
            }
            this.m_93228_(poseStack, xPos, startY, 40, 0, 10, 69);
            this.parent.getFont().m_92883_(poseStack, this.prefix, (float)(startX + 10), (float)(startY + 26), 0xFFFFFF);
            int postfixWidth = this.parent.getFont().m_92895_(this.postfix);
            this.parent.getFont().m_92883_(poseStack, this.postfix, (float)(startX + 176 - 10 - postfixWidth), (float)(startY + 26), 0xFFFFFF);
        }
        this.parent.getFont().m_92883_(poseStack, this.title.getString(), (float)startX + 8.0f, (float)startY + 5.0f, 0x404040);
        int priceWidth = this.parent.getFont().m_92895_(this.coinValue.getString());
        int freeButtonOffset = this.allowFreeToggle ? 15 : 5;
        this.parent.getFont().m_92883_(poseStack, this.coinValue.getString(), (float)(startX + this.f_93618_ - freeButtonOffset - priceWidth), (float)startY + 5.0f, 0x404040);
    }

    public void tick() {
        if (this.inputType == CoinValue.ValueType.DEFAULT) {
            int i;
            List<Item> coinItems = MoneyUtil.getAllCoins();
            for (i = 0; i < this.decreaseButtons.size(); ++i) {
                this.decreaseButtons.get((int)i).f_93623_ = i >= coinItems.size() ? false : this.coinValue.getEntry(coinItems.get(i)) > 0;
            }
            for (i = 0; i < this.increaseButtons.size(); ++i) {
                this.increaseButtons.get((int)i).f_93623_ = !this.coinValue.isFree();
            }
        } else if (this.valueInput != null) {
            this.valueInput.m_94120_();
            boolean bl = this.valueInput.f_93623_ = !this.coinValue.isFree();
            if (!this.coinValue.isFree()) {
                TextInputUtil.whitelistFloat(this.valueInput);
                if (!this.lastInput.contentEquals(this.valueInput.m_94155_())) {
                    this.lastInput = this.valueInput.m_94155_();
                    this.coinValue = MoneyUtil.displayValueToCoinValue(this.getDisplayValue());
                    this.parent.OnCoinValueChanged(this);
                }
            } else {
                this.valueInput.m_94144_("");
                this.lastInput = this.valueInput.m_94155_();
            }
        }
    }

    public static int calculateWidth() {
        if (Config.SERVER.coinValueInputType.get() == CoinValue.ValueType.VALUE) {
            return 176;
        }
        int buttonCount = MoneyUtil.getAllData("main").size();
        return 20 + 20 * buttonCount + 5 * (buttonCount - 1);
    }

    public void IncreaseButtonHit(Button button) {
        if (!this.increaseButtons.contains(button)) {
            return;
        }
        int coinIndex = this.increaseButtons.indexOf(button);
        List<Item> coins = MoneyUtil.getAllCoins();
        if (coinIndex >= 0 && coinIndex < coins.size()) {
            Item coin = coins.get(coinIndex);
            int addAmount = 1;
            if (Screen.m_96638_()) {
                addAmount = this.getLargeIncreaseAmount(coin);
            }
            if (Screen.m_96637_()) {
                addAmount *= 10;
            }
            this.coinValue.addValue(coin, addAmount);
            this.parent.OnCoinValueChanged(this);
        } else {
            LightmansCurrency.LogError("Invalid index (" + coinIndex + ") found for the increasing button.");
        }
    }

    public void DecreaseButtonHit(Button button) {
        if (!this.decreaseButtons.contains(button)) {
            return;
        }
        int coinIndex = this.decreaseButtons.indexOf(button);
        List<Item> coins = MoneyUtil.getAllCoins();
        if (coinIndex >= 0 && coinIndex < coins.size()) {
            Item coin = coins.get(coinIndex);
            int removeAmount = 1;
            if (Screen.m_96638_()) {
                removeAmount = this.getLargeIncreaseAmount(coin);
            }
            if (Screen.m_96637_()) {
                removeAmount *= 10;
            }
            this.coinValue.removeValue(coin, removeAmount);
            this.parent.OnCoinValueChanged(this);
        } else {
            LightmansCurrency.LogError("Invalid index (" + coinIndex + ") found for the decreasing button.");
        }
    }

    private final int getLargeIncreaseAmount(Item coinItem) {
        Pair<Item, Integer> upwardConversion = MoneyUtil.getUpwardConversion(coinItem);
        if (upwardConversion != null) {
            return this.getLargeAmount(upwardConversion);
        }
        Pair<Item, Integer> downwardConversion = MoneyUtil.getDownwardConversion(coinItem);
        if (downwardConversion != null) {
            return this.getLargeAmount(downwardConversion);
        }
        return 10;
    }

    private final int getLargeAmount(Pair<Item, Integer> conversion) {
        if ((Integer)conversion.getSecond() >= 64) {
            return 16;
        }
        if ((Integer)conversion.getSecond() > 10) {
            return 10;
        }
        if ((Integer)conversion.getSecond() > 5) {
            return 5;
        }
        return 2;
    }

    private void ToggleFree(Button button) {
        this.coinValue.setFree(!this.coinValue.isFree());
        this.parent.OnCoinValueChanged(this);
    }

    public CoinValue getCoinValue() {
        return this.coinValue;
    }

    public double getDisplayValue() {
        if (this.valueInput != null) {
            return TextInputUtil.getDoubleValue(this.valueInput);
        }
        return this.coinValue.getDisplayValue();
    }

    public void setCoinValue(CoinValue newValue) {
        this.coinValue = newValue.copy();
        if (this.inputType == CoinValue.ValueType.VALUE) {
            this.valueInput.m_94144_(Config.formatValueOnly(newValue.getDisplayValue()));
        }
    }

    public void m_142291_(NarrationElementOutput narrator) {
    }

    public static interface ICoinValueInput {
        public <T extends GuiEventListener & Widget> T addCustomWidget(T var1);

        public int getWidth();

        public Font getFont();

        public void OnCoinValueChanged(CoinValueInput var1);
    }
}

