/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.DropdownButton;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class DropdownWidget
extends AbstractWidget {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/dropdown.png");
    public static final int HEIGHT = 12;
    boolean open = false;
    int currentlySelected;
    private final Font font;
    private final List<Component> options;
    private final Consumer<Integer> onSelect;
    private final Function<Integer, Boolean> optionActive;
    List<Button> optionButtons = new ArrayList<Button>();

    public DropdownWidget(int x, int y, int width, Font font, int selected, Consumer<Integer> onSelect, Function<Button, Button> addButton, Component ... options) {
        this(x, y, width, font, selected, onSelect, (Integer index) -> true, addButton, options);
    }

    public DropdownWidget(int x, int y, int width, Font font, int selected, Consumer<Integer> onSelect, Function<Button, Button> addButton, List<Component> options) {
        this(x, y, width, font, selected, onSelect, (Integer index) -> true, addButton, options);
    }

    public DropdownWidget(int x, int y, int width, Font font, int selected, Consumer<Integer> onSelect, Function<Integer, Boolean> optionActive, Function<Button, Button> addButton, Component ... options) {
        this(x, y, width, font, selected, onSelect, optionActive, addButton, Lists.newArrayList((Object[])options));
    }

    public DropdownWidget(int x, int y, int width, Font font, int selected, Consumer<Integer> onSelect, Function<Integer, Boolean> optionActive, Function<Button, Button> addButton, List<Component> options) {
        super(x, y, width, 12, (Component)new TextComponent(""));
        this.font = font;
        this.options = options;
        this.currentlySelected = MathUtil.clamp(selected, 0, this.options.size() - 1);
        this.onSelect = onSelect;
        this.optionActive = optionActive;
        this.init(addButton);
    }

    private void init(Function<Button, Button> addButton) {
        this.optionButtons = new ArrayList<Button>();
        for (int i = 0; i < this.options.size(); ++i) {
            int yPos = this.f_93621_ + 12 + i * 12;
            this.optionButtons.add(addButton.apply(new DropdownButton(this.f_93620_, yPos, this.f_93618_, this.font, this.options.get(i), this::OnSelect)));
            this.optionButtons.get((int)i).f_93624_ = this.open;
        }
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        int xPart;
        int offset;
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int n = offset = this.f_93622_ ? this.f_93619_ : 0;
        if (!this.f_93623_) {
            RenderSystem.m_157429_((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        }
        this.m_93228_(pose, this.f_93620_, this.f_93621_, 0, offset, 2, 12);
        for (int xOffset = 0; xOffset < this.f_93618_ - 14; xOffset += xPart) {
            xPart = Math.min(this.f_93618_ - 14 - xOffset, 244);
            this.m_93228_(pose, this.f_93620_ + 2 + xOffset, this.f_93621_, 2, offset, xPart, 12);
        }
        this.m_93228_(pose, this.f_93620_ + this.f_93618_ - 12, this.f_93621_, 244, offset, 12, 12);
        this.font.m_92883_(pose, this.fitString(this.options.get(this.currentlySelected).getString()), (float)(this.f_93620_ + 2), (float)(this.f_93621_ + 2), 0x404040);
        if (this.open) {
            for (int i = 0; i < this.optionButtons.size(); ++i) {
                this.optionButtons.get((int)i).f_93623_ = this.optionActive.apply(i) != false && i != this.currentlySelected;
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int click) {
        if (this.f_93623_ && this.f_93624_) {
            if (this.m_93680_(mouseX, mouseY) && this.m_7972_(click)) {
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                this.open = !this.open;
                this.optionButtons.forEach(button -> {
                    button.f_93624_ = this.open;
                });
                return true;
            }
            if (this.open) {
                this.open = false;
                this.optionButtons.forEach(button -> {
                    button.f_93624_ = false;
                });
            }
            return false;
        }
        return false;
    }

    private void OnSelect(Button button) {
        int index = this.optionButtons.indexOf(button);
        if (index < 0) {
            return;
        }
        this.currentlySelected = index;
        this.onSelect.accept(index);
    }

    public void m_142291_(NarrationElementOutput narrator) {
    }

    private String fitString(String text) {
        if (this.font.m_92895_(text) <= this.f_93618_ - 14) {
            return text;
        }
        while (this.font.m_92895_(text + "...") > this.f_93618_ - 14 && text.length() > 0) {
            text = text.substring(0, text.length() - 1);
        }
        return text + "...";
    }
}

