/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.ITraderSource;
import io.github.lightman314.lightmanscurrency.trader.common.TradeContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class TradeButtonArea
extends AbstractWidget
implements ScrollBarWidget.IScrollable {
    public static final Function<TradeButton.ITradeData, Boolean> FILTER_VALID = trade -> trade.isValid();
    public static final Function<TradeButton.ITradeData, Boolean> FILTER_ANY = trade -> true;
    private final Supplier<? extends ITraderSource> traderSource;
    private final Function<ITrader, TradeContext> getContext;
    private InteractionConsumer interactionConsumer = null;
    private final List<TradeButton> allButtons = new ArrayList<TradeButton>();
    private final Font font;
    private final Consumer<AbstractWidget> addWidget;
    private final Consumer<TradeButton> removeButton;
    private final BiConsumer<ITrader, TradeButton.ITradeData> onPress;
    private final Function<TradeButton.ITradeData, Boolean> tradeFilter;
    private final int columns;
    private int scroll = 0;
    private int lastFittableLines = 0;
    ScrollBarWidget scrollBar;
    private int scrollBarXOffset = 0;

    public void setInteractionConsumer(InteractionConsumer consumer) {
        this.interactionConsumer = consumer;
    }

    public ScrollBarWidget getScrollBar() {
        return this.scrollBar;
    }

    public int getAvailableWidth() {
        return this.scrollBar.visible() && this.scrollBarXOffset < 0 ? this.f_93618_ + this.scrollBarXOffset : this.f_93618_;
    }

    public TradeButtonArea(Supplier<? extends ITraderSource> traderSource, Function<ITrader, TradeContext> getContext, int x, int y, int width, int height, int columns, Consumer<AbstractWidget> addWidget, Consumer<TradeButton> removeButton, BiConsumer<ITrader, TradeButton.ITradeData> onPress, Function<TradeButton.ITradeData, Boolean> tradeFilter) {
        super(x, y, width, height, (Component)new TextComponent(""));
        this.columns = columns;
        this.traderSource = traderSource;
        this.getContext = getContext;
        this.addWidget = addWidget;
        this.removeButton = removeButton;
        this.onPress = onPress;
        this.tradeFilter = tradeFilter;
        Minecraft mc = Minecraft.m_91087_();
        this.font = mc.f_91062_;
    }

    public void init() {
        this.init(-9, 0, this.f_93619_ - 5);
    }

    public void init(int scrollBarXOffset, int scrollBarYOffset, int scrollBarHeight) {
        this.scrollBarXOffset = scrollBarXOffset;
        this.scrollBar = new ScrollBarWidget(this.f_93620_ + this.f_93618_ + scrollBarXOffset, this.f_93621_ + scrollBarYOffset, scrollBarHeight, this);
        this.addWidget.accept(this.scrollBar);
        this.resetButtons();
        this.tick();
    }

    public ITrader getTrader(int traderIndex) {
        ITraderSource source = this.traderSource.get();
        if (source == null) {
            return null;
        }
        List<ITrader> traders = source.getTraders();
        if (traderIndex < 0 || traderIndex >= traders.size()) {
            return null;
        }
        return traders.get(traderIndex);
    }

    public Pair<ITrader, TradeButton.ITradeData> getTradeAndTrader(int displayIndex) {
        return this.getTradeAndTrader(this.scroll, displayIndex);
    }

    public Pair<ITrader, TradeButton.ITradeData> getTradeAndTrader(int assumedScroll, int displayIndex) {
        int ignoreCount = assumedScroll * this.columns;
        ITraderSource source = this.traderSource.get();
        if (source == null) {
            return Pair.of(null, null);
        }
        List<ITrader> traders = source.getTraders();
        for (int t = 0; t < traders.size(); ++t) {
            ITrader trader = traders.get(t);
            List<? extends TradeButton.ITradeData> trades = trader.getTradeInfo();
            for (int i = 0; i < trades.size(); ++i) {
                TradeButton.ITradeData trade = trades.get(i);
                if (trade == null || !this.tradeFilter.apply(trade).booleanValue()) continue;
                if (ignoreCount > 0) {
                    --ignoreCount;
                    continue;
                }
                if (displayIndex <= 0) {
                    return Pair.of((Object)trader, (Object)trade);
                }
                --displayIndex;
            }
        }
        return Pair.of(null, null);
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        if (this.validTrades() <= 0) {
            int textWidth = this.font.m_92852_((FormattedText)new TranslatableComponent("gui.lightmanscurrency.notrades"));
            TranslatableComponent translatableComponent = new TranslatableComponent("gui.lightmanscurrency.notrades");
            float f = this.f_93620_ + this.f_93618_ / 2 - textWidth / 2;
            int n = this.f_93621_ + this.f_93619_ / 2;
            Objects.requireNonNull(this.font);
            this.font.m_92889_(pose, (Component)translatableComponent, f, (float)(n - 9 / 2), 0x404040);
        }
    }

    public void tick() {
        this.validateScroll();
        if (this.lastFittableLines < this.fittableLines()) {
            this.resetButtons();
        } else {
            this.repositionButtons();
        }
    }

    private void validateScroll() {
        if (this.canScrollDown()) {
            return;
        }
        if (this.scroll > 0) {
            while (this.scroll > 0 && this.validTrades() - this.scroll * this.columns <= this.fittableLines() * this.columns - this.columns) {
                --this.scroll;
            }
        }
    }

    private void resetButtons() {
        this.allButtons.forEach(button -> this.removeButton.accept((TradeButton)((Object)button)));
        this.allButtons.clear();
        int displayIndex = 0;
        this.lastFittableLines = this.fittableLines();
        for (int line = 0; line < this.lastFittableLines; ++line) {
            for (int c = 0; c < this.columns; ++c) {
                int di = displayIndex++;
                TradeButton newButton = new TradeButton(() -> this.getContext.apply((ITrader)this.getTradeAndTrader(di).getFirst()), () -> (TradeButton.ITradeData)this.getTradeAndTrader(di).getSecond(), button -> this.OnTraderPress(di));
                this.addWidget.accept((AbstractWidget)newButton);
                this.allButtons.add(newButton);
            }
        }
        this.repositionButtons();
    }

    private int validTrades() {
        int count = 0;
        ITraderSource ts = this.traderSource.get();
        if (ts == null) {
            return 0;
        }
        List<ITrader> traders = ts.getTraders();
        for (ITrader trader : traders) {
            List<? extends TradeButton.ITradeData> trades = trader.getTradeInfo();
            for (TradeButton.ITradeData iTradeData : trades) {
                if (iTradeData == null || !this.tradeFilter.apply(iTradeData).booleanValue()) continue;
                ++count;
            }
        }
        return count;
    }

    private int fittableLines() {
        return this.fittableLines(this.scroll);
    }

    private int fittableLines(int assumedScroll) {
        int lineCount = 0;
        int displayIndex = 0;
        int yOffset = 0;
        while (yOffset < this.f_93619_) {
            int lineHeight = 0;
            for (int c = 0; c < this.columns; ++c) {
                Pair<ITrader, TradeButton.ITradeData> trade = this.getTradeAndTrader(assumedScroll, displayIndex);
                if (trade.getFirst() != null && trade.getSecond() != null) {
                    TradeContext context = this.getContext.apply((ITrader)trade.getFirst());
                    lineHeight = Math.max(((TradeButton.ITradeData)trade.getSecond()).tradeButtonHeight(context), lineHeight);
                }
                ++displayIndex;
            }
            if (lineHeight <= 0) {
                lineHeight = 18;
            }
            if (yOffset + lineHeight > this.f_93619_) {
                return lineCount;
            }
            yOffset += lineHeight + 4;
            ++lineCount;
        }
        return lineCount;
    }

    private void repositionButtons() {
        int displayIndex = 0;
        int queryIndex = 0;
        int yOffset = 0;
        int fittableLines = this.fittableLines();
        for (int line = 0; line < fittableLines; ++line) {
            int spacing;
            int lineHeight = 0;
            int visibleButtons = 0;
            int totalWidth = 0;
            for (int c = 0; c < this.columns; ++c) {
                Pair<ITrader, TradeButton.ITradeData> trade = this.getTradeAndTrader(queryIndex);
                if (trade.getFirst() != null && trade.getSecond() != null) {
                    TradeContext context = this.getContext.apply((ITrader)trade.getFirst());
                    ++visibleButtons;
                    totalWidth += ((TradeButton.ITradeData)trade.getSecond()).tradeButtonWidth(context);
                    lineHeight = Math.max(((TradeButton.ITradeData)trade.getSecond()).tradeButtonHeight(context), lineHeight);
                }
                ++queryIndex;
            }
            int xOffset = spacing = (this.getAvailableWidth() - totalWidth) / (visibleButtons + 1);
            for (int c = 0; c < this.columns; ++c) {
                Pair<ITrader, TradeButton.ITradeData> trade = this.getTradeAndTrader(displayIndex);
                TradeButton button = this.allButtons.get(displayIndex);
                if (trade.getFirst() != null && trade.getSecond() != null) {
                    TradeContext context = this.getContext.apply((ITrader)trade.getFirst());
                    button.move(this.f_93620_ + xOffset, this.f_93621_ + yOffset);
                    button.f_93624_ = true;
                    xOffset += ((TradeButton.ITradeData)trade.getSecond()).tradeButtonWidth(context) + spacing;
                } else {
                    button.f_93624_ = false;
                }
                ++displayIndex;
            }
            yOffset += lineHeight + 4;
        }
        for (int i = fittableLines * this.columns; i < this.allButtons.size(); ++i) {
            this.allButtons.get((int)i).f_93624_ = false;
        }
    }

    private void OnTraderPress(int displayIndex) {
        if (this.onPress != null) {
            Pair<ITrader, TradeButton.ITradeData> data = this.getTradeAndTrader(displayIndex);
            this.onPress.accept((ITrader)data.getFirst(), (TradeButton.ITradeData)data.getSecond());
        }
    }

    public void renderTraderName(PoseStack pose, int x, int y, int maxWidth, boolean renderTitle) {
        ITraderSource ts = this.traderSource.get();
        if (ts == null) {
            return;
        }
        Object text = "";
        for (ITrader trader : ts.getTraders()) {
            if (((String)text).isEmpty()) {
                text = renderTitle ? trader.getTitle().getString() : trader.getName().getString();
                continue;
            }
            text = (String)text + new TranslatableComponent("gui.lightmanscurrency.trading.listseperator").getString() + (renderTitle ? trader.getTitle().getString() : trader.getName().getString());
        }
        this.font.m_92883_(pose, this.fitText((String)text, maxWidth), (float)x, (float)y, 0x404040);
    }

    private String fitText(String text, int width) {
        if (this.font.m_92895_(text) <= width) {
            return text;
        }
        while (this.font.m_92895_(text + "...") > width) {
            text = text.substring(0, text.length() - 1);
        }
        return text + "...";
    }

    public void renderTooltips(Screen screen, PoseStack pose, int nameX, int nameY, int nameWidth, int mouseX, int mouseY) {
        for (TradeButton button : this.allButtons) {
            button.renderTooltips(pose, mouseX, mouseY);
        }
        this.renderTraderNameTooltip(screen, pose, nameX, nameY, nameWidth, mouseX, mouseY);
    }

    public void renderTraderNameTooltip(Screen screen, PoseStack pose, int x, int y, int maxWidth, int mouseX, int mouseY) {
        if (mouseX >= x && mouseX < x + maxWidth && mouseY >= y) {
            Objects.requireNonNull(this.font);
            if (mouseY < y + 9) {
                ArrayList<Component> tooltips = new ArrayList<Component>();
                ITraderSource ts = this.traderSource.get();
                if (ts == null) {
                    return;
                }
                for (ITrader trader : ts.getTraders()) {
                    tooltips.add(trader.getTitle());
                }
                if (tooltips.size() <= 0) {
                    return;
                }
                screen.m_96597_(pose, tooltips, mouseX, mouseY);
            }
        }
    }

    private boolean canScrollDown() {
        return this.canScrollDown(this.scroll);
    }

    private boolean canScrollDown(int assumedScroll) {
        return this.validTrades() - assumedScroll * this.columns > this.fittableLines(assumedScroll) * this.columns;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta < 0.0) {
            if (!this.canScrollDown()) return false;
            ++this.scroll;
            this.resetButtons();
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.scroll <= 0) return false;
            --this.scroll;
            this.resetButtons();
        }
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (int i = 0; i < this.allButtons.size(); ++i) {
            TradeButton b = this.allButtons.get(i);
            if (!b.m_5953_(mouseX, mouseY)) continue;
            Pair<ITrader, TradeButton.ITradeData> traderPair = this.getTradeAndTrader(i);
            TradeContext context = this.getContext.apply((ITrader)traderPair.getFirst());
            if (context.isStorageMode) {
                if (this.interactionConsumer == null) continue;
                b.onInteractionClick((int)mouseX, (int)mouseY, button, this.interactionConsumer);
                return true;
            }
            return b.m_6375_(mouseX, mouseY, button);
        }
        return false;
    }

    public void m_142291_(NarrationElementOutput narrator) {
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return true;
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.validateScroll();
        this.resetButtons();
    }

    @Override
    public int getMaxScroll() {
        int s = 0;
        while (this.canScrollDown(s)) {
            ++s;
        }
        return s;
    }

    public static interface InteractionConsumer {
        public void onTradeButtonInputInteraction(ITrader var1, TradeButton.ITradeData var2, int var3, int var4);

        public void onTradeButtonOutputInteraction(ITrader var1, TradeButton.ITradeData var2, int var3, int var4);

        public void onTradeButtonInteraction(ITrader var1, TradeButton.ITradeData var2, int var3, int var4, int var5);
    }
}

