/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.blockentity.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;

public class ItemTraderBlockEntityRenderer
implements BlockEntityRenderer<ItemTraderBlockEntity> {
    public static int positionLimit() {
        switch ((Config.Client.TraderRenderType)((Object)Config.CLIENT.traderRenderType.get())) {
            case PARTIAL: {
                return 1;
            }
            case NONE: {
                return 0;
            }
        }
        return Integer.MAX_VALUE;
    }

    public ItemTraderBlockEntityRenderer(BlockEntityRendererProvider.Context dispatcher) {
    }

    public void render(ItemTraderBlockEntity tileEntity, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int lightLevel, int id) {
        for (int tradeSlot = 0; tradeSlot < tileEntity.getTradeCount() && tradeSlot < tileEntity.maxRenderIndex(); ++tradeSlot) {
            ItemTradeData trade = tileEntity.getTrade(tradeSlot);
            if (trade.getSellItem(0).m_41619_()) continue;
            ItemStack stack = trade.getSellItem(0);
            boolean isBlock = stack.m_41720_() instanceof BlockItem;
            if (isBlock && ((List)Config.CLIENT.renderBlocksAsItems.get()).contains(stack.m_41720_().getRegistryName().toString())) {
                isBlock = false;
            }
            List<Vector3f> positions = tileEntity.GetStackRenderPos(tradeSlot, isBlock);
            List<Quaternion> rotation = tileEntity.GetStackRenderRot(tradeSlot, partialTicks, isBlock);
            Vector3f scale = tileEntity.GetStackRenderScale(tradeSlot, isBlock);
            for (int pos = 0; pos < positions.size() && pos < tileEntity.getTradeStock(tradeSlot) && pos < ItemTraderBlockEntityRenderer.positionLimit(); ++pos) {
                matrixStack.m_85836_();
                Vector3f position = positions.get(pos);
                matrixStack.m_85837_((double)position.m_122239_(), (double)position.m_122260_(), (double)position.m_122269_());
                for (Quaternion rot : rotation) {
                    matrixStack.m_85845_(rot);
                }
                matrixStack.m_85841_(scale.m_122239_(), scale.m_122260_(), scale.m_122269_());
                Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, lightLevel, OverlayTexture.f_118083_, matrixStack, renderTypeBuffer, id);
                matrixStack.m_85849_();
            }
        }
    }
}

