/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.items;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.money.CoinData;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CoinItem
extends Item {
    public CoinItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        CoinItem.addCoinTooltips(stack, tooltip);
    }

    public static void addCoinTooltips(ItemStack stack, List<Component> tooltip) {
        CoinData coinData = MoneyUtil.getData(stack.m_41720_());
        if (coinData != null) {
            switch ((CoinItemTooltipType)((Object)Config.SERVER.coinTooltipType.get())) {
                case DEFAULT: {
                    Pair<Item, Integer> upwardConversion;
                    if (coinData.convertsDownwards()) {
                        tooltip.add((Component)new TranslatableComponent("tooltip.lightmanscurrency.coinworth.down", new Object[]{"\u00a7e" + coinData.getDownwardConversion().getSecond(), "\u00a7e" + ((Item)coinData.getDownwardConversion().getFirst()).m_7626_(new ItemStack((ItemLike)coinData.getDownwardConversion().getFirst())).getString()}));
                    }
                    if ((upwardConversion = MoneyUtil.getUpwardConversion(stack.m_41720_())) == null) break;
                    tooltip.add((Component)new TranslatableComponent("tooltip.lightmanscurrency.coinworth.up", new Object[]{"\u00a7e" + upwardConversion.getSecond(), "\u00a7e" + ((Item)upwardConversion.getFirst()).m_7626_(new ItemStack((ItemLike)upwardConversion.getFirst())).getString()}));
                    break;
                }
                case VALUE: {
                    tooltip.add((Component)new TextComponent("\u00a7e" + Config.formatValueDisplay(coinData.getDisplayValue())));
                    break;
                }
            }
        }
    }

    public static enum CoinItemTooltipType {
        DEFAULT,
        VALUE,
        NONE;

    }
}

