/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.menus.containers;

import io.github.lightman314.lightmanscurrency.blockentity.handler.ICanCopy;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class LockableContainer
implements IItemHandler,
ICanCopy<LockableContainer> {
    private final SimpleContainer container;
    private final NonNullList<LockData> lock;
    private boolean honorFullLocks = true;
    private final List<IMarkDirty> listeners = new ArrayList<IMarkDirty>();
    private IExternalInputOutputRules extraRules = null;

    public SimpleContainer getContainer() {
        return this.container;
    }

    public boolean shouldHonorFullLocks() {
        return this.honorFullLocks;
    }

    public void dontHonorFullLocks() {
        this.honorFullLocks = false;
    }

    public void honorFullLocks() {
        this.honorFullLocks = true;
    }

    public void setAdditionalRules(IExternalInputOutputRules extraRules) {
        this.extraRules = extraRules;
    }

    public LockableContainer(int size, IMarkDirty ... listeners) {
        this.container = new SimpleContainer(size);
        this.container.m_19164_(this::containerChanged);
        this.lock = NonNullList.m_122780_((int)size, (Object)new LockData());
        for (int i = 0; i < this.lock.size(); ++i) {
            this.lock.set(i, (Object)new LockData());
        }
        for (IMarkDirty listener : listeners) {
            this.addListener(listener);
        }
    }

    private void containerChanged(Container container) {
        if (container == this.container) {
            this.setChanged();
        }
    }

    public CompoundTag save(CompoundTag compound) {
        InventoryUtil.saveAllItems("Items", compound, (Container)this.container);
        ListTag lockList = new ListTag();
        for (int i = 0; i < this.lock.size(); ++i) {
            lockList.add((Object)((LockData)this.lock.get(i)).save());
        }
        compound.m_128365_("Lock", (Tag)lockList);
        return compound;
    }

    public void load(CompoundTag compound) {
        int i;
        if (compound.m_128425_("Items", 9)) {
            this.container.m_19181_(this::containerChanged);
            SimpleContainer copyContainer = InventoryUtil.loadAllItems("Items", compound, this.getSlots());
            for (i = 0; i < this.container.m_6643_() && i < copyContainer.m_6643_(); ++i) {
                this.container.m_6836_(i, copyContainer.m_8020_(i));
            }
            this.container.m_19164_(this::containerChanged);
        } else {
            this.container.m_6211_();
        }
        ListTag lockList = compound.m_128425_("Lock", 9) ? compound.m_128437_("Lock", 10) : new ListTag();
        for (i = 0; i < this.lock.size(); ++i) {
            this.lock.set(i, (Object)new LockData());
            if (i >= lockList.size()) continue;
            ((LockData)this.lock.get(i)).load(lockList.m_128728_(i));
        }
    }

    public void addListener(IMarkDirty listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IMarkDirty listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public LockData getLockData(int index) {
        if (index >= 0 && index < this.lock.size()) {
            return (LockData)this.lock.get(index);
        }
        return null;
    }

    public void setLockData(int index, LockData lockEntry) {
        if (index >= 0 && index < this.lock.size()) {
            ((LockData)this.lock.get(index)).removeListener(this::setChanged);
            this.lock.set(index, (Object)lockEntry);
            lockEntry.addListener(this::setChanged);
        }
    }

    public void setChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            int oldSize = this.listeners.size();
            this.listeners.get(i).markDirty();
            if (this.listeners.size() >= oldSize) continue;
            --i;
        }
    }

    public static LockData freshLock() {
        return new LockData();
    }

    public int getSlots() {
        return this.container.m_6643_();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.container.m_8020_(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.extraRules != null && !this.extraRules.allowInput(slot, this.getLockData(slot), stack)) {
            return stack.m_41777_();
        }
        if (this.getLockData(slot).allow(stack, this.honorFullLocks)) {
            int growAmount;
            ItemStack returnStack = stack.m_41777_();
            ItemStack currentStack = this.container.m_8020_(slot);
            if (currentStack.m_41619_()) {
                if (!simulate) {
                    this.container.m_6836_(slot, returnStack);
                }
                returnStack = ItemStack.f_41583_;
            } else if (InventoryUtil.ItemMatches(returnStack, currentStack) && (growAmount = Math.min(stack.m_41613_(), currentStack.m_41741_() - currentStack.m_41613_())) > 0) {
                if (!simulate) {
                    currentStack.m_41769_(growAmount);
                }
                returnStack.m_41774_(growAmount);
            }
            return returnStack;
        }
        return stack.m_41777_();
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.extraRules != null && !this.extraRules.allowOutput(slot, this.getLockData(slot), this.container.m_8020_(slot))) {
            return ItemStack.f_41583_;
        }
        ItemStack currentStack = this.container.m_8020_(slot);
        int removeAmount = Math.min(currentStack.m_41613_(), amount);
        if (!simulate) {
            if (removeAmount == currentStack.m_41613_()) {
                this.container.m_6836_(slot, ItemStack.f_41583_);
            } else {
                currentStack.m_41774_(removeAmount);
            }
        }
        ItemStack returnStack = currentStack.m_41777_();
        returnStack.m_41764_(removeAmount);
        return returnStack;
    }

    public int getSlotLimit(int slot) {
        return this.container.m_6893_();
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.getLockData(slot).allow(stack, this.honorFullLocks) && (this.extraRules == null || this.extraRules.allowInput(slot, this.getLockData(slot), stack));
    }

    @Override
    public LockableContainer copy() {
        CompoundTag save = this.save(new CompoundTag());
        LockableContainer copy = new LockableContainer(this.getSlots(), new IMarkDirty[0]);
        copy.load(save);
        return copy;
    }

    public static interface IExternalInputOutputRules {
        public boolean allowInput(int var1, LockData var2, ItemStack var3);

        public boolean allowOutput(int var1, LockData var2, ItemStack var3);
    }

    public static class LockData {
        private List<IMarkDirty> listeners = new ArrayList<IMarkDirty>();
        private boolean fullLock = false;
        private ItemStack itemFilter = ItemStack.f_41583_;

        private LockData() {
        }

        public void addListener(IMarkDirty listener) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }

        public void removeListener(IMarkDirty listener) {
            if (this.listeners.contains(listener)) {
                this.listeners.remove(listener);
            }
        }

        public boolean fullyLocked() {
            return this.fullLock;
        }

        public void setFullyLocked(boolean fullyLocked) {
            this.fullLock = fullyLocked;
        }

        public boolean hasItemFilter() {
            return !this.itemFilter.m_41619_();
        }

        public ItemStack filterItem() {
            return this.itemFilter;
        }

        public void setFilter(ItemStack item) {
            this.itemFilter = item.m_41777_();
            if (!this.itemFilter.m_41619_()) {
                this.itemFilter.m_41764_(1);
            }
        }

        public boolean allow(ItemStack item, boolean honorFullLocks) {
            if (this.fullLock && honorFullLocks) {
                return false;
            }
            if (this.hasItemFilter()) {
                return InventoryUtil.ItemMatches(item, this.itemFilter);
            }
            return true;
        }

        private CompoundTag save() {
            CompoundTag compound = new CompoundTag();
            compound.m_128379_("FullLock", this.fullLock);
            if (this.hasItemFilter()) {
                compound.m_128365_("Filter", (Tag)this.itemFilter.m_41739_(new CompoundTag()));
            }
            return compound;
        }

        private void load(CompoundTag compound) {
            this.fullLock = compound.m_128441_("FullLock") ? compound.m_128471_("FullLock") : false;
            this.itemFilter = compound.m_128425_("Filter", 10) ? ItemStack.m_41712_((CompoundTag)compound.m_128469_("Filter")) : ItemStack.f_41583_;
        }

        public LockData copy() {
            LockData copy = new LockData();
            copy.fullLock = this.fullLock;
            copy.itemFilter = this.itemFilter.m_41777_();
            return copy;
        }

        public void setChanged() {
            for (int i = 0; i < this.listeners.size(); ++i) {
                int oldSize = this.listeners.size();
                this.listeners.get(i).markDirty();
                if (this.listeners.size() >= oldSize) continue;
                --i;
            }
        }
    }

    public static interface IMarkDirty {
        public void markDirty();
    }
}

