/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.money;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.events.GetDefaultMoneyDataEvent;
import io.github.lightman314.lightmanscurrency.money.CoinData;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;

public class MoneyData {
    private List<CoinData> coinList = new ArrayList<CoinData>();

    public MoneyData(CoinDataCollector collector) {
        for (CoinData.Builder dataBuilder : collector.coinBuilderList) {
            this.addCoinItem(dataBuilder);
        }
        this.sortCoinList();
    }

    public static MoneyData fromJson(JsonObject json) throws Throwable {
        JsonArray array = json.get("CoinEntries").getAsJsonArray();
        CoinDataCollector collector = new CoinDataCollector();
        for (int i = 0; i < array.size(); ++i) {
            try {
                CoinData.Builder builder = CoinData.getBuilder(array.get(i).getAsJsonObject());
                collector.addCoinBuilder(builder);
                continue;
            }
            catch (Exception e) {
                LightmansCurrency.LogError("Error loading coin entry " + (i + 1), e);
            }
        }
        return new MoneyData(collector);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        JsonArray dataList = new JsonArray();
        for (int i = 0; i < this.coinList.size(); ++i) {
            try {
                JsonObject entry = this.coinList.get(i).toJson();
                dataList.add((JsonElement)entry);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        json.add("CoinEntries", (JsonElement)dataList);
        return json;
    }

    public static void encode(MoneyData data, FriendlyByteBuf buffer) {
        JsonObject json = data.toJson();
        String jsonString = FileUtil.GSON.toJson((JsonElement)json);
        int stringSize = jsonString.length();
        buffer.writeInt(stringSize);
        buffer.m_130072_(jsonString, stringSize);
    }

    public static MoneyData decode(FriendlyByteBuf buffer) {
        try {
            LightmansCurrency.LogInfo("Decoding money data packet:");
            int stringSize = buffer.readInt();
            String jsonString = buffer.m_130136_(stringSize);
            JsonObject json = JsonParser.parseString((String)jsonString).getAsJsonObject();
            return MoneyData.fromJson(json);
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error decoding MoneyData.", t);
            return MoneyData.generateDefault();
        }
    }

    public static void handle(MoneyData data, Supplier<NetworkEvent.Context> source) {
        source.get().enqueueWork(() -> {
            LightmansCurrency.LogInfo("Received money data packet from server. Synchronizing coin list.");
            MoneyUtil.receiveMoneyData(data);
        });
        source.get().setPacketHandled(true);
    }

    public static MoneyData generateDefault() {
        GetDefaultMoneyDataEvent e = new GetDefaultMoneyDataEvent(new CoinDataCollector());
        MinecraftForge.EVENT_BUS.post((Event)e);
        return new MoneyData(e.dataCollector);
    }

    private void addCoinItem(CoinData.Builder newCoinDataBuilder) {
        CoinData newCoinData = newCoinDataBuilder.build();
        for (CoinData coinData : this.coinList) {
            if (coinData.coinItem == newCoinData.coinItem) {
                LightmansCurrency.LogWarning("Attempted to add Duplicate Coin Item (" + newCoinData.coinItem.getRegistryName().toString() + ") to the coin list.");
                return;
            }
            if (coinData.worthOtherCoin != newCoinData.worthOtherCoin || newCoinData.isHidden || coinData.isHidden || newCoinData.worthOtherCoin == null || !coinData.chain.contentEquals(newCoinData.chain)) continue;
            LightmansCurrency.LogWarning("Attempted to add a new Coin Item '" + newCoinData.coinItem.getRegistryName() + "' with the same dependent (" + coinData.worthOtherCoin.getRegistryName() + ") as another coin (" + coinData.coinItem.getRegistryName() + ") in the same chain '" + coinData.chain + "'.\nEntry will be flagged as hidden.");
            newCoinData = newCoinDataBuilder.setHidden().build();
        }
        LightmansCurrency.LogInfo("Registered " + newCoinData.coinItem.getRegistryName() + " as a coin.");
        this.coinList.add(newCoinData);
    }

    private void sortCoinList() {
        ArrayList<CoinData> newList = new ArrayList<CoinData>();
        while (this.coinList.size() > 0) {
            int highestValueIndex = 0;
            long highestValue = this.coinList.get(0).getValue(this);
            for (int i = 1; i < this.coinList.size(); ++i) {
                if (this.coinList.get(i).getValue(this) <= highestValue) continue;
                highestValueIndex = i;
                highestValue = this.coinList.get(i).getValue(this);
            }
            newList.add(this.coinList.get(highestValueIndex));
            this.coinList.remove(highestValueIndex);
        }
        this.coinList = newList;
    }

    public CoinData getData(Item coinItem) {
        for (CoinData data : this.coinList) {
            if (data.coinItem != coinItem) continue;
            return data;
        }
        return null;
    }

    public List<CoinData> getCoinList() {
        return this.coinList;
    }

    public List<CoinData> getCoinList(String chain) {
        ArrayList<CoinData> results = new ArrayList<CoinData>();
        for (int i = 0; i < this.coinList.size(); ++i) {
            CoinData data = this.coinList.get(i);
            if (!data.chain.contentEquals(chain)) continue;
            results.add(data);
        }
        return results;
    }

    public static class CoinDataCollector {
        List<CoinData.Builder> coinBuilderList = new ArrayList<CoinData.Builder>();

        public void addCoinBuilder(CoinData.Builder coinBuilder) {
            this.coinBuilderList.add(coinBuilder);
        }
    }
}

