/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.proxy;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.BlockItemSet;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.ClientEvents;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.colors.TicketColor;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradingTerminalScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ItemInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.MintScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.PaygateScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TicketMachineScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletScreen;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.FreezerTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.ItemTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.core.ModMenus;
import io.github.lightman314.lightmanscurrency.items.CoinBlockItem;
import io.github.lightman314.lightmanscurrency.items.CoinItem;
import io.github.lightman314.lightmanscurrency.money.CoinData;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.proxy.CommonProxy;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.FreeSample;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerBlacklist;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerDiscounts;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerTradeLimit;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerWhitelist;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TimedSale;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeLimit;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    boolean openTerminal = false;
    boolean openTeamManager = false;
    private long timeOffset = 0L;

    @Override
    public void setupClient() {
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.DISPLAY_CASE.block, (RenderType)RenderType.m_110463_());
        ClientProxy.setRenderLayerForSet(ModBlocks.VENDING_MACHINE1, RenderType.m_110463_());
        ClientProxy.setRenderLayerForSet(ModBlocks.VENDING_MACHINE2, RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.ARMOR_DISPLAY.block, (RenderType)RenderType.m_110463_());
        MenuScreens.m_96206_(ModMenus.ATM, ATMScreen::new);
        MenuScreens.m_96206_(ModMenus.MINT, MintScreen::new);
        MenuScreens.m_96206_(ModMenus.TRADER, TraderScreen::new);
        MenuScreens.m_96206_(ModMenus.TRADER_UNIVERSAL, TraderScreen::new);
        MenuScreens.m_96206_(ModMenus.TRADER_STORAGE, TraderStorageScreen::new);
        MenuScreens.m_96206_(ModMenus.TRADER_STORAGE_UNIVERSAL, TraderStorageScreen::new);
        MenuScreens.m_96206_(ModMenus.WALLET, WalletScreen::new);
        MenuScreens.m_96206_(ModMenus.PAYGATE, PaygateScreen::new);
        MenuScreens.m_96206_(ModMenus.TICKET_MACHINE, TicketMachineScreen::new);
        MenuScreens.m_96206_(ModMenus.ITEM_INTERFACE, ItemInterfaceScreen::new);
        BlockEntityRenderers.m_173590_(ModBlockEntities.ITEM_TRADER, ItemTraderBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_(ModBlockEntities.FREEZER_TRADER, FreezerTraderBlockEntityRenderer::new);
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new PlayerWhitelist()));
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new PlayerBlacklist()));
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new PlayerTradeLimit()));
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new PlayerDiscounts()));
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new TimedSale()));
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new TradeLimit()));
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new FreeSample()));
        ClientRegistry.registerKeyBinding((KeyMapping)ClientEvents.KEY_WALLET);
        ClientRegistry.registerKeyBinding((KeyMapping)ClientEvents.KEY_TEAM);
    }

    private static void setRenderLayerForSet(BlockItemSet<?> blockItemSet, RenderType type) {
        blockItemSet.getAll().forEach(blockItemPair -> ItemBlockRenderTypes.setRenderLayer((Block)blockItemPair.block, (RenderType)type));
    }

    @Override
    public void clearClientTraders() {
        ClientTradingOffice.clearData();
    }

    @Override
    public void updateTrader(CompoundTag compound) {
        ClientTradingOffice.updateTrader(compound);
    }

    @Override
    public void removeTrader(UUID traderID) {
        ClientTradingOffice.removeTrader(traderID);
    }

    @Override
    public void initializeTeams(CompoundTag compound) {
        if (compound.m_128425_("Teams", 9)) {
            ArrayList teams = Lists.newArrayList();
            ListTag teamList = compound.m_128437_("Teams", 10);
            teamList.forEach(nbt -> teams.add(Team.load((CompoundTag)nbt)));
            ClientTradingOffice.initTeams(teams);
        }
    }

    @Override
    public void updateTeam(CompoundTag compound) {
        ClientTradingOffice.updateTeam(compound);
    }

    @Override
    public void removeTeam(UUID teamID) {
        ClientTradingOffice.removeTeam(teamID);
    }

    @Override
    public void initializeBankAccounts(CompoundTag compound) {
        if (compound.m_128425_("BankAccounts", 9)) {
            HashMap<UUID, BankAccount> bank = new HashMap<UUID, BankAccount>();
            ListTag bankList = compound.m_128437_("BankAccounts", 10);
            for (int i = 0; i < bankList.size(); ++i) {
                CompoundTag tag = bankList.m_128728_(i);
                UUID id = tag.m_128342_("Player");
                BankAccount bankAccount = new BankAccount(tag);
                bank.put(id, bankAccount);
            }
            ClientTradingOffice.initBankAccounts(bank);
        }
    }

    @Override
    public void updateBankAccount(CompoundTag compound) {
        ClientTradingOffice.updateBankAccount(compound);
    }

    @Override
    public void openTerminalScreen() {
        this.openTerminal = true;
    }

    @Override
    public void openTeamManager() {
        this.openTeamManager = true;
    }

    @Override
    public void createTeamResponse(UUID teamID) {
        Minecraft minecraft = Minecraft.m_91087_();
        Screen openScreen = minecraft.f_91080_;
        if (openScreen instanceof TeamManagerScreen) {
            TeamManagerScreen screen = (TeamManagerScreen)openScreen;
            screen.setActiveTeam(teamID);
        }
    }

    @Override
    public long getTimeDesync() {
        return this.timeOffset;
    }

    @Override
    public void setTimeDesync(long serverTime) {
        this.timeOffset = serverTime - System.currentTimeMillis();
        this.timeOffset = this.timeOffset / 1000L * 1000L;
        if (this.timeOffset < 10000L) {
            this.timeOffset = 0L;
        }
    }

    @Override
    public void loadAdminPlayers(List<UUID> serverAdminList) {
        TradingOffice.loadAdminPlayers(serverAdminList);
    }

    public void registerItemColors(ColorHandlerEvent.Item event) {
        LightmansCurrency.LogInfo("Registering Item Colors for Ticket Items");
        event.getItemColors().m_92689_((ItemColor)new TicketColor(), new ItemLike[]{ModItems.TICKET, ModItems.TICKET_MASTER});
    }

    @SubscribeEvent
    public void openScreenOnRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (this.openTerminal) {
                this.openTerminal = false;
                Minecraft.m_91087_().m_91152_((Screen)new TradingTerminalScreen());
            } else if (this.openTeamManager) {
                this.openTeamManager = false;
                Minecraft.m_91087_().m_91152_((Screen)new TeamManagerScreen());
            }
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        Item item = event.getItemStack().m_41720_();
        CoinData coinData = MoneyUtil.getData(item);
        if (coinData != null && !(item instanceof CoinItem) && !(item instanceof CoinBlockItem)) {
            CoinItem.addCoinTooltips(event.getItemStack(), event.getToolTip());
        }
    }
}

