/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.settings;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.SettingsLogger;
import io.github.lightman314.lightmanscurrency.client.gui.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.settings.core.AllyPermissionsTab;
import io.github.lightman314.lightmanscurrency.client.gui.settings.core.AllyTab;
import io.github.lightman314.lightmanscurrency.client.gui.settings.core.LoggerTab;
import io.github.lightman314.lightmanscurrency.client.gui.settings.core.MainTab;
import io.github.lightman314.lightmanscurrency.client.gui.settings.core.OwnershipTab;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.permissions.PermissionsList;
import io.github.lightman314.lightmanscurrency.trader.permissions.options.BooleanPermission;
import io.github.lightman314.lightmanscurrency.trader.permissions.options.PermissionOption;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CoreTraderSettings
extends Settings {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "trader_core");
    private static final String UPDATE_CUSTOM_NAME = "customName";
    private static final String UPDATE_ADD_ALLY = "addAlly";
    private static final String UPDATE_REMOVE_ALLY = "removeAlly";
    private static final String UPDATE_ALLY_PERMISSIONS = "allyPermissions";
    private static final String UPDATE_CREATIVE = "creative";
    private static final String UPDATE_OWNERSHIP = "transferOwnership";
    private static final String UPDATE_TEAM = "changeTeam";
    private static final String UPDATE_BANK_LINK = "bankLink";
    PlayerReference owner = null;
    private String customOwnerName = "";
    Team.TeamReference team = null;
    List<PlayerReference> allies = Lists.newArrayList();
    PermissionsList allyPermissions = CoreTraderSettings.getAllyDefaultPermissions(this.trader);
    String customName = "";
    boolean isCreative = false;
    boolean bankAccountLinked = false;
    SettingsLogger logger = new SettingsLogger();

    public static PermissionsList getAllyDefaultPermissions(@Nonnull ITrader trader) {
        HashMap defaultPermissions = Maps.newHashMap();
        defaultPermissions.put("openStorage", 1);
        defaultPermissions.put("editTrades", 1);
        defaultPermissions.put("editTradeRules", 1);
        defaultPermissions.put("editSettings", 1);
        defaultPermissions.put("changeName", 1);
        try {
            trader.getAllyDefaultPermissions().forEach((key, value) -> defaultPermissions.put(key, value));
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error getting additional default ally permissions for trader type " + trader.getClass().getName(), e);
        }
        return new PermissionsList(trader, UPDATE_ALLY_PERMISSIONS, defaultPermissions);
    }

    public void setCustomOwnerName(String ownerName) {
        this.customOwnerName = ownerName;
    }

    public Team getTeam() {
        if (this.team == null) {
            return null;
        }
        return this.team.getTeam(this.trader.isClient());
    }

    public PermissionsList getAllyPermissions() {
        return this.allyPermissions;
    }

    public boolean hasCustomName() {
        return !this.customName.isEmpty();
    }

    public String getCustomName() {
        return this.customName;
    }

    public void forceCustomName(String customName) {
        this.customName = customName;
    }

    public CompoundTag setCustomName(Player requestor, String newName) {
        if (!this.hasPermission(requestor, "changeName")) {
            CoreTraderSettings.PermissionWarning(requestor, "change the traders name", "changeName");
            return null;
        }
        if (!this.customName.contentEquals(newName)) {
            String oldName = this.customName;
            this.customName = newName;
            this.logger.LogNameChange(requestor, oldName, this.customName);
            CompoundTag updateInfo = CoreTraderSettings.initUpdateInfo(UPDATE_CUSTOM_NAME);
            updateInfo.m_128359_("NewName", this.customName);
            return updateInfo;
        }
        return null;
    }

    public boolean canLinkBankAccount() {
        Team t = this.getTeam();
        if (t != null) {
            return t.hasBankAccount();
        }
        return true;
    }

    public boolean isBankAccountLinked() {
        return this.bankAccountLinked;
    }

    public boolean hasBankAccount() {
        return this.getBankAccount() != null;
    }

    public BankAccount getBankAccount() {
        if (!this.bankAccountLinked) {
            return null;
        }
        Team t = this.getTeam();
        if (t != null) {
            return t.getBankAccount();
        }
        if (this.owner != null) {
            return BankAccount.GenerateReference(this.trader.isClient(), BankAccount.AccountType.Player, this.owner.id).get();
        }
        return null;
    }

    public CoreTraderSettings(ITrader trader, Settings.IMarkDirty marker, BiConsumer<ResourceLocation, CompoundTag> sendToServer) {
        super(trader, marker, sendToServer, TYPE);
    }

    public PlayerReference getOwner() {
        return this.owner;
    }

    public String getOwnerName() {
        if (this.getTeam() != null) {
            return this.getTeam().getName();
        }
        if (this.owner != null) {
            return this.owner.lastKnownName();
        }
        return this.customOwnerName;
    }

    public void initializeOwner(PlayerReference owner) {
        if (this.owner == null) {
            this.owner = owner;
        } else {
            LightmansCurrency.LogWarning("Attempted to initialize the owner for a trader that is already owned.");
        }
    }

    public CompoundTag setOwner(Player requestor, String newOwnerName) {
        if (!this.hasPermission(requestor, UPDATE_OWNERSHIP)) {
            CoreTraderSettings.PermissionWarning(requestor, "transfer ownership", UPDATE_OWNERSHIP);
            return null;
        }
        if (this.owner == null) {
            Team oldTeam = this.getTeam();
            if (oldTeam != null) {
                this.team = null;
            }
            this.owner = PlayerReference.of(newOwnerName);
            if (this.owner != null && oldTeam != null) {
                this.logger.LogTeamChange(requestor, this.owner, oldTeam, null);
            }
            if (this.bankAccountLinked) {
                this.bankAccountLinked = false;
            }
            CompoundTag updateInfo = CoreTraderSettings.initUpdateInfo(UPDATE_OWNERSHIP);
            updateInfo.m_128359_("newOwner", newOwnerName);
            return updateInfo;
        }
        PlayerReference newOwner = PlayerReference.of(newOwnerName);
        if (!(newOwner == null || this.owner.is(newOwner) && this.team == null)) {
            Team oldTeam = this.getTeam();
            this.team = null;
            PlayerReference oldOwner = this.owner;
            this.owner = newOwner;
            if (oldTeam == null) {
                this.logger.LogOwnerChange(requestor, oldOwner, this.owner);
            } else {
                this.logger.LogTeamChange(requestor, this.owner, oldTeam, null);
            }
            if (this.bankAccountLinked) {
                this.bankAccountLinked = false;
            }
            CompoundTag updateInfo = CoreTraderSettings.initUpdateInfo(UPDATE_OWNERSHIP);
            updateInfo.m_128359_("newOwner", newOwnerName);
            return updateInfo;
        }
        return null;
    }

    public CompoundTag setTeam(Player requestor, @Nullable UUID newTeamID) {
        if (!this.hasPermission(requestor, UPDATE_OWNERSHIP)) {
            CoreTraderSettings.PermissionWarning(requestor, "transfer team ownership", UPDATE_OWNERSHIP);
            return null;
        }
        Team oldTeam = this.getTeam();
        if (oldTeam != null && this.team.getID().equals(newTeamID)) {
            return null;
        }
        this.team = Team.referenceOf(newTeamID);
        Team newTeam = this.getTeam();
        this.logger.LogTeamChange(requestor, this.owner, oldTeam, newTeam);
        if (this.bankAccountLinked) {
            this.bankAccountLinked = false;
        }
        CompoundTag updateInfo = CoreTraderSettings.initUpdateInfo(UPDATE_TEAM);
        if (newTeamID != null) {
            updateInfo.m_128362_("Team", newTeamID);
        }
        return updateInfo;
    }

    public List<PlayerReference> getAllies() {
        return this.allies;
    }

    public CompoundTag addAlly(Player requestor, String newAllyName) {
        if (!this.hasPermission(requestor, "addRemoveAllies")) {
            CoreTraderSettings.PermissionWarning(requestor, "add an ally", "addRemoveAllies");
            return null;
        }
        if (!PlayerReference.listContains(this.allies, newAllyName)) {
            PlayerReference newAlly = PlayerReference.of(newAllyName);
            if (newAlly != null) {
                this.allies.add(newAlly);
                this.logger.LogAllyChange(requestor, newAlly, true);
            }
            if (newAlly != null || requestor.f_19853_.f_46443_) {
                CompoundTag updateInfo = CoreTraderSettings.initUpdateInfo(UPDATE_ADD_ALLY);
                updateInfo.m_128359_("AllyName", newAllyName);
                return updateInfo;
            }
        }
        return null;
    }

    public CompoundTag removeAlly(Player requestor, String removedAllyName) {
        if (!this.hasPermission(requestor, "addRemoveAllies")) {
            CoreTraderSettings.PermissionWarning(requestor, "remove an ally", "addRemoveAllies");
            return null;
        }
        if (PlayerReference.listContains(this.allies, removedAllyName)) {
            PlayerReference removedAlly = null;
            for (int i = 0; i < this.allies.size() && removedAlly == null; ++i) {
                if (!this.allies.get(i).is(removedAllyName)) continue;
                removedAlly = this.allies.get(i);
                this.allies.remove(i);
            }
            if (removedAlly == null) {
                return null;
            }
            this.logger.LogAllyChange(requestor, removedAlly, false);
            CompoundTag updateInfo = CoreTraderSettings.initUpdateInfo(UPDATE_REMOVE_ALLY);
            updateInfo.m_128359_("AllyName", removedAllyName);
            return updateInfo;
        }
        return null;
    }

    public void updateNames(Player player) {
        if (this.owner != null) {
            this.owner.tryUpdateName(player);
        }
        for (PlayerReference ally : this.allies) {
            ally.tryUpdateName(player);
        }
    }

    public boolean hasPermission(Player player, String permission) {
        return this.getPermissionLevel(player, permission) > 0;
    }

    public int getPermissionLevel(Player player, String permission) {
        if (player == null || TradingOffice.isAdminPlayer(player)) {
            return Integer.MAX_VALUE;
        }
        return this.getPermissionLevel(PlayerReference.of(player), permission);
    }

    public int getPermissionLevel(PlayerReference player, String permission) {
        if (player == null) {
            return 0;
        }
        AtomicInteger level = new AtomicInteger(0);
        if (PlayerReference.listContains(this.allies, player.id)) {
            level.set(this.allyPermissions.getLevel(permission));
        }
        if (this.team != null) {
            Team actualTeam = this.team.getTeam(this.trader.isClient());
            if (actualTeam != null) {
                int l;
                if (actualTeam.isAdmin(player.id)) {
                    return Integer.MAX_VALUE;
                }
                if (actualTeam.isMember(player.id) && (l = this.allyPermissions.getLevel(permission)) > level.get()) {
                    level.set(l);
                }
            }
        } else if (this.owner != null && this.owner.is(player)) {
            return Integer.MAX_VALUE;
        }
        return level.get();
    }

    public boolean isCreative() {
        return this.isCreative;
    }

    public CompoundTag toggleCreative(Player requestor) {
        if (!TradingOffice.isAdminPlayer(requestor)) {
            CoreTraderSettings.PermissionWarning(requestor, "toggle creative mode", "LC_ADMIN_MODE");
            return null;
        }
        this.isCreative = !this.isCreative;
        this.logger.LogCreativeToggle(requestor, this.isCreative);
        CompoundTag updateInfo = CoreTraderSettings.initUpdateInfo(UPDATE_CREATIVE);
        updateInfo.m_128379_("isCreative", this.isCreative);
        return updateInfo;
    }

    public void forceCreative() {
        this.isCreative = true;
    }

    public CompoundTag toggleBankAccountLink(Player requestor) {
        boolean sendValue;
        if (!this.hasPermission(requestor, UPDATE_BANK_LINK)) {
            CoreTraderSettings.PermissionWarning(requestor, "toggle bank account link", UPDATE_BANK_LINK);
            return null;
        }
        boolean bl = sendValue = !this.bankAccountLinked;
        if (this.bankAccountLinked || this.canLinkBankAccount()) {
            boolean bl2 = this.bankAccountLinked = !this.bankAccountLinked;
            if (this.bankAccountLinked && this.getBankAccount() != null && this.trader.getInternalStoredMoney().getRawValue() > 0L) {
                CoinValue money = this.trader.getInternalStoredMoney();
                this.getBankAccount().depositCoins(money);
                this.getBankAccount().LogInteraction(this.trader, money, true);
                this.trader.clearStoredMoney();
            }
        }
        CompoundTag result = CoreTraderSettings.initUpdateInfo(UPDATE_BANK_LINK);
        result.m_128379_("IsLinked", sendValue);
        return result;
    }

    public SettingsLogger getLogger() {
        return this.logger;
    }

    @Override
    public void changeSetting(Player requestor, CompoundTag updateInfo) {
        CompoundTag result;
        boolean newValue;
        if (this.isUpdateType(updateInfo, UPDATE_CUSTOM_NAME)) {
            String newName = updateInfo.m_128461_("NewName");
            CompoundTag result2 = this.setCustomName(requestor, newName);
            if (result2 != null) {
                this.markDirty();
            }
            LightmansCurrency.LogInfo("Custom Name changed to '" + newName + "' on the server.");
        } else if (this.isUpdateType(updateInfo, UPDATE_ADD_ALLY)) {
            String allyName = updateInfo.m_128461_("AllyName");
            CompoundTag result3 = this.addAlly(requestor, allyName);
            if (result3 != null) {
                this.markDirty();
            }
            LightmansCurrency.LogInfo("Attempted to add '" + allyName + "' as an ally.");
        } else if (this.isUpdateType(updateInfo, UPDATE_REMOVE_ALLY)) {
            String allyName = updateInfo.m_128461_("AllyName");
            CompoundTag result4 = this.removeAlly(requestor, allyName);
            if (result4 != null) {
                this.markDirty();
            }
            LightmansCurrency.LogInfo("Attempted to remove '" + allyName + "' from the ally list.");
        } else if (this.isUpdateType(updateInfo, UPDATE_CREATIVE)) {
            CompoundTag result5;
            boolean nowCreative = updateInfo.m_128471_("isCreative");
            if (nowCreative != this.isCreative && (result5 = this.toggleCreative(requestor)) != null) {
                this.markDirty();
            }
        } else if (this.isUpdateType(updateInfo, UPDATE_ALLY_PERMISSIONS)) {
            if (this.allyPermissions.changeLevel(requestor, updateInfo)) {
                this.markDirty();
            }
        } else if (this.isUpdateType(updateInfo, UPDATE_OWNERSHIP)) {
            String newOwnerName = updateInfo.m_128461_("newOwner");
            CompoundTag result6 = this.setOwner(requestor, newOwnerName);
            if (result6 != null) {
                this.markDirty();
            }
        } else if (this.isUpdateType(updateInfo, UPDATE_TEAM)) {
            CompoundTag result7;
            UUID newTeamID = null;
            if (updateInfo.m_128441_("Team")) {
                newTeamID = updateInfo.m_128342_("Team");
            }
            if ((result7 = this.setTeam(requestor, newTeamID)) != null) {
                this.markDirty();
            }
        } else if (this.isUpdateType(updateInfo, UPDATE_BANK_LINK) && (newValue = updateInfo.m_128471_("IsLinked")) != this.bankAccountLinked && (result = this.toggleBankAccountLink(requestor)) != null) {
            this.markDirty();
        }
    }

    @Override
    public CompoundTag save(CompoundTag compound) {
        this.saveOwner(compound);
        this.saveTeam(compound);
        this.saveAllyList(compound);
        this.saveAllyPermissions(compound);
        this.saveCustomName(compound);
        this.saveCreative(compound);
        this.saveBankAccountLink(compound);
        this.saveLogger(compound);
        return compound;
    }

    public CompoundTag saveOwner(CompoundTag compound) {
        if (this.owner != null) {
            compound.m_128365_("Owner", (Tag)this.owner.save());
        }
        if (!this.customOwnerName.isBlank()) {
            compound.m_128359_("CustomOwnerName", this.customOwnerName);
        }
        return compound;
    }

    public CompoundTag saveTeam(CompoundTag compound) {
        if (this.team != null) {
            compound.m_128362_("Team", this.team.getID());
        } else {
            compound.m_128379_("Team", false);
        }
        return compound;
    }

    public CompoundTag saveAllyList(CompoundTag compound) {
        PlayerReference.saveList(compound, this.allies, "Allies");
        return compound;
    }

    public CompoundTag saveAllyPermissions(CompoundTag compound) {
        this.allyPermissions.save(compound, "AllyPermissions");
        return compound;
    }

    public CompoundTag saveCustomName(CompoundTag compound) {
        compound.m_128359_("CustomName", this.customName);
        return compound;
    }

    public CompoundTag saveCreative(CompoundTag compound) {
        compound.m_128379_("Creative", this.isCreative);
        return compound;
    }

    public CompoundTag saveBankAccountLink(CompoundTag compound) {
        compound.m_128379_("BankLink", this.bankAccountLinked);
        return compound;
    }

    public CompoundTag saveLogger(CompoundTag compound) {
        this.logger.write(compound);
        return compound;
    }

    public void loadFromOldUniversalData(CompoundTag compound) {
        LightmansCurrency.LogInfo("Loading Core Trader Settings from old UniversalData compound.");
        UUID ownerID = null;
        String ownerName = "";
        if (compound.m_128441_("OwnerID")) {
            ownerID = compound.m_128342_("OwnerID");
        }
        if (compound.m_128425_("OwnerName", 8)) {
            ownerName = compound.m_128461_("OwnerName");
        }
        if (ownerID != null) {
            this.owner = PlayerReference.of(ownerID, ownerName);
        }
        if (compound.m_128441_("Creative")) {
            this.isCreative = compound.m_128471_("Creative");
        }
        if (compound.m_128425_("Allies", 9)) {
            this.allies.clear();
            ListTag allyList = compound.m_128437_("Allies", 10);
            for (int i = 0; i < allyList.size(); ++i) {
                CompoundTag thisAlly = allyList.m_128728_(i);
                if (!thisAlly.m_128425_("name", 8)) continue;
                this.addAlly(null, thisAlly.m_128461_("name"));
            }
        }
        if (compound.m_128425_("TraderName", 8)) {
            this.customName = compound.m_128461_("TraderName");
        }
    }

    public void loadFromOldTraderData(CompoundTag compound) {
        LightmansCurrency.LogInfo("Loading Core Trader Settings from old TileEntity compound.");
        UUID ownerID = null;
        String ownerName = "";
        if (compound.m_128441_("OwnerID")) {
            ownerID = compound.m_128342_("OwnerID");
        }
        if (compound.m_128425_("OwnerName", 8)) {
            ownerName = compound.m_128461_("OwnerName");
        }
        if (ownerID != null) {
            this.owner = PlayerReference.of(ownerID, ownerName);
        }
        if (compound.m_128441_("Creative")) {
            this.isCreative = compound.m_128471_("Creative");
        }
        if (compound.m_128425_("CustomName", 8)) {
            this.customName = compound.m_128461_("CustomName");
        }
        if (compound.m_128425_("Allies", 9)) {
            this.allies.clear();
            ListTag allyList = compound.m_128437_("Allies", 10);
            for (int i = 0; i < allyList.size(); ++i) {
                CompoundTag thisAlly = allyList.m_128728_(i);
                if (!thisAlly.m_128425_("name", 8)) continue;
                this.addAlly(null, thisAlly.m_128461_("name"));
            }
        }
    }

    @Override
    public void load(CompoundTag compound) {
        if (compound.m_128425_("Owner", 10)) {
            this.owner = PlayerReference.load(compound.m_128469_("Owner"));
        }
        if (compound.m_128425_("CustomOwnerName", 8)) {
            this.customOwnerName = compound.m_128461_("CustomOwnerName");
        }
        if (compound.m_128425_("Team", 1)) {
            this.team = null;
        } else if (compound.m_128441_("Team")) {
            this.team = Team.referenceOf(compound.m_128342_("Team"));
        }
        if (compound.m_128425_("Allies", 9)) {
            this.allies = PlayerReference.loadList(compound, "Allies");
        }
        if (compound.m_128425_("AllyPermissions", 9)) {
            this.allyPermissions = PermissionsList.load(this.trader, UPDATE_ALLY_PERMISSIONS, compound, "AllyPermissions");
        }
        if (compound.m_128425_("CustomName", 8)) {
            this.customName = compound.m_128461_("CustomName");
        }
        if (compound.m_128441_("Creative")) {
            this.isCreative = compound.m_128471_("Creative");
        }
        if (compound.m_128441_("BankLink")) {
            this.bankAccountLinked = compound.m_128471_("BankLink");
        }
        this.logger.read(compound);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<SettingsTab> getSettingsTabs() {
        return Lists.newArrayList((Object[])new SettingsTab[]{MainTab.INSTANCE, AllyTab.INSTANCE, AllyPermissionsTab.INSTANCE});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<SettingsTab> getBackEndSettingsTabs() {
        return Lists.newArrayList((Object[])new SettingsTab[]{LoggerTab.INSTANCE, OwnershipTab.INSTANCE});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<PermissionOption> getPermissionOptions() {
        ArrayList options = Lists.newArrayList((Object[])new PermissionOption[]{BooleanPermission.of("openStorage"), BooleanPermission.of("changeName"), BooleanPermission.of("editTrades"), BooleanPermission.of("collectCoins"), BooleanPermission.of("storeCoins"), BooleanPermission.of("editTradeRules"), BooleanPermission.of("editSettings"), BooleanPermission.of("addRemoveAllies"), BooleanPermission.of("editPermissions"), BooleanPermission.of("clearLogs"), BooleanPermission.of(UPDATE_BANK_LINK), BooleanPermission.of("breakTrader"), BooleanPermission.of(UPDATE_OWNERSHIP)});
        return options;
    }
}

