/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.settings;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.settings.item.ItemInputTab;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.permissions.options.BooleanPermission;
import io.github.lightman314.lightmanscurrency.trader.permissions.options.PermissionOption;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import io.github.lightman314.lightmanscurrency.trader.settings.directional.DirectionalSettings;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemTraderSettings
extends Settings {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "item_trader");
    private static final String UPDATE_INPUT_SIDE = "updateInputSide";
    private static final String UPDATE_OUTPUT_SIDE = "updateOutputSide";
    DirectionalSettings enabledInputSides = new DirectionalSettings();
    DirectionalSettings enabledOutputSides = new DirectionalSettings();

    public ItemTraderSettings(ITrader trader, Settings.IMarkDirty marker, BiConsumer<ResourceLocation, CompoundTag> sendToServer) {
        super(trader, marker, sendToServer, TYPE);
    }

    public DirectionalSettings getInputSides() {
        return this.enabledInputSides;
    }

    public DirectionalSettings getOutputSides() {
        return this.enabledOutputSides;
    }

    public CompoundTag toggleInputSide(Player requestor, Direction side) {
        if (!this.trader.hasPermission(requestor, "changeExternalInputs")) {
            ItemTraderSettings.PermissionWarning(requestor, "toggle external input side", "changeExternalInputs");
            return null;
        }
        this.enabledInputSides.set(side, !this.enabledInputSides.get(side));
        boolean newValue = this.enabledInputSides.get(side);
        this.trader.getCoreSettings().logger.LogSettingsChange(requestor, "inputSide." + side.toString(), newValue);
        CompoundTag updateInfo = ItemTraderSettings.initUpdateInfo(UPDATE_INPUT_SIDE);
        updateInfo.m_128405_("side", side.m_122411_());
        updateInfo.m_128379_("enabled", newValue);
        return updateInfo;
    }

    public CompoundTag toggleOutputSide(Player requestor, Direction side) {
        if (!this.trader.hasPermission(requestor, "changeExternalInputs")) {
            ItemTraderSettings.PermissionWarning(requestor, "toggle external output side", "changeExternalInputs");
            return null;
        }
        this.enabledOutputSides.set(side, !this.enabledOutputSides.get(side));
        boolean newValue = this.enabledOutputSides.get(side);
        this.trader.getCoreSettings().logger.LogSettingsChange(requestor, "outputSide." + side.toString(), newValue);
        CompoundTag updateInfo = ItemTraderSettings.initUpdateInfo(UPDATE_OUTPUT_SIDE);
        updateInfo.m_128405_("side", side.m_122411_());
        updateInfo.m_128379_("enabled", newValue);
        return updateInfo;
    }

    @Override
    public void changeSetting(Player requestor, CompoundTag updateInfo) {
        if (this.isUpdateType(updateInfo, UPDATE_INPUT_SIDE)) {
            CompoundTag result;
            Direction side = Direction.m_122376_((int)updateInfo.m_128451_("side"));
            boolean newValue = updateInfo.m_128471_("enabled");
            if (newValue != this.enabledInputSides.get(side) && (result = this.toggleInputSide(requestor, side)) != null) {
                this.markDirty();
            }
        } else if (this.isUpdateType(updateInfo, UPDATE_OUTPUT_SIDE)) {
            CompoundTag result;
            Direction side = Direction.m_122376_((int)updateInfo.m_128451_("side"));
            boolean newValue = updateInfo.m_128471_("enabled");
            if (newValue != this.enabledOutputSides.get(side) && (result = this.toggleOutputSide(requestor, side)) != null) {
                this.markDirty();
            }
        }
    }

    @Override
    public CompoundTag save(CompoundTag compound) {
        compound.m_128365_("InputSides", (Tag)this.enabledInputSides.save(new CompoundTag()));
        compound.m_128365_("OutputSides", (Tag)this.enabledOutputSides.save(new CompoundTag()));
        return compound;
    }

    @Override
    public void load(CompoundTag compound) {
        this.enabledInputSides.load(compound.m_128469_("InputSides"));
        this.enabledOutputSides.load(compound.m_128469_("OutputSides"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<SettingsTab> getSettingsTabs() {
        return Lists.newArrayList((Object[])new SettingsTab[]{ItemInputTab.INSTANCE});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<SettingsTab> getBackEndSettingsTabs() {
        return Lists.newArrayList();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<PermissionOption> getPermissionOptions() {
        return Lists.newArrayList((Object[])new PermissionOption[]{BooleanPermission.of("changeExternalInputs")});
    }
}

