/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import com.google.common.base.Preconditions;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.plugins.vanilla.RecipeBookGuiHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.renderer.Rect2i;
import org.jetbrains.annotations.Nullable;

public class GuiProperties
implements IGuiProperties {
    private final Class<? extends Screen> screenClass;
    private final int guiLeft;
    private final int guiTop;
    private final int guiXSize;
    private final int guiYSize;
    private final int screenWidth;
    private final int screenHeight;

    @Nullable
    public static GuiProperties create(AbstractContainerScreen<?> containerScreen) {
        RecipeUpdateListener r;
        Rect2i bookArea;
        if (containerScreen.f_96543_ <= 0 || containerScreen.f_96544_ <= 0) {
            return null;
        }
        int x = containerScreen.getGuiLeft();
        int y = containerScreen.getGuiTop();
        int width = containerScreen.getXSize();
        int height = containerScreen.getYSize();
        if (containerScreen instanceof RecipeUpdateListener && (bookArea = RecipeBookGuiHandler.getBookArea(r = (RecipeUpdateListener)containerScreen)) != null) {
            width += x - bookArea.m_110085_();
            x = bookArea.m_110085_();
        }
        if (x < 0) {
            width -= x;
            x = 0;
        }
        if (y < 0) {
            height -= y;
            y = 0;
        }
        if (width <= 0 || height <= 0) {
            return null;
        }
        return new GuiProperties(containerScreen.getClass(), x, y, width, height, containerScreen.f_96543_, containerScreen.f_96544_);
    }

    @Nullable
    public static GuiProperties create(RecipesGui recipesGui) {
        if (recipesGui.f_96543_ <= 0 || recipesGui.f_96544_ <= 0) {
            return null;
        }
        int extraWidth = recipesGui.getRecipeCatalystExtraWidth();
        ImmutableRect2i recipeArea = recipesGui.getArea();
        int guiXSize = recipeArea.getWidth() + extraWidth;
        int guiYSize = recipeArea.getHeight();
        if (guiXSize <= 0 || guiYSize <= 0) {
            return null;
        }
        return new GuiProperties(recipesGui.getClass(), recipeArea.getX() - extraWidth, recipeArea.getY(), guiXSize, guiYSize, recipesGui.f_96543_, recipesGui.f_96544_);
    }

    public static boolean areEqual(@Nullable IGuiProperties a, @Nullable IGuiProperties b) {
        if (a == b) {
            return true;
        }
        return a != null && b != null && a.getScreenClass().equals(b.getScreenClass()) && a.getGuiLeft() == b.getGuiLeft() && a.getGuiXSize() == b.getGuiXSize() && a.getScreenWidth() == b.getScreenWidth() && a.getScreenHeight() == b.getScreenHeight();
    }

    public static ImmutableRect2i getScreenRectangle(IGuiProperties guiProperties) {
        return new ImmutableRect2i(0, 0, guiProperties.getScreenWidth(), guiProperties.getScreenHeight());
    }

    public static ImmutableRect2i getGuiRectangle(IGuiProperties guiProperties) {
        return new ImmutableRect2i(guiProperties.getGuiLeft(), guiProperties.getGuiTop(), guiProperties.getGuiXSize(), guiProperties.getGuiYSize());
    }

    public static int getGuiRight(IGuiProperties guiProperties) {
        return guiProperties.getGuiLeft() + guiProperties.getGuiXSize();
    }

    public static int getGuiBottom(IGuiProperties guiProperties) {
        return guiProperties.getGuiTop() + guiProperties.getGuiYSize();
    }

    private GuiProperties(Class<? extends Screen> screenClass, int guiLeft, int guiTop, int guiXSize, int guiYSize, int screenWidth, int screenHeight) {
        Preconditions.checkArgument((guiLeft >= 0 ? 1 : 0) != 0, (Object)"guiLeft must be >= 0");
        Preconditions.checkArgument((guiTop >= 0 ? 1 : 0) != 0, (Object)"guiTop must be >= 0");
        Preconditions.checkArgument((guiXSize > 0 ? 1 : 0) != 0, (Object)"guiXSize must be > 0");
        Preconditions.checkArgument((guiYSize > 0 ? 1 : 0) != 0, (Object)"guiYSize must be > 0");
        Preconditions.checkArgument((screenWidth > 0 ? 1 : 0) != 0, (Object)"screenWidth must be > 0");
        Preconditions.checkArgument((screenHeight > 0 ? 1 : 0) != 0, (Object)"screenHeight must be > 0");
        this.screenClass = screenClass;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.guiXSize = guiXSize;
        this.guiYSize = guiYSize;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    @Override
    public Class<? extends Screen> getScreenClass() {
        return this.screenClass;
    }

    @Override
    public int getGuiLeft() {
        return this.guiLeft;
    }

    @Override
    public int getGuiTop() {
        return this.guiTop;
    }

    @Override
    public int getGuiXSize() {
        return this.guiXSize;
    }

    @Override
    public int getGuiYSize() {
        return this.guiYSize;
    }

    @Override
    public int getScreenWidth() {
        return this.screenWidth;
    }

    @Override
    public int getScreenHeight() {
        return this.screenHeight;
    }
}

