/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.config.ModIdFormattingConfig;
import mezz.jei.core.config.IClientConfig;
import mezz.jei.ingredients.AbstractModIdHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.lang3.StringUtils;

public class ForgeModIdHelper
extends AbstractModIdHelper {
    private final IClientConfig config;
    private final ModIdFormattingConfig modIdFormattingConfig;

    public ForgeModIdHelper(IClientConfig config, ModIdFormattingConfig modIdFormattingConfig) {
        this.config = config;
        this.modIdFormattingConfig = modIdFormattingConfig;
    }

    @Override
    public String getModNameForModId(String modId) {
        return ModList.get().getModContainerById(modId).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(StringUtils.capitalize((String)modId));
    }

    @Override
    public boolean isDisplayingModNameEnabled() {
        String modNameFormat = this.modIdFormattingConfig.getModNameFormat();
        return !modNameFormat.isEmpty();
    }

    @Override
    public String getFormattedModNameForModId(String modId) {
        String modName = this.getModNameForModId(modId);
        modName = ForgeModIdHelper.removeChatFormatting(modName);
        String modNameFormat = this.modIdFormattingConfig.getModNameFormat();
        if (!modNameFormat.isEmpty()) {
            if (modNameFormat.contains("%MODNAME%")) {
                return StringUtils.replaceOnce((String)modNameFormat, (String)"%MODNAME%", (String)modName);
            }
            return modNameFormat + modName;
        }
        return modName;
    }

    private static String removeChatFormatting(String string) {
        String withoutFormattingCodes = ChatFormatting.m_126649_((String)string);
        return withoutFormattingCodes == null ? "" : withoutFormattingCodes;
    }

    @Override
    public <T> List<Component> addModNameToIngredientTooltip(List<Component> tooltip, T ingredient, IIngredientHelper<T> ingredientHelper) {
        if (this.config.isDebugModeEnabled() && Minecraft.m_91087_().f_91066_.f_92125_) {
            tooltip = ForgeModIdHelper.addDebugInfo(tooltip, ingredient, ingredientHelper);
        }
        if (this.modIdFormattingConfig.isModNameFormatOverrideActive() && ingredient instanceof ItemStack) {
            return tooltip;
        }
        String modNameFormat = this.modIdFormattingConfig.getModNameFormat();
        if (modNameFormat.isEmpty()) {
            return tooltip;
        }
        return super.addModNameToIngredientTooltip(tooltip, ingredient, ingredientHelper);
    }

    private static <T> List<Component> addDebugInfo(List<Component> tooltip, T ingredient, IIngredientHelper<T> ingredientHelper) {
        tooltip = new ArrayList<Component>(tooltip);
        TextComponent jeiDebug = new TextComponent("JEI Debug:");
        TextComponent info = new TextComponent("info: " + ingredientHelper.getErrorInfo(ingredient));
        TextComponent uid = new TextComponent("uid: " + ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient));
        tooltip.add((Component)jeiDebug.m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)info.m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)uid.m_130940_(ChatFormatting.GRAY));
        return tooltip;
    }
}

