/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.load.registration;

import com.google.common.collect.ImmutableMap;
import java.util.IdentityHashMap;
import java.util.Map;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.util.ErrorUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SubtypeRegistration
implements ISubtypeRegistration {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<Item, IIngredientSubtypeInterpreter<ItemStack>> itemInterpreters = new IdentityHashMap<Item, IIngredientSubtypeInterpreter<ItemStack>>();
    private final Map<Fluid, IIngredientSubtypeInterpreter<FluidStack>> fluidInterpreters = new IdentityHashMap<Fluid, IIngredientSubtypeInterpreter<FluidStack>>();

    @Override
    public void useNbtForSubtypes(Item ... items) {
        for (Item item : items) {
            this.registerSubtypeInterpreter(item, AllNbt.INSTANCE);
        }
    }

    @Override
    public void useNbtForSubtypes(Fluid ... fluids) {
        for (Fluid fluid : fluids) {
            this.registerSubtypeInterpreter(fluid, AllFluidNbt.INSTANCE);
        }
    }

    @Override
    public void registerSubtypeInterpreter(Item item, IIngredientSubtypeInterpreter<ItemStack> interpreter) {
        ErrorUtil.checkNotNull(item, "item ");
        ErrorUtil.checkNotNull(interpreter, "interpreter");
        if (this.itemInterpreters.containsKey(item)) {
            LOGGER.error("An interpreter is already registered for this item: {}", (Object)item, (Object)new IllegalArgumentException());
            return;
        }
        this.itemInterpreters.put(item, interpreter);
    }

    @Override
    public void registerSubtypeInterpreter(Fluid fluid, IIngredientSubtypeInterpreter<FluidStack> interpreter) {
        ErrorUtil.checkNotNull(fluid, "fluid ");
        ErrorUtil.checkNotNull(interpreter, "interpreter");
        if (this.fluidInterpreters.containsKey(fluid)) {
            LOGGER.error("An interpreter is already registered for this fluid: {}", (Object)fluid, (Object)new IllegalArgumentException());
            return;
        }
        this.fluidInterpreters.put(fluid, interpreter);
    }

    @Override
    public boolean hasSubtypeInterpreter(ItemStack itemStack) {
        ErrorUtil.checkNotEmpty(itemStack);
        Item item = itemStack.m_41720_();
        return this.itemInterpreters.containsKey(item);
    }

    @Override
    public boolean hasSubtypeInterpreter(FluidStack fluidStack) {
        ErrorUtil.checkNotNull(fluidStack, "fluid ");
        Fluid fluid = fluidStack.getFluid();
        return this.fluidInterpreters.containsKey(fluid);
    }

    public ImmutableMap<Item, IIngredientSubtypeInterpreter<ItemStack>> getItemInterpreters() {
        return ImmutableMap.copyOf(this.itemInterpreters);
    }

    public ImmutableMap<Fluid, IIngredientSubtypeInterpreter<FluidStack>> getFluidInterpreters() {
        return ImmutableMap.copyOf(this.fluidInterpreters);
    }

    private static class AllNbt
    implements IIngredientSubtypeInterpreter<ItemStack> {
        public static final AllNbt INSTANCE = new AllNbt();

        private AllNbt() {
        }

        @Override
        public String apply(ItemStack itemStack, UidContext context) {
            CompoundTag nbtTagCompound = itemStack.m_41783_();
            if (nbtTagCompound == null || nbtTagCompound.m_128456_()) {
                return "";
            }
            return nbtTagCompound.toString();
        }
    }

    private static class AllFluidNbt
    implements IIngredientSubtypeInterpreter<FluidStack> {
        public static final AllFluidNbt INSTANCE = new AllFluidNbt();

        private AllFluidNbt() {
        }

        @Override
        public String apply(FluidStack fluidStack, UidContext context) {
            CompoundTag nbtTagCompound = fluidStack.getTag();
            if (nbtTagCompound == null || nbtTagCompound.m_128456_()) {
                return "";
            }
            return nbtTagCompound.toString();
        }
    }
}

