/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.network;

import java.util.EnumMap;
import mezz.jei.common.network.ClientPacketData;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.PacketIdClient;
import mezz.jei.common.network.packets.IClientPacketHandler;
import mezz.jei.common.network.packets.PacketCheatPermission;
import mezz.jei.core.config.IServerConfig;
import mezz.jei.core.config.IWorldConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;

public class ClientPacketRouter {
    public final EnumMap<PacketIdClient, IClientPacketHandler> clientHandlers = new EnumMap(PacketIdClient.class);
    private final IConnectionToServer connection;
    private final IServerConfig serverConfig;
    private final IWorldConfig worldConfig;

    public ClientPacketRouter(IConnectionToServer connection, IServerConfig serverConfig, IWorldConfig worldConfig) {
        this.connection = connection;
        this.serverConfig = serverConfig;
        this.worldConfig = worldConfig;
        this.clientHandlers.put(PacketIdClient.CHEAT_PERMISSION, PacketCheatPermission::readPacketData);
    }

    public void onPacket(FriendlyByteBuf packetBuffer) {
        byte packetIdOrdinal = packetBuffer.readByte();
        PacketIdClient packetId = PacketIdClient.VALUES[packetIdOrdinal];
        IClientPacketHandler packetHandler = this.clientHandlers.get(packetId);
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player != null) {
            ClientPacketData data = new ClientPacketData(packetBuffer, player, this.connection, this.serverConfig, this.worldConfig);
            packetHandler.readPacketData(data);
        }
    }
}

