/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.data;

import com.google.common.base.Strings;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Lists;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.dto.RealmsServer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.log.JMLogger;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.log.LogFormatter;
import journeymap.common.version.VersionCheck;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.ClientPackSource;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.Connection;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.commons.lang3.text.WordUtils;

public class WorldData
extends CacheLoader<Class, WorldData> {
    private static String DAYTIME = Constants.getString("jm.theme.labelsource.gametime.day");
    private static String SUNRISE = Constants.getString("jm.theme.labelsource.gametime.sunrise");
    private static String SUNSET = Constants.getString("jm.theme.labelsource.gametime.sunset");
    private static String NIGHT = Constants.getString("jm.theme.labelsource.gametime.night");
    String name;
    String dimension;
    long time;
    boolean hardcore;
    boolean singlePlayer;
    Map<Feature, Boolean> features;
    String jm_version;
    String latest_journeymap_version;
    String mc_version;
    String mod_name = JourneymapClient.MOD_NAME;
    String iconSetName;
    String[] iconSetNames;
    int browser_poll;

    public static boolean isHardcoreAndMultiplayer() {
        WorldData world = DataCache.INSTANCE.getWorld(false);
        return world.hardcore && !world.singlePlayer;
    }

    private static String getServerName() {
        try {
            Minecraft mc;
            String serverName;
            block9: {
                serverName = null;
                mc = Minecraft.m_91087_();
                if (!mc.m_91091_()) {
                    try {
                        RealmsScreen realmsScreen;
                        ClientPacketListener netHandler = mc.m_91403_();
                        Screen callbackScreen = netHandler.f_104887_;
                        if (!(callbackScreen instanceof RealmsScreen) || !((realmsScreen = (RealmsScreen)callbackScreen) instanceof RealmsMainScreen)) break block9;
                        RealmsMainScreen mainScreen = (RealmsMainScreen)realmsScreen;
                        RealmsServer selectedServer = mainScreen.m_193481_();
                        List realmsServers = mainScreen.f_86291_;
                        for (RealmsServer realmsServer : realmsServers) {
                            if (realmsServer.f_87473_ != selectedServer.f_87473_) continue;
                            serverName = realmsServer.f_87475_;
                            break;
                        }
                    }
                    catch (Throwable t) {
                        Journeymap.getLogger().error("Unable to get Realms server name: " + LogFormatter.toString(t));
                    }
                }
            }
            if (serverName != null) {
                return serverName;
            }
            mc = Minecraft.m_91087_();
            ServerData serverData = mc.m_91089_();
            if (serverData != null && (serverName = serverData.f_105362_) != null) {
                if (Strings.isNullOrEmpty((String)(serverName = serverName.replaceAll("\\W+", "~").trim()).replaceAll("~", ""))) {
                    serverName = serverData.f_105363_;
                }
                return serverName;
            }
            return null;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Couldn't get service name: " + LogFormatter.toString(t));
            return WorldData.getLegacyServerName();
        }
    }

    public static String getLegacyServerName() {
        try {
            SocketAddress socketAddress;
            Connection netManager = Minecraft.m_91087_().m_91403_().m_6198_();
            if (netManager != null && (socketAddress = netManager.m_129523_()) != null && socketAddress instanceof InetSocketAddress) {
                InetSocketAddress inetAddr = (InetSocketAddress)socketAddress;
                return inetAddr.getHostName();
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Couldn't get server name: " + LogFormatter.toString(t));
        }
        return "server";
    }

    public static String getWorldName(Minecraft mc) {
        String serverName = null;
        if (mc.m_91091_()) {
            return mc.m_91092_().f_129744_.m_78277_();
        }
        serverName = WorldData.getServerName();
        if (serverName == null) {
            return "offline";
        }
        if (Strings.isNullOrEmpty((String)serverName.trim())) {
            serverName = "unnamed";
        }
        return serverName.trim();
    }

    public static List<DimensionProvider> getDimensionProviders() {
        return WorldData.getDimensionProviders(Lists.newArrayList());
    }

    public static List<DimensionProvider> getDimensionProviders(List<String> requiredDimensionList) {
        try {
            HashSet<String> requiredDims = new HashSet<String>(requiredDimensionList);
            HashMap<String, DimensionProvider> dimProviders = new HashMap<String, DimensionProvider>();
            org.apache.logging.log4j.Level logLevel = org.apache.logging.log4j.Level.DEBUG;
            Journeymap.getLogger().log(logLevel, String.format("Required dimensions from waypoints: %s", requiredDimensionList));
            Minecraft mc = Minecraft.m_91087_();
            ResourceKey<Level> dimension = DimensionHelper.getDimension((Entity)mc.f_91074_);
            String dimId = DimensionHelper.getDimKeyName(dimension);
            WrappedProvider playerDimProvider = new WrappedProvider(dimension);
            dimProviders.put(dimId, playerDimProvider);
            requiredDims.remove(dimId);
            Journeymap.getLogger().log(logLevel, String.format("Using player's provider for dim %s: %s", dimId, WorldData.getSafeDimensionName(playerDimProvider)));
            for (ResourceKey<Level> resourceKey : DimensionHelper.getClientDimList()) {
                try {
                    WrappedProvider dimProvider = new WrappedProvider(resourceKey);
                    dimProviders.put(DimensionHelper.getDimKeyName(resourceKey), dimProvider);
                    Journeymap.getLogger().log(logLevel, String.format("DimensionManager.getProvider(%s): %s", resourceKey, WorldData.getSafeDimensionName(dimProvider)));
                }
                catch (Throwable t) {
                    JMLogger.logOnce(String.format("Couldn't DimensionManager.getProvider(%s) because of error: %s", resourceKey, t), t);
                }
            }
            requiredDims.removeAll(dimProviders.keySet());
            for (String string : requiredDims) {
                if (dimProviders.containsKey(string)) continue;
                dimProviders.put(string, new DummyProvider(DimensionHelper.getWorldKeyForName(string)));
                Journeymap.getLogger().warn(String.format("Used DummyProvider for required dim: %s", string));
            }
            ArrayList<DimensionProvider> providerList = new ArrayList<DimensionProvider>(dimProviders.values());
            Collections.sort(providerList, new Comparator<DimensionProvider>(){

                @Override
                public int compare(DimensionProvider o1, DimensionProvider o2) {
                    return String.valueOf(o1.getDimensionId()).compareTo(o2.getDimensionId());
                }
            });
            return providerList;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Unexpected error in WorldData.getDimensionProviders(): ", t);
            return Collections.emptyList();
        }
    }

    public static String getSafeDimensionName(DimensionProvider dimensionProvider) {
        if (dimensionProvider == null || dimensionProvider.getDimensionId() == null) {
            return null;
        }
        try {
            return dimensionProvider.getDimensionId();
        }
        catch (Exception e) {
            Minecraft mc = Minecraft.m_91087_();
            return Constants.getString("jm.common.dimension", DimensionHelper.getDimName((Level)mc.f_91073_));
        }
    }

    public static String getDimension() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        String dim = DimensionHelper.getDimName((Entity)player);
        String dimName = WorldData.getSafeDimensionName(new WrappedProvider((ResourceKey<Level>)Minecraft.m_91087_().f_91074_.f_19853_.m_46472_()));
        return dimName + " (" + dim + ")";
    }

    public WorldData load(Class aClass) throws Exception {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel.ClientLevelData worldInfo = mc.f_91073_.m_6106_();
        IntegratedServer server = mc.m_91092_();
        boolean multiplayer = server == null || server.m_6992_();
        this.name = WorldData.getWorldName(mc);
        this.dimension = DimensionHelper.getDimKeyName((Level)mc.f_91073_);
        this.hardcore = worldInfo.m_5466_();
        this.singlePlayer = !multiplayer;
        this.time = mc.f_91073_.m_46468_() % 24000L;
        this.features = FeatureManager.getInstance().getAllowedFeatures();
        this.mod_name = JourneymapClient.MOD_NAME;
        this.jm_version = Journeymap.JM_VERSION.toString();
        this.latest_journeymap_version = VersionCheck.getVersionAvailable();
        this.mc_version = (String)ClientPackSource.m_118589_().get("X-Minecraft-Version");
        this.browser_poll = Math.max(1000, JourneymapClient.getInstance().getCoreProperties().browserPoll.get());
        return this;
    }

    public static String getLightLevel() {
        BlockPos blockpos = Minecraft.m_91087_().f_91074_.m_142538_();
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        LevelChunk chunk = world.m_46745_(blockpos);
        int light = chunk.m_62953_().m_5518_().m_75831_(blockpos, 0);
        int lightSky = world.m_45517_(LightLayer.SKY, blockpos);
        int lightBlock = world.m_45517_(LightLayer.BLOCK, blockpos);
        return String.format("Light: %s (%s sky, %s block)", light, lightSky, lightBlock);
    }

    public static String getRegion() {
        BlockPos blockpos = Minecraft.m_91087_().f_91074_.m_142538_();
        LevelChunk chunk = Minecraft.m_91087_().f_91073_.m_46745_(blockpos);
        RegionCoord regionCoord = RegionCoord.fromChunkPos(null, MapType.none(), chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_);
        return "Region: x:" + regionCoord.regionX + " z:" + regionCoord.regionZ;
    }

    public static String getRealGameTime() {
        String format = JourneymapClient.getInstance().getActiveMiniMapProperties().gameTimeRealFormat.get();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(format);
        Minecraft minecraft = Minecraft.m_91087_();
        long time = minecraft.f_91073_.m_46468_();
        long hour = (time / 1000L + 6L) % 24L;
        long minute = time % 1000L * 60L / 1000L;
        double ticks = (double)time - Math.floor((double)time / 16.666666666666668) * 16.666666666666668;
        long seconds = (long)Math.floor(ticks / 0.2777777777777778);
        String timeString = String.format(Locale.ENGLISH, "%02d:%02d:%02d", hour, minute, seconds);
        String formattedTime = LocalTime.parse(timeString).format(dtf);
        return formattedTime + " " + WorldData.getContextTime(time % 24000L);
    }

    public static String getMoonPhase() {
        int phase = Minecraft.m_91087_().f_91073_.m_46941_();
        long worldTime = Minecraft.m_91087_().f_91073_.m_46468_() % 24000L;
        if (WorldData.isDay(worldTime)) {
            phase = 10;
        }
        return MoonPhase.fromPhase(phase);
    }

    public static String getSystemTime() {
        SimpleDateFormat timeFormat = new SimpleDateFormat(JourneymapClient.getInstance().getActiveMiniMapProperties().systemTimeRealFormat.get());
        return timeFormat.format(new Date());
    }

    public static String getGameTime() {
        if (Minecraft.m_91087_().f_91073_ != null) {
            long worldTime = Minecraft.m_91087_().f_91073_.m_46468_() % 24000L;
            long allSecs = worldTime / 20L;
            return String.format("%02d:%02d %s", (long)Math.floor(allSecs / 60L), (long)Math.ceil(allSecs % 60L), WorldData.getContextTime(worldTime));
        }
        return "";
    }

    private static String getContextTime(long worldTime) {
        if (worldTime < 12000L) {
            return DAYTIME;
        }
        if (worldTime < 13800L) {
            return SUNSET;
        }
        if (worldTime < 22200L) {
            return NIGHT;
        }
        return SUNRISE;
    }

    public static boolean isDay(long worldTime) {
        return worldTime % 24000L < 13800L;
    }

    public static boolean isNight(long worldTime) {
        return worldTime % 24000L >= 13800L;
    }

    public long getTTL() {
        return 1000L;
    }

    public static class WrappedProvider
    implements DimensionProvider {
        ResourceKey<Level> dimension;

        public WrappedProvider(ResourceKey<Level> dimension) {
            this.dimension = dimension;
        }

        @Override
        public String getDimensionId() {
            return DimensionHelper.getDimKeyName(this.dimension);
        }

        @Override
        public ResourceKey<Level> getDimension() {
            return this.dimension;
        }

        @Override
        public String getName() {
            String dim = DimensionHelper.getDimName(this.dimension).replace("_", " ");
            return WordUtils.capitalize((String)dim);
        }
    }

    public static interface DimensionProvider {
        public String getDimensionId();

        public ResourceKey<Level> getDimension();

        public String getName();
    }

    static class DummyProvider
    implements DimensionProvider {
        final ResourceKey<Level> dim;

        DummyProvider(ResourceKey<Level> dim) {
            this.dim = dim;
        }

        @Override
        public String getDimensionId() {
            return DimensionHelper.getDimKeyName(this.dim);
        }

        @Override
        public ResourceKey<Level> getDimension() {
            return null;
        }

        @Override
        public String getName() {
            return "Dimension " + DimensionHelper.getDimName(this.dim);
        }
    }

    static enum MoonPhase {
        DAY_TIME(10, "jm.theme.labelsource.moonphase.day"),
        FULL_MOON(0, "jm.theme.labelsource.moonphase.full_moon"),
        WANING_GIBBOUS(1, "jm.theme.labelsource.moonphase.waning_gibbous"),
        THIRD_QUARTER(2, "jm.theme.labelsource.moonphase.third_quarter"),
        WANING_CRESCENT(3, "jm.theme.labelsource.moonphase.waning_crescent"),
        NEW_MOON(4, "jm.theme.labelsource.moonphase.new_moon"),
        WAXING_CRESCENT(5, "jm.theme.labelsource.moonphase.waxing_crescent"),
        FIRST_QUARTER(6, "jm.theme.labelsource.moonphase.first_quarter"),
        WAXING_GIBBOUS(7, "jm.theme.labelsource.moonphase.waxing_gibbous");

        final int phase;
        final String key;
        static final Map<Integer, String> PHASE_MAP;

        private MoonPhase(int phase, String key) {
            this.phase = phase;
            this.key = key;
        }

        public static String fromPhase(int phase) {
            String phaseName = Constants.getString(PHASE_MAP.get(phase));
            String moonPhase = Constants.getString("jm.theme.labelsource.moonphase.pre");
            return moonPhase + phaseName;
        }

        static {
            PHASE_MAP = Stream.of(MoonPhase.values()).collect(Collectors.toMap(e -> e.phase, e -> e.key));
        }
    }
}

