/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.forge;

import journeymap.client.event.forge.ForgeEventHandlerManager;
import journeymap.client.event.handlers.HudOverlayHandler;
import journeymap.client.ui.minimap.Effect;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ForgeHudOverlayEvents
implements ForgeEventHandlerManager.EventHandler {
    private boolean shouldPop = false;
    private final HudOverlayHandler overlayHandler = new HudOverlayHandler();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void preOverlay(RenderGameOverlayEvent.PreLayer event) {
        this.shouldPop = event.getOverlay().equals(ForgeIngameGui.POTION_ICONS_ELEMENT) ? this.overlayHandler.preOverlay(event.getMatrixStack()) : false;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void preOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && Effect.getInstance().canPotionShift()) {
            this.shouldPop = false;
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && event.isCancelable() && !event.isCanceled()) {
            this.overlayHandler.onRenderOverlay(event.getMatrixStack());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void postOverlay(RenderGameOverlayEvent.PostLayer event) {
        if (event.getOverlay().equals(ForgeIngameGui.POTION_ICONS_ELEMENT) && this.shouldPop && EventPriority.HIGHEST.equals((Object)event.getPhase()) && Effect.getInstance().canPotionShift()) {
            this.overlayHandler.postOverlay(event.getMatrixStack());
            this.shouldPop = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderOverlayDebug(RenderGameOverlayEvent.Text event) {
        this.overlayHandler.onRenderOverlayDebug(event.getLeft());
    }
}

