/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypoint;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.data.WorldData;
import journeymap.client.log.JMLogger;
import journeymap.client.properties.FullMapProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.OnOffButton;
import journeymap.client.ui.component.ScrollPane;
import journeymap.client.ui.component.TextBox;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.option.LocationFormat;
import journeymap.client.ui.waypoint.WaypointManager;
import journeymap.client.waypoint.Waypoint;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class WaypointEditor
extends JmUI {
    private final TextureImpl wpTexture;
    private final TextureImpl colorPickTexture;
    private final Waypoint originalWaypoint;
    private final boolean isNew;
    String labelName = Constants.getString("jm.waypoint.name");
    String locationTitle = Constants.getString("jm.waypoint.location");
    String colorTitle = Constants.getString("jm.waypoint.color");
    String dimensionsTitle = Constants.getString("jm.waypoint.dimensions");
    String labelX = Constants.getString("jm.waypoint.x");
    String labelY = Constants.getString("jm.waypoint.y");
    String labelZ = Constants.getString("jm.waypoint.z");
    String labelR = Constants.getString("jm.waypoint.red_abbreviated");
    String labelG = Constants.getString("jm.waypoint.green_abbreviated");
    String labelB = Constants.getString("jm.waypoint.blue_abbreviated");
    String currentLocation = "";
    LocationFormat.LocationFormatKeys locationFormatKeys;
    private Button buttonRandomize;
    private OnOffButton buttonEnable;
    private Button buttonRemove;
    private Button buttonReset;
    private Button buttonSave;
    private Button buttonClose;
    private TextBox fieldName;
    private TextBox fieldR;
    private TextBox fieldG;
    private TextBox fieldB;
    private TextBox fieldX;
    private TextBox fieldY;
    private TextBox fieldZ;
    private ArrayList<TextBox> fieldList = new ArrayList();
    private ArrayList<DimensionButton> dimButtonList = new ArrayList();
    private ScrollPane dimScrollPane;
    private Integer currentColor;
    private Rectangle2D.Double colorPickRect;
    private BufferedImage colorPickImg;
    private String colorPickTooltip;
    private Waypoint editedWaypoint;
    private ButtonList bottomButtons;
    private float partialTicks;
    private boolean openedWithHotKey = true;
    private final int bottomY = -100;

    public WaypointEditor(Waypoint waypoint, boolean isNew, JmUI returnDisplay) {
        super(Constants.getString(isNew ? "jm.waypoint.new_title" : "jm.waypoint.edit_title"), returnDisplay);
        String tooltip;
        this.originalWaypoint = waypoint;
        this.editedWaypoint = new Waypoint(this.originalWaypoint);
        this.isNew = isNew;
        this.wpTexture = waypoint.getTexture();
        this.colorPickTooltip = tooltip = Constants.birthdayMessage();
        this.colorPickTexture = tooltip == null ? TextureCache.getTexture(TextureCache.ColorPicker) : TextureCache.getTexture(TextureCache.ColorPicker2);
        try {
            this.colorPickRect = new Rectangle2D.Double(0.0, 0.0, this.colorPickTexture.getWidth(), this.colorPickTexture.getHeight());
            this.colorPickImg = this.colorPickTexture.getImage();
            Minecraft.m_91087_().f_91068_.m_90926_(true);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error during WaypointEditor ctor: " + LogFormatter.toPartialString(t));
            UIManager.INSTANCE.closeAll();
        }
        if (returnDisplay != null && !(returnDisplay instanceof Fullscreen)) {
            this.openedWithHotKey = false;
        }
    }

    @Override
    public void m_7856_() {
        try {
            this.setRenderBottomBar(true);
            FullMapProperties fullMapProperties = JourneymapClient.getInstance().getFullMapProperties();
            LocationFormat locationFormat = new LocationFormat();
            this.locationFormatKeys = locationFormat.getFormatKeys(fullMapProperties.locationFormat.get());
            String pos = this.locationFormatKeys.format(fullMapProperties.locationFormatVerbose.get(), Mth.m_14107_((double)this.f_96541_.f_91074_.m_20185_()), Mth.m_14107_((double)this.f_96541_.f_91074_.m_20189_()), Mth.m_14107_((double)this.f_96541_.f_91074_.m_142469_().f_82289_), Mth.m_14143_((float)(this.f_96541_.f_91074_.m_146904_() >> 4)));
            this.currentLocation = Constants.getString("jm.waypoint.current_location", " " + pos);
            if (this.fieldList.isEmpty()) {
                Font fr = this.getFontRenderer();
                this.fieldName = new TextBox(this.originalWaypoint.getName(), fr, 160, 20);
                if (this.isNew) {
                    this.fieldName.m_94178_(true);
                    this.fieldName.m_94201_();
                    this.fieldName.m_94208_(0);
                }
                this.fieldList.add(this.fieldName);
                int width9chars = this.getFontRenderer().m_92895_("-30000000") + 10;
                int width3chars = this.getFontRenderer().m_92895_("255") + 10;
                int width4chars = this.getFontRenderer().m_92895_("-255") + 10;
                int h = 20;
                this.fieldX = new TextBox(this.originalWaypoint.getX(), fr, width9chars, h, true, true);
                this.fieldX.setClamp(-30000000, 30000000);
                this.fieldList.add(this.fieldX);
                this.fieldZ = new TextBox(this.originalWaypoint.getZ(), fr, width9chars, h, true, true);
                this.fieldZ.setClamp(-30000000, 30000000);
                this.fieldList.add(this.fieldZ);
                int y = this.originalWaypoint.getY();
                this.fieldY = new TextBox(y, fr, width4chars, h, true, true);
                this.fieldY.setClamp(-99, this.f_96541_.f_91073_.m_151558_() - 1);
                this.fieldY.setMinLength(1);
                this.fieldList.add(this.fieldY);
                this.fieldR = new TextBox("", fr, width3chars, h, true, false);
                this.fieldR.setClamp(0, 255);
                this.fieldR.m_94199_(3);
                this.fieldList.add(this.fieldR);
                this.fieldG = new TextBox("", fr, width3chars, h, true, false);
                this.fieldG.setClamp(0, 255);
                this.fieldG.m_94199_(3);
                this.fieldList.add(this.fieldG);
                this.fieldB = new TextBox("", fr, width3chars, h, true, false);
                this.fieldB.setClamp(0, 255);
                this.fieldB.m_94199_(3);
                this.fieldList.add(this.fieldB);
                Collection<String> wpDims = this.originalWaypoint.getDimensions();
                for (WorldData.DimensionProvider provider : WorldData.getDimensionProviders(WaypointStore.INSTANCE.getLoadedDimensions())) {
                    String dimName = WorldData.getSafeDimensionName(provider);
                    String dimId = provider.getDimensionId();
                    try {
                        dimName = provider.getName();
                    }
                    catch (Exception e) {
                        JMLogger.logOnce("Can't get dimension name from provider: ", e);
                    }
                    DimensionButton button2 = new DimensionButton(dimId, dimName, wpDims.contains(dimId));
                    button2.setDefaultStyle(false);
                    this.dimButtonList.add(button2);
                }
                this.dimScrollPane = new ScrollPane(this, this.f_96541_, 0, 0, this.dimButtonList, this.dimButtonList.get(0).m_93694_(), 4);
                this.dimScrollPane.m_93471_(false);
            }
            if (this.getRenderables().isEmpty()) {
                String on = Constants.getString("jm.common.on");
                String off = Constants.getString("jm.common.off");
                String enableOn = Constants.getString("jm.waypoint.enable", on);
                String enableOff = Constants.getString("jm.waypoint.enable", off);
                this.buttonRandomize = (Button)this.m_142416_((GuiEventListener)new Button(Constants.getString("jm.waypoint.randomize"), button -> this.setRandomColor()));
                this.buttonEnable = (OnOffButton)this.m_142416_((GuiEventListener)new OnOffButton(enableOn, enableOff, true, button -> this.buttonEnable.toggle()));
                this.buttonEnable.setToggled(this.originalWaypoint.isEnable());
                this.buttonRemove = (Button)this.m_142416_((GuiEventListener)new Button(Constants.getString("jm.waypoint.remove"), button -> this.remove()));
                this.buttonRemove.setEnabled(!this.isNew);
                this.buttonReset = (Button)this.m_142416_((GuiEventListener)new Button(Constants.getString("jm.waypoint.reset"), button -> this.resetForm()));
                this.buttonSave = (Button)this.m_142416_((GuiEventListener)new Button(Constants.getString("jm.waypoint.save"), button -> this.save()));
                String closeLabel = this.isNew ? "jm.waypoint.cancel" : "jm.common.close";
                this.buttonClose = (Button)this.m_142416_((GuiEventListener)new Button(Constants.getString(closeLabel), button -> this.refreshAndClose(this.originalWaypoint)));
                this.getRenderables().add((Widget)this.buttonEnable);
                this.getRenderables().add((Widget)this.buttonRandomize);
                this.getRenderables().add((Widget)this.buttonRemove);
                this.getRenderables().add((Widget)this.buttonReset);
                this.getRenderables().add((Widget)this.buttonSave);
                this.getRenderables().add((Widget)this.buttonClose);
                this.buttonEnable.setDefaultStyle(false);
                this.buttonRandomize.setDefaultStyle(false);
                this.buttonRemove.setDefaultStyle(false);
                this.buttonReset.setDefaultStyle(false);
                this.buttonSave.setDefaultStyle(false);
                this.buttonClose.setDefaultStyle(false);
                this.bottomButtons = new ButtonList(this.buttonRemove, this.buttonSave, this.buttonClose);
                this.bottomButtons.equalizeWidths(this.getFontRenderer());
                this.setFormColor(this.originalWaypoint.getIconColor());
                this.validate();
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toString(t));
            UIManager.INSTANCE.closeAll();
        }
    }

    @Override
    protected void layoutButtons(PoseStack mStack) {
        try {
            this.m_7856_();
            Font fr = this.getFontRenderer();
            int vpad = 5;
            int hgap = fr.m_92895_("X") * 3;
            int vgap = this.fieldX.m_93694_() + 5;
            int startY = Math.max(30, (this.f_96544_ - 200) / 2);
            int dcw = fr.m_92895_(this.dimensionsTitle);
            dcw = 8 + Math.max(dcw, this.dimScrollPane.getFitWidth(fr));
            int leftWidth = hgap * 2 + this.fieldX.m_5711_() + this.fieldY.m_5711_() + this.fieldZ.m_5711_();
            int rightWidth = dcw;
            int totalWidth = leftWidth + 10 + rightWidth;
            int leftX = (this.f_96543_ - totalWidth) / 2;
            int leftXEnd = leftX + leftWidth;
            int rightX = leftXEnd + 10;
            int rightXEnd = rightX + rightWidth;
            int leftRowY = startY;
            this.drawLabel(mStack, this.labelName, leftX, leftRowY);
            this.fieldName.m_93674_(leftWidth);
            this.fieldName.m_94214_(leftX);
            this.fieldName.setY(leftRowY += 12);
            this.fieldName.m_6305_(mStack, leftX, leftRowY, this.partialTicks);
            this.drawLabel(mStack, this.locationTitle, leftX, leftRowY += vgap + 5);
            this.drawLabelAndField(mStack, this.labelX, this.fieldX, leftX, leftRowY += 12);
            this.drawLabelAndField(mStack, this.labelZ, this.fieldZ, this.fieldX.getX() + this.fieldX.m_5711_() + hgap, leftRowY);
            this.drawLabelAndField(mStack, this.labelY, this.fieldY, this.fieldZ.getX() + this.fieldZ.m_5711_() + hgap, leftRowY);
            this.drawLabel(mStack, this.colorTitle, leftX, leftRowY += vgap + 5);
            this.drawLabelAndField(mStack, this.labelR, this.fieldR, leftX, leftRowY += 12);
            this.drawLabelAndField(mStack, this.labelG, this.fieldG, this.fieldR.getX() + this.fieldR.m_5711_() + hgap, leftRowY);
            this.drawLabelAndField(mStack, this.labelB, this.fieldB, this.fieldG.getX() + this.fieldG.m_5711_() + hgap, leftRowY);
            this.buttonRandomize.m_93674_(4 + Math.max(this.fieldB.getX() + this.fieldB.m_5711_() - this.fieldR.getX(), 10 + fr.m_92895_(this.buttonRandomize.m_6035_().getString())));
            this.buttonRandomize.setPosition(this.fieldR.getX() - 2, leftRowY += vgap);
            int cpY = this.fieldB.getY();
            int cpSize = this.buttonRandomize.getY() + this.buttonRandomize.m_93694_() - cpY - 2;
            int cpHAreaX = this.fieldB.getX() + this.fieldB.m_5711_();
            int cpHArea = this.fieldName.getX() + this.fieldName.m_5711_() - cpHAreaX;
            int cpX = cpHAreaX + (cpHArea - cpSize);
            this.drawColorPicker(mStack, cpX, cpY, cpSize);
            int iconX = cpHAreaX + (cpX - cpHAreaX) / 2 - this.wpTexture.getWidth() / 2 + 1;
            int iconY = this.buttonRandomize.getY() - 2;
            this.drawWaypoint(mStack, iconX, iconY);
            this.buttonEnable.fitWidth(fr);
            this.buttonEnable.m_93674_(Math.max(leftWidth / 2, this.buttonEnable.m_5711_()));
            this.buttonEnable.setPosition(leftX - 2, leftRowY += vgap);
            this.buttonReset.m_93674_(leftWidth - this.buttonEnable.m_5711_() - 2);
            this.buttonReset.setPosition(leftXEnd - this.buttonReset.m_5711_() + 2, leftRowY);
            int rightRow = startY;
            this.drawLabel(mStack, this.dimensionsTitle, rightX, rightRow);
            int scrollHeight = this.buttonReset.getY() + this.buttonReset.m_93694_() - 2 - (rightRow += 12);
            this.dimScrollPane.setDimensions(dcw, scrollHeight, 0, 0, rightX, rightRow);
            int totalRow = Math.max(leftRowY + vgap, rightRow + vgap);
            this.bottomButtons.layoutFilledHorizontal(fr, leftX - 2, totalRow, rightXEnd + 2, 4, true);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error during WaypointEditor layout: " + LogFormatter.toPartialString(t));
            UIManager.INSTANCE.closeAll();
        }
    }

    @Override
    public void m_6305_(PoseStack mStack, int x, int y, float partialTicks) {
        try {
            this.partialTicks = partialTicks;
            this.m_96558_(mStack, 0);
            super.renderBottomBar(mStack);
            this.validate();
            this.layoutButtons(mStack);
            this.dimScrollPane.m_6305_(mStack, x, y, partialTicks);
            DrawUtil.drawLabel(mStack, this.currentLocation, this.f_96543_ / 2, this.f_96544_, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, 0, 1.0f, 0xC0C0C0, 1.0f, 1.0, true);
            for (int k = 0; k < this.getRenderables().size(); ++k) {
                net.minecraft.client.gui.components.Button guibutton = (net.minecraft.client.gui.components.Button)this.getRenderables().get(k);
                guibutton.m_6305_(mStack, x, y, 0.0f);
            }
            if (this.colorPickTooltip != null && this.colorPickRect.contains(x, y)) {
                TextComponent tooltip = Constants.getStringTextComponent(this.colorPickTooltip);
                this.renderWrappedToolTip(mStack, this.getFontRenderer().m_92923_((FormattedText)tooltip, 200), x, y, this.getFontRenderer());
            }
            this.drawTitle(mStack);
            this.drawLogo(mStack);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error during WaypointEditor layout: " + LogFormatter.toPartialString(t));
            UIManager.INSTANCE.closeAll();
        }
    }

    protected void drawWaypoint(PoseStack mStack, int x, int y) {
        DrawUtil.drawColoredImage(mStack, this.wpTexture, this.currentColor, 1.0f, x, y - this.wpTexture.getHeight() / 2, 0.0);
    }

    protected void drawColorPicker(PoseStack mStack, int x, int y, float size) {
        int sizeI = (int)size;
        WaypointEditor.m_93172_((PoseStack)mStack, (int)(x - 1), (int)(y - 1), (int)(x + sizeI + 1), (int)(y + sizeI + 1), (int)-6250336);
        if (this.colorPickRect.width != (double)size) {
            Image image = this.colorPickTexture.getImage().getScaledInstance(sizeI, sizeI, 2);
            this.colorPickImg = new BufferedImage(sizeI, sizeI, 1);
            Graphics2D g = this.colorPickImg.createGraphics();
            g.drawImage(image, 0, 0, sizeI, sizeI, null);
            g.dispose();
        }
        this.colorPickRect.setRect(x, y, size, size);
        float scale = size / (float)this.colorPickTexture.getWidth();
        DrawUtil.drawImage(mStack, this.colorPickTexture, x, y, false, scale, 0.0);
    }

    protected void drawLabelAndField(PoseStack mStack, String label, TextBox field, int x, int y) {
        field.m_94214_(x);
        field.setY(y);
        Font fr = this.getFontRenderer();
        int width = fr.m_92895_(label) + 4;
        WaypointEditor.m_93236_((PoseStack)mStack, (Font)this.getFontRenderer(), (String)label, (int)(x - width), (int)(y + (field.m_93694_() - 8) / 2), (int)Color.cyan.getRGB());
        field.m_6305_(mStack, x, y, this.partialTicks);
    }

    protected void drawLabel(PoseStack mStack, String label, int x, int y) {
        WaypointEditor.m_93236_((PoseStack)mStack, (Font)this.getFontRenderer(), (String)label, (int)x, (int)y, (int)Color.cyan.getRGB());
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 256: {
                this.closeAndReturn();
                return true;
            }
            case 257: {
                this.save();
                return true;
            }
            case 258: {
                this.validate();
                this.onTab();
                return true;
            }
        }
        for (EditBox editBox : this.fieldList) {
            editBox.m_7933_(keyCode, scanCode, modifiers);
        }
        this.updateWaypointFromForm();
        this.validate();
        return true;
    }

    @Override
    public boolean m_5534_(char typedChar, int keyCode) {
        if (this.openedWithHotKey && this.isNew) {
            this.openedWithHotKey = false;
            return true;
        }
        for (EditBox editBox : this.fieldList) {
            editBox.m_5534_(typedChar, keyCode);
        }
        this.updateWaypointFromForm();
        this.validate();
        return true;
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        this.dimScrollPane.m_6348_(mouseX, mouseY, mouseButton);
        for (EditBox editBox : this.fieldList) {
            editBox.m_6348_(mouseX, mouseY, mouseButton);
        }
        return super.m_6348_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        for (EditBox editBox : this.fieldList) {
            editBox.m_7979_(mouseX, mouseY, button, mouseDX, mouseDY);
        }
        this.checkColorPicker(mouseX, mouseY);
        this.dimScrollPane.m_7979_(mouseX, mouseY, button, mouseDX, mouseDY);
        return super.m_7979_(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public boolean m_6050_(double x, double y, double scroll) {
        this.dimScrollPane.m_6050_(x, y, scroll);
        return super.m_6050_(x, y, scroll);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            for (EditBox editBox : this.fieldList) {
                editBox.m_6375_(mouseX, mouseY, mouseButton);
            }
            this.checkColorPicker(mouseX, mouseY);
            this.dimScrollPane.m_6375_(mouseX, mouseY, mouseButton);
            Button button = this.dimScrollPane.mouseClicked((int)mouseX, (int)mouseY, mouseButton);
            if (button != null) {
                this.actionPerformed(button);
            }
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    protected void checkColorPicker(double mouseX, double mouseY) {
        if (this.colorPickRect.contains(mouseX, mouseY)) {
            int x = (int)(mouseX - (double)((int)this.colorPickRect.x));
            int y = (int)(mouseY - (double)((int)this.colorPickRect.y));
            this.setFormColor(this.colorPickImg.getRGB(x, y));
        }
    }

    protected void setFormColor(Integer color) {
        this.currentColor = color;
        int[] c = RGB.ints(color);
        this.fieldR.m_94144_(Integer.toString(c[0]));
        this.fieldG.m_94144_(Integer.toString(c[1]));
        this.fieldB.m_94144_(Integer.toString(c[2]));
        this.updateWaypointFromForm();
    }

    protected void actionPerformed(net.minecraft.client.gui.components.Button guibutton) {
        if (this.dimButtonList.contains(guibutton)) {
            DimensionButton dimButton = (DimensionButton)guibutton;
            dimButton.toggle();
            this.updateWaypointFromForm();
        }
    }

    protected void setRandomColor() {
        this.editedWaypoint.setRandomColor();
        this.setFormColor(this.editedWaypoint.getIconColor());
    }

    protected void onTab() {
        boolean focusNext = false;
        boolean foundFocus = false;
        for (TextBox field : this.fieldList) {
            if (focusNext) {
                field.m_94178_(true);
                foundFocus = true;
                break;
            }
            if (!field.m_93696_()) continue;
            field.m_94178_(false);
            field.clamp();
            focusNext = true;
        }
        if (!foundFocus) {
            this.fieldList.get(0).m_94178_(true);
        }
    }

    protected boolean validate() {
        boolean valid = true;
        if (this.fieldName != null) {
            valid = this.fieldName.hasMinLength();
        }
        if (valid && this.fieldY != null) {
            valid = this.fieldY.hasMinLength();
        }
        if (this.buttonSave != null) {
            this.buttonSave.setEnabled(valid && (this.isNew || !this.originalWaypoint.equals(this.editedWaypoint)));
        }
        return valid;
    }

    protected void remove() {
        WaypointStore.INSTANCE.remove(this.originalWaypoint, true);
        this.refreshAndClose(null);
    }

    protected void save() {
        if (!this.validate()) {
            return;
        }
        this.updateWaypointFromForm();
        WaypointStore.INSTANCE.remove(this.originalWaypoint, false);
        WaypointStore.INSTANCE.save(this.editedWaypoint, this.isNew);
        this.refreshAndClose(this.editedWaypoint);
    }

    protected void resetForm() {
        this.editedWaypoint = new Waypoint(this.originalWaypoint);
        this.dimButtonList.clear();
        this.fieldList.clear();
        this.getRenderables().clear();
        this.m_7856_();
        this.validate();
    }

    protected void updateWaypointFromForm() {
        this.currentColor = RGB.toInteger(this.getSafeColorInt(this.fieldR), this.getSafeColorInt(this.fieldG), this.getSafeColorInt(this.fieldB));
        this.editedWaypoint.setColor(this.currentColor);
        this.fieldName.m_94202_(this.editedWaypoint.getSafeColor());
        ArrayList<String> dims = new ArrayList<String>();
        for (DimensionButton db : this.dimButtonList) {
            if (!db.getToggled().booleanValue()) continue;
            dims.add(db.dimension);
        }
        this.editedWaypoint.setDimensions(dims);
        this.editedWaypoint.setEnable(this.buttonEnable.getToggled());
        this.editedWaypoint.setName(this.fieldName.m_94155_());
        this.editedWaypoint.setLocation(this.getSafeCoordInt(this.fieldX), this.getSafeCoordInt(this.fieldY), this.getSafeCoordInt(this.fieldZ), DimensionHelper.getDimKeyName((Entity)this.f_96541_.f_91074_));
    }

    protected int getSafeColorInt(TextBox field) {
        field.clamp();
        String text = field.m_94155_();
        if (text == null || text.isEmpty()) {
            return 0;
        }
        int val = 0;
        try {
            val = Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Math.max(0, Math.min(255, val));
    }

    protected int getSafeCoordInt(TextBox field) {
        String text = field.m_94155_();
        if (text == null || text.isEmpty() || text.equals("-")) {
            return 0;
        }
        int val = 0;
        try {
            val = Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return val;
    }

    protected void refreshAndClose(Waypoint focusWaypoint) {
        if (returnDisplayStack != null && returnDisplayStack.peek() != null && returnDisplayStack.peek() instanceof WaypointManager) {
            ((WaypointManager)returnDisplayStack.peek()).setFocusWaypoint(focusWaypoint);
        }
        Fullscreen.state().requireRefresh();
        this.closeAndReturn();
    }

    @Override
    protected void closeAndReturn() {
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            UIManager.INSTANCE.closeAll();
        } else {
            UIManager.INSTANCE.open((Screen)returnDisplayStack.pop());
        }
    }

    class DimensionButton
    extends OnOffButton {
        public final String dimension;

        DimensionButton(String dimension, String dimensionName, boolean toggled) {
            super(String.format("%s: %s", dimensionName, Constants.getString("jm.common.on")), String.format("%s: %s", dimensionName, Constants.getString("jm.common.off")), toggled, Button.emptyPressable());
            this.dimension = dimension;
            this.setToggled(toggled);
        }
    }
}

