/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypoint;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.command.CmdTeleportWaypoint;
import journeymap.client.log.JMLogger;
import journeymap.client.properties.ClientCategory;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.OnOffButton;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.client.ui.waypoint.DimensionsDropDownButton;
import journeymap.client.ui.waypoint.SortButton;
import journeymap.client.ui.waypoint.WaypointManagerItem;
import journeymap.client.waypoint.Waypoint;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import journeymap.common.properties.catagory.Category;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class WaypointManager
extends JmUI {
    static final String ASCEND = "\u25b2";
    static final String DESCEND = "\u25bc";
    static final int COLWAYPOINT = 0;
    static final int COLLOCATION = 20;
    static final int COLNAME = 60;
    static final int DEFAULT_ITEMWIDTH = 460;
    private static WaypointManagerItem.Sort currentSort;
    private final String on = Constants.getString("jm.common.on");
    private final String off = Constants.getString("jm.common.off");
    protected int colWaypoint = 0;
    protected int colLocation = 20;
    protected int colName = 60;
    protected int itemWidth = 460;
    protected ScrollListPane itemScrollPane;
    protected int rowHeight = 16;
    Boolean canUserTeleport;
    private SortButton buttonSortName;
    private SortButton buttonSortDistance;
    private SortButton buttonSortDeviation;
    private DimensionsDropDownButton buttonDimensions;
    private Button buttonClose;
    private Button buttonAdd;
    private Button buttonOptions;
    private OnOffButton buttonToggleAll;
    private ButtonList bottomButtons;
    private Waypoint focusWaypoint;
    private ArrayList<WaypointManagerItem> items = new ArrayList();
    private static boolean toggled;

    public WaypointManager() {
        this((Waypoint)null, (JmUI)null);
    }

    public WaypointManager(JmUI returnDisplay) {
        this((Waypoint)null, returnDisplay);
    }

    public WaypointManager(Waypoint focusWaypoint, JmUI returnDisplay) {
        super(Constants.getString("jm.waypoint.manage_title"), returnDisplay);
        this.focusWaypoint = focusWaypoint;
    }

    public void setFocusWaypoint(Waypoint focusWaypoint) {
        this.focusWaypoint = focusWaypoint;
    }

    @Override
    public void m_7856_() {
        try {
            this.setRenderBottomBar(true);
            this.getRenderables().clear();
            Journeymap.getLogger().debug("Checking if tp is permitted");
            this.canUserTeleport = CmdTeleportWaypoint.isPermitted(Minecraft.m_91087_());
            Journeymap.getLogger().debug("Checked if tp button should be displayed:" + this.canUserTeleport);
            Font fr = this.getFontRenderer();
            WaypointManagerItem.DistanceComparator distanceSort = new WaypointManagerItem.DistanceComparator((Player)Minecraft.m_91087_().f_91074_, true);
            String distanceLabel = Constants.getString("jm.waypoint.distance");
            this.buttonSortDistance = new SortButton(distanceLabel, distanceSort, b -> {
                this.buttonSortDistance.toggle();
                this.updateSort(this.buttonSortDistance);
            });
            this.buttonSortDistance.setTextOnly(fr);
            this.getRenderables().add((Widget)this.buttonSortDistance);
            this.m_142416_((GuiEventListener)this.buttonSortDistance);
            WaypointManagerItem.NameComparator nameSort = new WaypointManagerItem.NameComparator(true);
            WaypointManagerItem.DeviationComparator deviationSort = new WaypointManagerItem.DeviationComparator(true);
            this.buttonSortName = new SortButton(Constants.getString("jm.waypoint.name"), nameSort, b -> {
                this.buttonSortName.toggle();
                this.updateSort(this.buttonSortName);
            });
            this.buttonSortName.setTextOnly(fr);
            this.m_142416_((GuiEventListener)this.buttonSortName);
            this.getRenderables().add((Widget)this.buttonSortName);
            this.buttonSortDeviation = new SortButton(Constants.getString("jm.waypoint.deviation_button_sort"), deviationSort, b -> {
                this.buttonSortDeviation.toggle();
                this.updateSort(this.buttonSortDeviation);
            });
            this.buttonSortDeviation.setTextOnly(fr);
            this.m_142416_((GuiEventListener)this.buttonSortDeviation);
            this.getRenderables().add((Widget)this.buttonSortDeviation);
            String enableOn = Constants.getString("jm.waypoint.enable_all", "", this.on);
            String enableOff = Constants.getString("jm.waypoint.enable_all", "", this.off);
            this.buttonToggleAll = new OnOffButton(enableOff, enableOn, true, b -> {
                boolean state = this.buttonToggleAll.getToggled();
                state = this.toggleItems(state);
                this.buttonToggleAll.setToggled(state);
            });
            this.buttonToggleAll.setTextOnly(this.getFontRenderer());
            this.m_142416_((GuiEventListener)this.buttonToggleAll);
            this.getRenderables().add((Widget)this.buttonToggleAll);
            this.buttonDimensions = new DimensionsDropDownButton(b -> this.updateItems());
            this.m_142416_((GuiEventListener)this.buttonDimensions);
            if (JourneymapClient.getInstance().getWaypointProperties().managerDimensionFocus.get().booleanValue()) {
                this.buttonDimensions.setDim((ResourceKey<Level>)this.f_96541_.f_91074_.f_19853_.m_46472_());
            }
            this.buttonAdd = (Button)this.m_142416_((GuiEventListener)new Button(Constants.getString("jm.waypoint.new"), button -> {
                Waypoint waypoint = Waypoint.of((Entity)this.f_96541_.f_91074_);
                UIManager.INSTANCE.openWaypointEditor(waypoint, true, this);
            }));
            this.buttonAdd.fitWidth(this.getFontRenderer());
            this.buttonAdd.m_93674_(this.buttonAdd.m_5711_() * 2);
            this.buttonOptions = (Button)this.m_142416_((GuiEventListener)new Button(Constants.getString("jm.common.options_button"), button -> UIManager.INSTANCE.openOptionsManager(this, ClientCategory.Waypoint, ClientCategory.WaypointBeacon)));
            this.buttonOptions.fitWidth(this.getFontRenderer());
            this.buttonClose = (Button)this.m_142416_((GuiEventListener)new Button(Constants.getString("jm.common.close"), button -> this.refreshAndClose()));
            this.bottomButtons = new ButtonList(this.buttonOptions, this.buttonAdd, this.buttonDimensions, this.buttonClose);
            this.buttonOptions.setDefaultStyle(false);
            this.buttonAdd.setDefaultStyle(false);
            this.buttonDimensions.setDefaultStyle(false);
            this.buttonClose.setDefaultStyle(false);
            this.getRenderables().addAll(this.bottomButtons);
            if (this.items.isEmpty()) {
                this.updateItems();
                if (currentSort == null) {
                    this.updateSort(this.buttonSortDistance);
                } else {
                    if (this.buttonSortDistance.sort.equals(currentSort)) {
                        this.buttonSortDistance.sort.ascending = WaypointManager.currentSort.ascending;
                        this.buttonSortDistance.setActive(true);
                        this.buttonSortName.setActive(false);
                        this.buttonSortDeviation.setActive(false);
                    }
                    if (this.buttonSortName.sort.equals(currentSort)) {
                        this.buttonSortName.sort.ascending = WaypointManager.currentSort.ascending;
                        this.buttonSortName.setActive(true);
                        this.buttonSortDistance.setActive(false);
                        this.buttonSortDeviation.setActive(false);
                    }
                    if (this.buttonSortDeviation.sort.equals(currentSort)) {
                        this.buttonSortDeviation.sort.ascending = WaypointManager.currentSort.ascending;
                        this.buttonSortDeviation.setActive(true);
                        this.buttonSortName.setActive(false);
                        this.buttonSortDistance.setActive(false);
                    }
                }
            }
            if (this.itemScrollPane == null) {
                this.itemScrollPane = new ScrollListPane(this, this.f_96541_, this.f_96543_, this.f_96544_, 35, this.f_96544_ - 30, 20);
                this.itemScrollPane.m_93496_(false);
            } else {
                this.itemScrollPane.m_93437_(this.f_96543_, this.f_96544_, 35, this.f_96544_ - 30);
                this.itemScrollPane.updateSlots();
            }
            this.itemScrollPane.setSlots(this.items);
            if (!this.items.isEmpty()) {
                this.itemScrollPane.scrollTo(this.items.get(0));
            }
        }
        catch (Throwable t) {
            JMLogger.logOnce("Error in OptionsManager.init(): " + t, t);
        }
    }

    @Override
    protected void layoutButtons(PoseStack mStack) {
        if (this.getRenderables().isEmpty() || this.itemScrollPane == null) {
            this.m_7856_();
        }
        this.buttonToggleAll.setDrawButton(!this.items.isEmpty());
        this.buttonSortDistance.setDrawButton(!this.items.isEmpty());
        this.buttonSortName.setDrawButton(!this.items.isEmpty());
        this.buttonSortDeviation.setDrawButton(!this.items.isEmpty() && JourneymapClient.getInstance().getWaypointProperties().showDeviationLabel.get() != false);
        this.bottomButtons.equalizeWidths(this.getFontRenderer());
        int bottomButtonWidth = Math.min(this.bottomButtons.getWidth(4) + 25, this.itemScrollPane.m_5759_());
        this.bottomButtons.equalizeWidths(this.getFontRenderer(), 4, bottomButtonWidth);
        this.bottomButtons.layoutCenteredHorizontal(this.f_96543_ / 2, this.f_96544_ - 25, true, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void m_6305_(PoseStack mStack, int x, int y, float par3) {
        if (this.f_96541_ == null) {
            return;
        }
        if (this.getRenderables().isEmpty() || this.itemScrollPane == null) {
            this.m_7856_();
        }
        if (currentSort != null) {
            Collections.sort(this.items, currentSort);
        }
        if (this.itemScrollPane != null) {
            this.itemScrollPane.setSlots(this.items);
        }
        try {
            mStack.m_85836_();
            this.itemScrollPane.m_93437_(this.f_96543_, this.f_96544_, 35, this.f_96544_ - 30);
            List<FormattedCharSequence> lastTooltip = this.itemScrollPane.lastTooltip;
            long lastTooltipTime = this.itemScrollPane.lastTooltipTime;
            this.itemScrollPane.lastTooltip = null;
            this.itemScrollPane.m_6305_(mStack, x, y, par3);
            super.m_6305_(mStack, x, y, par3);
            if (!this.items.isEmpty()) {
                Objects.requireNonNull(this.getFontRenderer());
                int headerY = 35 - 9;
                WaypointManagerItem firstRow = this.items.get(0);
                if (firstRow.y > headerY + 16) {
                    headerY = firstRow.y - 16;
                }
                this.buttonToggleAll.centerHorizontalOn(firstRow.getButtonEnableCenterX()).setY(headerY);
                this.buttonSortDistance.centerHorizontalOn(firstRow.getLocationLeftX()).setY(headerY);
                this.colName = this.buttonSortDistance.getRightX() + 20;
                this.buttonSortName.setPosition(this.colName - 5, headerY);
                this.buttonSortDeviation.centerHorizontalOn(firstRow.getButtonDeviationX()).setY(headerY);
            }
            this.buttonToggleAll.drawUnderline(mStack);
            for (List<SlotMetadata> toolbar : this.getToolbars().values()) {
                for (SlotMetadata slotMetadata : toolbar) {
                    slotMetadata.getButton().secondaryDrawButton();
                }
            }
            if (this.itemScrollPane.lastTooltip != null && this.itemScrollPane.lastTooltip.equals(lastTooltip)) {
                this.itemScrollPane.lastTooltipTime = lastTooltipTime;
                if (System.currentTimeMillis() - this.itemScrollPane.lastTooltipTime > this.itemScrollPane.hoverDelay) {
                    Button button = this.itemScrollPane.lastTooltipMetadata.getButton();
                    this.m_96617_(mStack, this.itemScrollPane.lastTooltip, x, button.getBottomY() + 15);
                }
            }
        }
        catch (Throwable t) {
            JMLogger.logOnce("Error in OptionsManager.render(): " + t, t);
        }
        finally {
            mStack.m_85849_();
        }
    }

    @Override
    public void m_7333_(PoseStack mStack) {
    }

    public void m_96558_(PoseStack mStack, int tint) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        boolean pressed;
        if (mouseButton == 0 && (pressed = this.itemScrollPane.m_6375_(mouseX, mouseY, mouseButton))) {
            this.checkPressedButton();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        this.itemScrollPane.m_6348_(mouseX, mouseY, mouseButton);
        return super.m_6348_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        this.checkPressedButton();
        this.itemScrollPane.m_7979_(mouseX, mouseY, button, mouseDX, mouseDY);
        return super.m_7979_(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public boolean m_6050_(double x, double y, double scroll) {
        if (this.itemScrollPane.m_6050_(x, y, scroll)) {
            return true;
        }
        return super.m_6050_(x, y, scroll);
    }

    protected void checkPressedButton() {
        CategorySlot parentSlot;
        SlotMetadata slotMetadata = this.itemScrollPane.getLastPressed();
        if (slotMetadata != null) {
            // empty if block
        }
        if ((parentSlot = (CategorySlot)this.itemScrollPane.getLastPressedParentSlot()) != null) {
            // empty if block
        }
    }

    @Override
    public boolean m_5534_(char typedChar, int keyCode) {
        switch (keyCode) {
            case 256: {
                this.closeAndReturn();
            }
        }
        boolean keyUsed = this.itemScrollPane.m_5534_(typedChar, keyCode);
        if (keyUsed) {
            return true;
        }
        if (keyCode == 265) {
            this.itemScrollPane.m_93429_(-this.rowHeight);
            return true;
        }
        if (keyCode == 264) {
            this.itemScrollPane.m_93429_(this.rowHeight);
            return true;
        }
        if (keyCode == 266) {
            this.itemScrollPane.m_93429_(-this.itemScrollPane.getHeight());
            return true;
        }
        if (keyCode == 267) {
            this.itemScrollPane.m_93429_(this.itemScrollPane.getHeight());
            return true;
        }
        if (keyCode == 268) {
            this.itemScrollPane.m_93429_((int)(-this.itemScrollPane.m_93517_()));
            return true;
        }
        if (keyCode == 269) {
            this.itemScrollPane.m_93429_((int)this.itemScrollPane.m_93517_());
            return true;
        }
        return true;
    }

    protected boolean toggleItems(boolean enable) {
        for (WaypointManagerItem item : this.items) {
            if (enable != item.waypoint.isEnable()) continue;
            enable = !enable;
            break;
        }
        for (WaypointManagerItem item : this.items) {
            if (item.waypoint.isEnable() == enable) continue;
            item.enableWaypoint(enable);
        }
        return !enable;
    }

    public static void toggleAllWaypoints() {
        toggled = !toggled;
        Collection<Waypoint> waypoints = WaypointStore.INSTANCE.getAll();
        for (Waypoint waypoint : waypoints) {
            waypoint.setEnable(toggled);
            waypoint.setDirty();
        }
    }

    protected void updateItems() {
        this.items.clear();
        String currentDim = DimensionsDropDownButton.currentWorldProvider == null ? null : DimensionsDropDownButton.currentWorldProvider.getDimensionId();
        Font fr = this.getFontRenderer();
        Collection<Waypoint> waypoints = WaypointStore.INSTANCE.getAll();
        boolean allOn = true;
        this.itemWidth = 0;
        for (Waypoint waypoint : waypoints) {
            WaypointManagerItem item = new WaypointManagerItem(waypoint, fr, this);
            this.itemWidth = Math.max(item.internalWidth, this.itemWidth);
            item.getDistanceTo((Player)this.f_96541_.f_91074_);
            if (currentDim != null && !item.waypoint.getDimensions().contains(currentDim)) continue;
            this.items.add(item);
            if (!allOn) continue;
            allOn = waypoint.isEnable();
        }
        if (this.items.isEmpty()) {
            this.itemWidth = 460;
        }
        this.buttonToggleAll.setToggled(!allOn);
        this.updateCount();
    }

    protected void updateSort(SortButton sortButton) {
        for (Widget button : this.getRenderables()) {
            if (!(button instanceof SortButton)) continue;
            if (button == sortButton) {
                if (!sortButton.sort.equals(currentSort)) {
                    sortButton.setActive(true);
                }
                currentSort = sortButton.sort;
                continue;
            }
            ((SortButton)button).setActive(false);
        }
    }

    protected void updateCount() {
        String itemCount = this.items.isEmpty() ? "" : Integer.toString(this.items.size());
        String enableOn = Constants.getString("jm.waypoint.enable_all", itemCount, this.on);
        String enableOff = Constants.getString("jm.waypoint.enable_all", itemCount, this.off);
        this.buttonToggleAll.setLabels(enableOff, enableOn);
    }

    protected boolean isSelected(WaypointManagerItem item) {
        return this.itemScrollPane.m_7987_(item.getSlotIndex());
    }

    protected int getMargin() {
        return this.f_96543_ > this.itemWidth + 2 ? (this.f_96543_ - this.itemWidth) / 2 : 0;
    }

    public void removeWaypoint(WaypointManagerItem item) {
        WaypointStore.INSTANCE.remove(item.waypoint, true);
        this.items.remove((Object)item);
        this.updateItems();
    }

    protected void refreshAndClose() {
        this.closeAndReturn();
    }

    @Override
    protected void closeAndReturn() {
        this.bottomButtons.setEnabled(false);
        WaypointStore.INSTANCE.bulkSave();
        Fullscreen.state().requireRefresh();
        this.bottomButtons.setEnabled(true);
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            UIManager.INSTANCE.closeAll();
        } else {
            UIManager.INSTANCE.open((Screen)returnDisplayStack.pop());
        }
    }

    Map<Category, List<SlotMetadata>> getToolbars() {
        return Collections.EMPTY_MAP;
    }

    static {
        toggled = true;
    }
}

