/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import journeymap.common.network.data.PacketContext;
import journeymap.common.network.data.Side;
import journeymap.common.network.data.model.ClientState;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ClientPermissionsPacket
implements ClientState {
    public static final ResourceLocation CHANNEL = new ResourceLocation("journeymap", "perm_req");
    private String payload;
    private boolean serverAdmin;

    public ClientPermissionsPacket() {
        this.payload = "";
    }

    public ClientPermissionsPacket(String payload, boolean serverAdmin) {
        this.payload = payload;
        this.serverAdmin = serverAdmin;
    }

    @Override
    public String getPayload() {
        return this.payload;
    }

    @Override
    public boolean isServerAdmin() {
        return this.serverAdmin;
    }

    public static ClientPermissionsPacket decode(FriendlyByteBuf buf) {
        ClientPermissionsPacket packet = new ClientPermissionsPacket();
        try {
            if (buf.readableBytes() > 1) {
                buf.readByte();
                packet.serverAdmin = buf.readBoolean();
                packet.payload = buf.m_130136_(Short.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for client permissions: %s", t));
        }
        return packet;
    }

    public void encode(FriendlyByteBuf buf) {
        try {
            if (this.payload != null) {
                buf.writeByte(42);
                buf.writeBoolean(this.serverAdmin);
                buf.m_130070_(this.payload);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for client permissions:" + t);
        }
    }

    public static void handle(PacketContext<ClientPermissionsPacket> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            Journeymap.getInstance().getPacketHandler().onClientPermsRequest(ctx.sender());
        } else {
            JourneymapClient.getInstance().getPacketHandler().onClientStateUpdate(ctx.message());
        }
    }
}

