/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.command.modules;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.command.Arguments;
import me.lucko.spark.common.command.Command;
import me.lucko.spark.common.command.CommandModule;
import me.lucko.spark.common.command.CommandResponseHandler;
import me.lucko.spark.common.command.sender.CommandSender;
import me.lucko.spark.common.command.tabcomplete.TabCompleter;
import me.lucko.spark.common.monitor.cpu.CpuMonitor;
import me.lucko.spark.common.monitor.disk.DiskUsage;
import me.lucko.spark.common.monitor.ping.PingStatistics;
import me.lucko.spark.common.monitor.ping.PingSummary;
import me.lucko.spark.common.monitor.tick.TickStatistics;
import me.lucko.spark.common.util.FormatUtil;
import me.lucko.spark.common.util.RollingAverage;
import me.lucko.spark.common.util.StatisticFormatter;
import me.lucko.spark.lib.adventure.text.Component;
import me.lucko.spark.lib.adventure.text.TextComponent;
import me.lucko.spark.lib.adventure.text.format.NamedTextColor;
import me.lucko.spark.lib.adventure.text.format.TextColor;
import me.lucko.spark.lib.adventure.text.format.TextDecoration;

public class HealthModule
implements CommandModule {
    @Override
    public void registerCommands(Consumer<Command> consumer) {
        consumer.accept(Command.builder().aliases("tps", "cpu").executor(HealthModule::tps).tabCompleter(Command.TabCompleter.empty()).build());
        consumer.accept(Command.builder().aliases("ping").argumentUsage("player", "username").executor(HealthModule::ping).tabCompleter((platform, sender, arguments) -> TabCompleter.completeForOpts(arguments, "--player")).build());
        consumer.accept(Command.builder().aliases("healthreport", "health", "ht").argumentUsage("memory", null).executor(HealthModule::healthReport).tabCompleter((platform, sender, arguments) -> TabCompleter.completeForOpts(arguments, "--memory")).build());
    }

    private static void tps(SparkPlatform platform, CommandSender sender, CommandResponseHandler resp, Arguments arguments) {
        TickStatistics tickStatistics = platform.getTickStatistics();
        if (tickStatistics != null) {
            resp.replyPrefixed(Component.text("TPS from last 5s, 10s, 1m, 5m, 15m:"));
            resp.replyPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(" ").append((Component)StatisticFormatter.formatTps(tickStatistics.tps5Sec()))).append((Component)Component.text(", "))).append((Component)StatisticFormatter.formatTps(tickStatistics.tps10Sec()))).append((Component)Component.text(", "))).append((Component)StatisticFormatter.formatTps(tickStatistics.tps1Min()))).append((Component)Component.text(", "))).append((Component)StatisticFormatter.formatTps(tickStatistics.tps5Min()))).append((Component)Component.text(", "))).append((Component)StatisticFormatter.formatTps(tickStatistics.tps15Min()))).build());
            resp.replyPrefixed(Component.empty());
            if (tickStatistics.isDurationSupported()) {
                resp.replyPrefixed(Component.text("Tick durations (min/med/95%ile/max ms) from last 10s, 1m:"));
                resp.replyPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(" ").append((Component)StatisticFormatter.formatTickDurations(tickStatistics.duration10Sec()))).append((Component)Component.text(";  "))).append((Component)StatisticFormatter.formatTickDurations(tickStatistics.duration1Min()))).build());
                resp.replyPrefixed(Component.empty());
            }
        }
        resp.replyPrefixed(Component.text("CPU usage from last 10s, 1m, 15m:"));
        resp.replyPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(" ").append((Component)StatisticFormatter.formatCpuUsage(CpuMonitor.systemLoad10SecAvg()))).append((Component)Component.text(", "))).append((Component)StatisticFormatter.formatCpuUsage(CpuMonitor.systemLoad1MinAvg()))).append((Component)Component.text(", "))).append((Component)StatisticFormatter.formatCpuUsage(CpuMonitor.systemLoad15MinAvg()))).append((Component)Component.text("  (system)", (TextColor)NamedTextColor.DARK_GRAY))).build());
        resp.replyPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(" ").append((Component)StatisticFormatter.formatCpuUsage(CpuMonitor.processLoad10SecAvg()))).append((Component)Component.text(", "))).append((Component)StatisticFormatter.formatCpuUsage(CpuMonitor.processLoad1MinAvg()))).append((Component)Component.text(", "))).append((Component)StatisticFormatter.formatCpuUsage(CpuMonitor.processLoad15MinAvg()))).append((Component)Component.text("  (process)", (TextColor)NamedTextColor.DARK_GRAY))).build());
    }

    private static void ping(SparkPlatform platform, CommandSender sender, CommandResponseHandler resp, Arguments arguments) {
        PingStatistics pingStatistics = platform.getPingStatistics();
        if (pingStatistics == null) {
            resp.replyPrefixed(Component.text("Ping data is not available on this platform."));
            return;
        }
        Set<String> players = arguments.stringFlag("player");
        if (!players.isEmpty()) {
            for (String player : players) {
                PingStatistics.PlayerPing playerPing = pingStatistics.query(player);
                if (playerPing == null) {
                    resp.replyPrefixed(Component.text("Ping data is not available for '" + player + "'."));
                    continue;
                }
                resp.replyPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("Player ").append((Component)Component.text(playerPing.name(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text(" has "))).append((Component)StatisticFormatter.formatPingRtt(playerPing.ping()))).append((Component)Component.text(" ms ping."))).build());
            }
            return;
        }
        PingSummary summary = pingStatistics.currentSummary();
        RollingAverage average = pingStatistics.getPingAverage();
        if (summary.total() == 0 && average.getSamples() == 0) {
            resp.replyPrefixed(Component.text("There is not enough data to show ping averages yet. Please try again later."));
            return;
        }
        resp.replyPrefixed(Component.text("Average Pings (min/med/95%ile/max ms) from now, last 15m:"));
        resp.replyPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(" ").append((Component)StatisticFormatter.formatPingRtts(summary.min(), summary.median(), summary.percentile95th(), summary.max()))).append((Component)Component.text(";  "))).append((Component)StatisticFormatter.formatPingRtts(average.min(), average.median(), average.percentile95th(), average.max()))).build());
    }

    private static void healthReport(SparkPlatform platform, CommandSender sender, CommandResponseHandler resp, Arguments arguments) {
        resp.replyPrefixed(Component.text("Generating server health report..."));
        LinkedList<Component> report = new LinkedList<Component>();
        report.add(Component.empty());
        TickStatistics tickStatistics = platform.getTickStatistics();
        if (tickStatistics != null) {
            HealthModule.addTickStats(report, tickStatistics);
        }
        HealthModule.addCpuStats(report);
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        HealthModule.addBasicMemoryStats(report, memoryMXBean);
        if (arguments.boolFlag("memory")) {
            HealthModule.addDetailedMemoryStats(report, memoryMXBean);
        }
        HealthModule.addDiskStats(report);
        resp.reply(report);
    }

    private static void addTickStats(List<Component> report, TickStatistics tickStatistics) {
        report.add((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(">", (TextColor)NamedTextColor.DARK_GRAY, TextDecoration.BOLD))).append((Component)Component.space())).append((Component)Component.text("TPS from last 5s, 10s, 1m, 5m, 15m:", (TextColor)NamedTextColor.GOLD))).build());
        report.add((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("    ").append((Component)StatisticFormatter.formatTps(tickStatistics.tps5Sec()))).append((Component)Component.text(", "))).append((Component)StatisticFormatter.formatTps(tickStatistics.tps10Sec()))).append((Component)Component.text(", "))).append((Component)StatisticFormatter.formatTps(tickStatistics.tps1Min()))).append((Component)Component.text(", "))).append((Component)StatisticFormatter.formatTps(tickStatistics.tps5Min()))).append((Component)Component.text(", "))).append((Component)StatisticFormatter.formatTps(tickStatistics.tps15Min()))).build());
        report.add(Component.empty());
        if (tickStatistics.isDurationSupported()) {
            report.add((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(">", (TextColor)NamedTextColor.DARK_GRAY, TextDecoration.BOLD))).append((Component)Component.space())).append((Component)Component.text("Tick durations (min/med/95%ile/max ms) from last 10s, 1m:", (TextColor)NamedTextColor.GOLD))).build());
            report.add((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("    ").append((Component)StatisticFormatter.formatTickDurations(tickStatistics.duration10Sec()))).append((Component)Component.text("; "))).append((Component)StatisticFormatter.formatTickDurations(tickStatistics.duration1Min()))).build());
            report.add(Component.empty());
        }
    }

    private static void addCpuStats(List<Component> report) {
        report.add((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(">", (TextColor)NamedTextColor.DARK_GRAY, TextDecoration.BOLD))).append((Component)Component.space())).append((Component)Component.text("CPU usage from last 10s, 1m, 15m:", (TextColor)NamedTextColor.GOLD))).build());
        report.add((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("    ").append((Component)StatisticFormatter.formatCpuUsage(CpuMonitor.systemLoad10SecAvg()))).append((Component)Component.text(", "))).append((Component)StatisticFormatter.formatCpuUsage(CpuMonitor.systemLoad1MinAvg()))).append((Component)Component.text(", "))).append((Component)StatisticFormatter.formatCpuUsage(CpuMonitor.systemLoad15MinAvg()))).append((Component)Component.text("  (system)", (TextColor)NamedTextColor.DARK_GRAY))).build());
        report.add((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("    ").append((Component)StatisticFormatter.formatCpuUsage(CpuMonitor.processLoad10SecAvg()))).append((Component)Component.text(", "))).append((Component)StatisticFormatter.formatCpuUsage(CpuMonitor.processLoad1MinAvg()))).append((Component)Component.text(", "))).append((Component)StatisticFormatter.formatCpuUsage(CpuMonitor.processLoad15MinAvg()))).append((Component)Component.text("  (process)", (TextColor)NamedTextColor.DARK_GRAY))).build());
        report.add(Component.empty());
    }

    private static void addBasicMemoryStats(List<Component> report, MemoryMXBean memoryMXBean) {
        MemoryUsage heapUsage = memoryMXBean.getHeapMemoryUsage();
        report.add((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(">", (TextColor)NamedTextColor.DARK_GRAY, TextDecoration.BOLD))).append((Component)Component.space())).append((Component)Component.text("Memory usage:", (TextColor)NamedTextColor.GOLD))).build());
        report.add((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("    ").append((Component)Component.text(FormatUtil.formatBytes(heapUsage.getUsed()), (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append((Component)Component.text("/", (TextColor)NamedTextColor.GRAY))).append((Component)Component.space())).append((Component)Component.text(FormatUtil.formatBytes(heapUsage.getMax()), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text("   "))).append((Component)Component.text("(", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text(FormatUtil.percent(heapUsage.getUsed(), heapUsage.getMax()), (TextColor)NamedTextColor.GREEN))).append((Component)Component.text(")", (TextColor)NamedTextColor.GRAY))).build());
        report.add((Component)((TextComponent.Builder)Component.text().content("    ").append((Component)StatisticFormatter.generateMemoryUsageDiagram(heapUsage, 60))).build());
        report.add(Component.empty());
    }

    private static void addDetailedMemoryStats(List<Component> report, MemoryMXBean memoryMXBean) {
        MemoryUsage nonHeapUsage = memoryMXBean.getNonHeapMemoryUsage();
        report.add((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(">", (TextColor)NamedTextColor.DARK_GRAY, TextDecoration.BOLD))).append((Component)Component.space())).append((Component)Component.text("Non-heap memory usage:", (TextColor)NamedTextColor.GOLD))).build());
        report.add((Component)((TextComponent.Builder)Component.text().content("    ").append((Component)Component.text(FormatUtil.formatBytes(nonHeapUsage.getUsed()), (TextColor)NamedTextColor.WHITE))).build());
        report.add(Component.empty());
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean memoryPool : memoryPoolMXBeans) {
            if (memoryPool.getType() != MemoryType.HEAP) continue;
            MemoryUsage usage = memoryPool.getUsage();
            MemoryUsage collectionUsage = memoryPool.getCollectionUsage();
            if (usage.getMax() == -1L) {
                usage = new MemoryUsage(usage.getInit(), usage.getUsed(), usage.getCommitted(), usage.getCommitted());
            }
            report.add((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(">", (TextColor)NamedTextColor.DARK_GRAY, TextDecoration.BOLD))).append((Component)Component.space())).append((Component)Component.text(memoryPool.getName() + " pool usage:", (TextColor)NamedTextColor.GOLD))).build());
            report.add((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("    ").append((Component)Component.text(FormatUtil.formatBytes(usage.getUsed()), (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append((Component)Component.text("/", (TextColor)NamedTextColor.GRAY))).append((Component)Component.space())).append((Component)Component.text(FormatUtil.formatBytes(usage.getMax()), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text("   "))).append((Component)Component.text("(", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text(FormatUtil.percent(usage.getUsed(), usage.getMax()), (TextColor)NamedTextColor.GREEN))).append((Component)Component.text(")", (TextColor)NamedTextColor.GRAY))).build());
            report.add((Component)((TextComponent.Builder)Component.text().content("    ").append((Component)StatisticFormatter.generateMemoryPoolDiagram(usage, collectionUsage, 60))).build());
            if (collectionUsage != null) {
                report.add((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("     ").append((Component)Component.text("-", (TextColor)NamedTextColor.RED))).append((Component)Component.space())).append((Component)Component.text("Usage at last GC:", (TextColor)NamedTextColor.GRAY))).append((Component)Component.space())).append((Component)Component.text(FormatUtil.formatBytes(collectionUsage.getUsed()), (TextColor)NamedTextColor.WHITE))).build());
            }
            report.add(Component.empty());
        }
    }

    private static void addDiskStats(List<Component> report) {
        long total = DiskUsage.getTotal();
        long used = DiskUsage.getUsed();
        if (total == 0L || used == 0L) {
            return;
        }
        report.add((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(">", (TextColor)NamedTextColor.DARK_GRAY, TextDecoration.BOLD))).append((Component)Component.space())).append((Component)Component.text("Disk usage:", (TextColor)NamedTextColor.GOLD))).build());
        report.add((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("    ").append((Component)Component.text(FormatUtil.formatBytes(used), (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append((Component)Component.text("/", (TextColor)NamedTextColor.GRAY))).append((Component)Component.space())).append((Component)Component.text(FormatUtil.formatBytes(total), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text("   "))).append((Component)Component.text("(", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text(FormatUtil.percent(used, total), (TextColor)NamedTextColor.GREEN))).append((Component)Component.text(")", (TextColor)NamedTextColor.GRAY))).build());
        report.add((Component)((TextComponent.Builder)Component.text().content("    ").append((Component)StatisticFormatter.generateDiskUsageDiagram(used, total, 60))).build());
        report.add(Component.empty());
    }
}

