/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.forge.plugin;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.lucko.spark.common.command.Command;
import me.lucko.spark.common.monitor.ping.PlayerPingProvider;
import me.lucko.spark.common.platform.PlatformInfo;
import me.lucko.spark.common.tick.TickHook;
import me.lucko.spark.common.tick.TickReporter;
import me.lucko.spark.forge.ForgeCommandSender;
import me.lucko.spark.forge.ForgePlatformInfo;
import me.lucko.spark.forge.ForgePlayerPingProvider;
import me.lucko.spark.forge.ForgeSparkMod;
import me.lucko.spark.forge.ForgeTickHook;
import me.lucko.spark.forge.ForgeTickReporter;
import me.lucko.spark.forge.plugin.ForgeSparkPlugin;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.events.PermissionGatherEvent;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContextKey;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import net.minecraftforge.server.permission.nodes.PermissionTypes;

public class ForgeServerSparkPlugin
extends ForgeSparkPlugin
implements com.mojang.brigadier.Command<CommandSourceStack>,
SuggestionProvider<CommandSourceStack> {
    private final MinecraftServer server;
    private Map<String, PermissionNode<Boolean>> registeredPermissions = Collections.emptyMap();

    public static void register(ForgeSparkMod mod, ServerAboutToStartEvent event) {
        ForgeServerSparkPlugin plugin = new ForgeServerSparkPlugin(mod, event.getServer());
        plugin.enable();
    }

    public ForgeServerSparkPlugin(ForgeSparkMod mod, MinecraftServer server) {
        super(mod);
        this.server = server;
    }

    @Override
    public void enable() {
        super.enable();
        this.registerCommands((CommandDispatcher<CommandSourceStack>)this.server.m_129892_().m_82094_());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void disable() {
        super.disable();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @SubscribeEvent
    public void onDisable(ServerStoppingEvent event) {
        if (event.getServer() == this.server) {
            this.disable();
        }
    }

    @SubscribeEvent
    public void onPermissionGather(PermissionGatherEvent.Nodes e) {
        PermissionNode.PermissionResolver defaultValue = (player, playerUUID, context) -> player != null && player.m_20310_(4);
        List permissions = this.platform.getCommands().stream().map(Command::primaryAlias).collect(Collectors.toList());
        permissions.add("all");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String permission : permissions) {
            PermissionNode node = new PermissionNode("spark", permission, PermissionTypes.BOOLEAN, defaultValue, new PermissionDynamicContextKey[0]);
            e.addNodes(new PermissionNode[]{node});
            builder.put((Object)("spark." + permission), (Object)node);
        }
        this.registeredPermissions = builder.build();
    }

    @SubscribeEvent
    public void onCommandRegister(RegisterCommandsEvent e) {
        this.registerCommands((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }

    private void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        ForgeServerSparkPlugin.registerCommands(dispatcher, this, this, "spark");
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String[] args = ForgeServerSparkPlugin.processArgs(context, false);
        if (args == null) {
            return 0;
        }
        this.threadDumper.ensureSetup();
        this.platform.executeCommand(new ForgeCommandSender(((CommandSourceStack)context.getSource()).f_81288_, this), args);
        return 1;
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        String[] args = ForgeServerSparkPlugin.processArgs(context, true);
        if (args == null) {
            return Suggestions.empty();
        }
        return this.generateSuggestions(new ForgeCommandSender((CommandSource)((CommandSourceStack)context.getSource()).m_81375_(), this), args, builder);
    }

    private static String[] processArgs(CommandContext<CommandSourceStack> context, boolean tabComplete) {
        String[] split = context.getInput().split(" ", tabComplete ? -1 : 0);
        if (split.length == 0 || !split[0].equals("/spark") && !split[0].equals("spark")) {
            return null;
        }
        return Arrays.copyOfRange(split, 1, split.length);
    }

    @Override
    public boolean hasPermission(CommandSource sender, String permission) {
        if (sender instanceof ServerPlayer) {
            PermissionNode<Boolean> permissionNode;
            if (permission.equals("spark")) {
                permission = "spark.all";
            }
            if ((permissionNode = this.registeredPermissions.get(permission)) == null) {
                throw new IllegalStateException("spark permission not registered: " + permission);
            }
            return (Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)sender), permissionNode, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
        }
        return true;
    }

    public Stream<ForgeCommandSender> getCommandSenders() {
        return Stream.concat(this.server.m_6846_().m_11314_().stream(), Stream.of(this.server)).map(sender -> new ForgeCommandSender((CommandSource)sender, this));
    }

    @Override
    public TickHook createTickHook() {
        return new ForgeTickHook(TickEvent.Type.SERVER);
    }

    @Override
    public TickReporter createTickReporter() {
        return new ForgeTickReporter(TickEvent.Type.SERVER);
    }

    @Override
    public PlayerPingProvider createPlayerPingProvider() {
        return new ForgePlayerPingProvider(this.server);
    }

    @Override
    public PlatformInfo getPlatformInfo() {
        return new ForgePlatformInfo(PlatformInfo.Type.SERVER);
    }

    @Override
    public String getCommandName() {
        return "spark";
    }
}

