/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.wire;

import alternate.current.wire.WireNode;
import java.util.AbstractQueue;
import java.util.Iterator;

public class PowerQueue
extends AbstractQueue<WireNode> {
    private WireNode head;
    private WireNode tail;
    private WireNode[] tails;
    private int offset;
    private int size;

    public PowerQueue() {
        this.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean offer(WireNode wire) {
        if (wire == null) {
            throw new NullPointerException();
        }
        int power = wire.nextPower();
        if (this.contains(wire)) {
            if (power == wire.power) return false;
            this.move(wire, power);
            return true;
        } else {
            this.insert(wire, power);
        }
        return true;
    }

    @Override
    public WireNode poll() {
        if (this.head == null) {
            return null;
        }
        WireNode wire = this.head;
        this.head = this.head.next;
        if (this.head == null) {
            this.clear();
        } else {
            this.head.prev = null;
            if (wire.power != this.head.power) {
                this.tails[wire.power + this.offset] = null;
            }
            --this.size;
        }
        return wire;
    }

    @Override
    public WireNode peek() {
        return this.head;
    }

    @Override
    public void clear() {
        WireNode wire = this.head;
        while (wire != null) {
            WireNode w = wire;
            wire = wire.next;
            w.prev = null;
            w.next = null;
        }
        this.head = null;
        this.tail = null;
        this.tails = new WireNode[0];
        this.offset = 0;
        this.size = 0;
    }

    @Override
    public Iterator<WireNode> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size;
    }

    public boolean contains(WireNode wire) {
        return wire.next != null || wire == this.tail;
    }

    private void move(WireNode wire, int power) {
        if (wire == this.tail || wire.power != wire.next.power) {
            this.tails[wire.power + this.offset] = wire == this.head || wire.prev.power != wire.power ? null : wire.prev;
        }
        --this.size;
        this.unlink(wire);
        this.insert(wire, power);
    }

    private void unlink(WireNode wire) {
        if (wire == this.head) {
            this.head = this.head.next;
        } else {
            wire.prev.next = wire.next;
        }
        if (wire == this.tail) {
            this.tail = this.tail.prev;
        } else {
            wire.next.prev = wire.prev;
        }
        wire.prev = null;
        wire.next = null;
    }

    private void insert(WireNode wire, int power) {
        wire.power = power;
        this.index(wire);
        this.link(wire);
        ++this.size;
        int index = wire.power + this.offset;
        this.tails[index] = wire;
    }

    private void index(WireNode wire) {
        int size = wire.power + this.offset + 1;
        int move = -wire.type.minPower - this.offset;
        if (size < this.tails.length) {
            size = this.tails.length;
        }
        if (move < 0) {
            move = 0;
        }
        if ((size += move) > this.tails.length) {
            this.resize(size, move);
        }
    }

    private void resize(int size, int move) {
        WireNode[] array = this.tails;
        this.tails = new WireNode[size];
        for (int i = 0; i < array.length; ++i) {
            this.tails[i + move] = array[i];
        }
        this.offset += move;
    }

    private void link(WireNode wire) {
        if (this.head == null) {
            this.linkFirst(wire);
        } else if (wire.power > this.head.power) {
            this.linkHead(wire);
        } else if (wire.power <= this.tail.power) {
            this.linkTail(wire);
        } else {
            this.linkAfter(this.findPrev(wire), wire);
        }
    }

    private void linkFirst(WireNode wire) {
        this.head = this.tail = wire;
    }

    private void linkHead(WireNode wire) {
        wire.next = this.head;
        this.head.prev = wire;
        this.head = wire;
    }

    private void linkTail(WireNode wire) {
        this.tail.next = wire;
        wire.prev = this.tail;
        this.tail = wire;
    }

    private void linkAfter(WireNode prev, WireNode wire) {
        this.linkBetween(prev, wire, prev.next);
    }

    private void linkBetween(WireNode prev, WireNode wire, WireNode next) {
        prev.next = wire;
        wire.next = next;
        wire.prev = prev;
        next.prev = wire;
    }

    private WireNode findPrev(WireNode wire) {
        WireNode prev = null;
        for (int i = wire.power + this.offset; i < this.tails.length && (prev = this.tails[i]) == null; ++i) {
        }
        return prev;
    }
}

