/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.wire;

import alternate.current.wire.LevelAccess;
import alternate.current.wire.Node;
import alternate.current.wire.WireBlock;
import alternate.current.wire.WireConnectionManager;
import alternate.current.wire.WireType;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class WireNode
extends Node {
    final WireType type;
    final WireConnectionManager connections;
    int currentPower;
    int virtualPower;
    int externalPower;
    int flowIn;
    int iFlowDir;
    boolean added;
    boolean removed;
    boolean shouldBreak;
    boolean prepared;
    boolean inNetwork;
    int power;
    WireNode prev;
    WireNode next;

    WireNode(WireBlock wireBlock, LevelAccess level, class_2338 pos, class_2680 state) {
        this(wireBlock.getWireType(), level, pos, state);
    }

    WireNode(WireType type, LevelAccess level, class_2338 pos, class_2680 state) {
        super(level);
        this.pos = pos.method_10062();
        this.state = state;
        this.type = type;
        this.connections = new WireConnectionManager(this);
        this.virtualPower = this.currentPower = this.type.getPower(this.level, this.pos, this.state);
    }

    @Override
    public Node update(class_2338 pos, class_2680 state, boolean clearNeighbors) {
        throw new UnsupportedOperationException("Cannot update a WireNode!");
    }

    @Override
    public boolean isWire() {
        return true;
    }

    @Override
    public boolean isWire(WireType type) {
        return this.type == type;
    }

    @Override
    public WireNode asWire() {
        return this;
    }

    int nextPower() {
        return this.type.clamp(this.virtualPower);
    }

    boolean offerPower(int power, int iDir) {
        if (this.removed || this.shouldBreak) {
            return false;
        }
        if (power == this.virtualPower) {
            this.flowIn |= 1 << iDir;
            return false;
        }
        if (power > this.virtualPower) {
            this.virtualPower = power;
            this.flowIn = 1 << iDir;
            return true;
        }
        return false;
    }

    boolean setPower() {
        if (this.removed) {
            return true;
        }
        this.state = this.level.getBlockState(this.pos);
        if (this.shouldBreak) {
            return this.level.breakWire(this.pos, this.state);
        }
        this.currentPower = this.power;
        this.state = this.type.setPower(this.level, this.pos, this.state, this.currentPower);
        return this.level.setWireState(this.pos, this.state, this.added);
    }
}

