/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore;

import com.mojang.brigadier.CommandDispatcher;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import team.creative.creativecore.ICreativeLoader;
import team.creative.creativecore.client.ClientLoader;
import team.creative.creativecore.common.CommonLoader;

public class CreativeForgeLoader
implements ICreativeLoader {
    @Override
    public void registerDisplayTest(Supplier<String> suppliedVersion, BiPredicate<String, Boolean> remoteVersionTest) {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(suppliedVersion, remoteVersionTest));
    }

    @Override
    public String ignoreServerNetworkConstant() {
        return "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31";
    }

    @Override
    public void register(CommonLoader loader) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(x -> loader.onInitialize());
    }

    @Override
    public void registerClient(ClientLoader loader) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(x -> loader.onInitializeClient());
            MinecraftForge.EVENT_BUS.addListener(x -> loader.registerClientCommands((CommandDispatcher<CommandSourceStack>)x.getDispatcher()));
        });
    }

    @Override
    public void registerClientTick(Runnable run) {
        MinecraftForge.EVENT_BUS.addListener(x -> {
            if (x.phase == TickEvent.Phase.START) {
                run.run();
            }
        });
    }

    @Override
    public void registerClientRender(Runnable run) {
        MinecraftForge.EVENT_BUS.addListener(x -> {
            if (x.phase == TickEvent.Phase.END) {
                run.run();
            }
        });
    }

    @Override
    public void registerLoadLevel(Consumer<LevelAccessor> consumer) {
        MinecraftForge.EVENT_BUS.addListener(x -> consumer.accept(x.getWorld()));
    }

    public void registerListener(Consumer consumer) {
        MinecraftForge.EVENT_BUS.addListener(consumer);
    }

    @Override
    public void registerClientStarted(Runnable run) {
        run.run();
    }

    @Override
    public void postForge(Event event) {
        MinecraftForge.EVENT_BUS.post(event);
    }

    @Override
    public boolean isModLoaded(String modid) {
        return ModList.get().isLoaded(modid);
    }
}

