/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.Side;
import team.creative.creativecore.client.render.model.CreativeModelLoader;
import team.creative.creativecore.client.render.model.CreativeRenderBlock;
import team.creative.creativecore.client.render.model.CreativeRenderItem;
import team.creative.creativecore.common.config.gui.ConfigGuiLayer;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.gui.IScaleableGuiScreen;
import team.creative.creativecore.common.gui.integration.ContainerIntegration;
import team.creative.creativecore.common.gui.integration.ContainerScreenIntegration;
import team.creative.creativecore.common.gui.integration.GuiEventHandler;
import team.creative.creativecore.common.gui.integration.GuiScreenIntegration;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.util.registry.FilteredHandlerRegistry;

public class CreativeCoreClient {
    private static Minecraft mc = Minecraft.m_91087_();
    public static final FilteredHandlerRegistry<Item, CreativeRenderItem> RENDERED_ITEMS = new FilteredHandlerRegistry(null);
    public static final FilteredHandlerRegistry<Block, CreativeRenderBlock> RENDERED_BLOCKS = new FilteredHandlerRegistry(null);
    private static final ItemColor ITEM_COLOR = (stack, tint) -> tint;

    public static void registerClientConfig(String modid) {
        ModLoadingContext.get().registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((a, b) -> {
            ICreativeConfigHolder holder = CreativeConfigRegistry.ROOT.followPath(modid);
            if (holder != null && !holder.isEmpty(Side.CLIENT)) {
                return new GuiScreenIntegration(new ConfigGuiLayer(holder, Side.CLIENT));
            }
            return null;
        }));
    }

    public static void registerBlocks(CreativeRenderBlock renderer, Block ... blocks) {
        for (int i = 0; i < blocks.length; ++i) {
            RENDERED_BLOCKS.register(blocks[i], renderer);
        }
    }

    public static void registerBlock(CreativeRenderBlock renderer, Block block) {
        RENDERED_BLOCKS.register(block, renderer);
    }

    public static void registerItem(CreativeRenderItem renderer, Item item) {
        RENDERED_ITEMS.register(item, renderer);
        mc.getItemColors().m_92689_(ITEM_COLOR, new ItemLike[]{item});
    }

    public static float getDeltaFrameTime() {
        if (mc.m_91104_()) {
            return 1.0f;
        }
        return mc.m_91297_();
    }

    @SubscribeEvent
    public static void commands(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"cmdclientconfig").executes(x -> {
            try {
                GuiEventHandler.queueScreen(new GuiScreenIntegration(new ConfigGuiLayer(CreativeConfigRegistry.ROOT, Side.CLIENT)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 1;
        }));
    }

    public static void init(FMLClientSetupEvent event) {
        GuiStyle.reload();
        Minecraft minecraft = Minecraft.m_91087_();
        ReloadableResourceManager reloadableResourceManager = (ReloadableResourceManager)minecraft.m_91098_();
        reloadableResourceManager.m_7217_((PreparableReloadListener)new SimplePreparableReloadListener(){

            protected Object m_5944_(ResourceManager p_10796_, ProfilerFiller p_10797_) {
                return GuiStyle.class;
            }

            protected void m_5787_(Object p_10793_, ResourceManager p_10794_, ProfilerFiller p_10795_) {
                GuiStyle.reload();
                for (CreativeRenderItem handler : RENDERED_ITEMS.handlers()) {
                    handler.reload();
                }
            }
        });
        MenuScreens.m_96206_(CreativeCore.GUI_CONTAINER, (MenuScreens.ScreenConstructor)new MenuScreens.ScreenConstructor<ContainerIntegration, ContainerScreenIntegration>(){

            public ContainerScreenIntegration create(ContainerIntegration container, Inventory inventory, Component p_create_3_) {
                return new ContainerScreenIntegration(container, inventory);
            }
        });
    }

    public static void modelEvent(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("creativecore", "rendered"), (IModelLoader)new CreativeModelLoader());
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && Minecraft.m_91087_().f_91080_ instanceof IScaleableGuiScreen) {
            ((IScaleableGuiScreen)Minecraft.m_91087_().f_91080_).clientTick();
        }
    }
}

