/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render.model;

import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.model.pipeline.ForgeBlockModelRenderer;
import net.minecraftforge.client.model.pipeline.VertexBufferConsumer;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;
import net.minecraftforge.client.model.pipeline.VertexLighterSmoothAo;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import team.creative.creativecore.client.render.model.BlockInfoExtension;

public class CreativeBlockModelRenderer {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final Field lighterFlatField = ObfuscationReflectionHelper.findField(ForgeBlockModelRenderer.class, (String)"lighterFlat");
    private static final Field lighterSmoothField = ObfuscationReflectionHelper.findField(ForgeBlockModelRenderer.class, (String)"lighterSmooth");
    private static final Field consumerFlatField = ObfuscationReflectionHelper.findField(ForgeBlockModelRenderer.class, (String)"consumerFlat");
    private static final Field consumerSmoothField = ObfuscationReflectionHelper.findField(ForgeBlockModelRenderer.class, (String)"consumerSmooth");
    private static final Field blockInfoField = ObfuscationReflectionHelper.findField(VertexLighterFlat.class, (String)"blockInfo");

    public static VertexLighterFlat getLighter(boolean smooth) {
        return smooth ? CreativeBlockModelRenderer.getLighterSmooth() : CreativeBlockModelRenderer.getLighterFlat();
    }

    public static BlockInfoExtension getBlockInfo(VertexLighterFlat lighter) {
        try {
            return (BlockInfoExtension)blockInfoField.get(lighter);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static VertexLighterFlat getLighterFlat() {
        try {
            return (VertexLighterFlat)((ThreadLocal)lighterFlatField.get(mc.m_91289_().m_110937_())).get();
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static VertexLighterSmoothAo getLighterSmooth() {
        try {
            return (VertexLighterSmoothAo)((ThreadLocal)lighterSmoothField.get(mc.m_91289_().m_110937_())).get();
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static VertexBufferConsumer getConsumer(boolean smooth) {
        return smooth ? CreativeBlockModelRenderer.getConsumerSmooth() : CreativeBlockModelRenderer.getConsumerFlat();
    }

    public static VertexBufferConsumer getConsumerFlat() {
        try {
            return (VertexBufferConsumer)((ThreadLocal)consumerFlatField.get(mc.m_91289_().m_110937_())).get();
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static VertexBufferConsumer getConsumerSmooth() {
        try {
            return (VertexBufferConsumer)((ThreadLocal)consumerSmoothField.get(mc.m_91289_().m_110937_())).get();
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }
}

