/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.level.system;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import team.creative.creativecore.common.level.CreativeLevel;
import team.creative.creativecore.common.level.listener.LevelBoundsListener;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.type.list.SingletonList;

public class BlockUpdateLevelSystem {
    public final CreativeLevel level;
    private final List<LevelBoundsListener> levelBoundListeners = new ArrayList<LevelBoundsListener>();
    private int boundMinX = Integer.MAX_VALUE;
    private int boundMinY = Integer.MAX_VALUE;
    private int boundMinZ = Integer.MAX_VALUE;
    private int boundMaxX = Integer.MIN_VALUE;
    private int boundMaxY = Integer.MIN_VALUE;
    private int boundMaxZ = Integer.MIN_VALUE;
    private HashSet<BlockPos> edgePositions = new HashSet();
    private HashSet<BlockPos> allBlocks = new HashSet();

    public BlockUpdateLevelSystem(CreativeLevel level) {
        this.level = level;
    }

    public void registerLevelBoundListener(LevelBoundsListener listener) {
        this.levelBoundListeners.add(listener);
    }

    public Iterable<LevelBoundsListener> levelBoundListeners() {
        return this.levelBoundListeners;
    }

    private int getBound(Facing facing) {
        switch (facing) {
            case EAST: {
                return this.boundMaxX;
            }
            case WEST: {
                return this.boundMinX;
            }
            case UP: {
                return this.boundMaxY;
            }
            case DOWN: {
                return this.boundMinY;
            }
            case SOUTH: {
                return this.boundMaxZ;
            }
            case NORTH: {
                return this.boundMinZ;
            }
        }
        throw new UnsupportedOperationException();
    }

    private void setBound(Facing facing, int value) {
        switch (facing) {
            case EAST: {
                this.boundMaxX = value;
                break;
            }
            case WEST: {
                this.boundMinX = value;
                break;
            }
            case UP: {
                this.boundMaxY = value;
                break;
            }
            case DOWN: {
                this.boundMinY = value;
                break;
            }
            case SOUTH: {
                this.boundMaxZ = value;
                break;
            }
            case NORTH: {
                this.boundMinZ = value;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected boolean isWithinBoundsNoEdge(BlockPos pos) {
        return this.boundMinX < pos.m_123341_() && this.boundMaxX > pos.m_123341_() && this.boundMinY < pos.m_123342_() && this.boundMaxY > pos.m_123342_() && this.boundMinZ < pos.m_123343_() && this.boundMaxZ > pos.m_123343_();
    }

    protected boolean isWithinBounds(BlockPos pos) {
        return this.boundMinX <= pos.m_123341_() && this.boundMaxX >= pos.m_123341_() && this.boundMinY <= pos.m_123342_() && this.boundMaxY >= pos.m_123342_() && this.boundMinZ <= pos.m_123343_() && this.boundMaxZ >= pos.m_123343_();
    }

    private boolean isEdgeExcept(BlockPos pos, Facing facing) {
        for (int i = 0; i < Facing.values().length; ++i) {
            Facing other = Facing.values()[i];
            if (other == facing || pos.m_123304_(other.axis.toVanilla()) != this.getBound(other)) continue;
            return true;
        }
        return false;
    }

    public void init(Iterable<BlockPos> positions) {
        this.boundMinX = Integer.MAX_VALUE;
        this.boundMinY = Integer.MAX_VALUE;
        this.boundMinZ = Integer.MAX_VALUE;
        this.boundMaxX = Integer.MIN_VALUE;
        this.boundMaxY = Integer.MIN_VALUE;
        this.boundMaxZ = Integer.MIN_VALUE;
        for (BlockPos pos : positions) {
            this.boundMinX = Math.min(this.boundMinX, pos.m_123341_());
            this.boundMinY = Math.min(this.boundMinY, pos.m_123342_());
            this.boundMinZ = Math.min(this.boundMinZ, pos.m_123343_());
            this.boundMaxX = Math.max(this.boundMaxX, pos.m_123341_());
            this.boundMaxY = Math.max(this.boundMaxY, pos.m_123342_());
            this.boundMaxZ = Math.max(this.boundMaxZ, pos.m_123343_());
            this.allBlocks.add(pos);
        }
        for (BlockPos pos : this.allBlocks) {
            if (pos.m_123341_() != this.boundMinX && pos.m_123341_() != this.boundMaxX && pos.m_123342_() != this.boundMinY && pos.m_123342_() != this.boundMaxY && pos.m_123343_() != this.boundMinZ && pos.m_123343_() != this.boundMaxZ) continue;
            this.edgePositions.add(pos);
        }
        this.levelBoundListeners.forEach(x -> x.rescan(this.level, this, this.edgePositions));
    }

    public void blockChanged(BlockPos pos) {
        block11: {
            block10: {
                BlockState state = this.level.m_8055_(pos);
                if (!state.m_60795_()) break block10;
                if (!this.allBlocks.remove(pos) || !this.edgePositions.remove(pos)) break block11;
                for (int i = 0; i < Facing.values().length; ++i) {
                    Facing facing = Facing.values()[i];
                    Direction.Axis axis = facing.axis.toVanilla();
                    int bound = this.getBound(facing);
                    if (bound != pos.m_123304_(axis)) continue;
                    ArrayList<BlockPos> remaining = new ArrayList<BlockPos>();
                    for (BlockPos blockPos : this.edgePositions) {
                        if (blockPos.m_123304_(axis) != bound) continue;
                        remaining.add(blockPos);
                    }
                    if (remaining.isEmpty()) {
                        int newBound = facing.positive ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                        for (BlockPos scan : this.allBlocks) {
                            newBound = facing.positive ? Math.max(newBound, scan.m_123304_(axis)) : Math.min(newBound, scan.m_123304_(axis));
                        }
                        for (BlockPos scan : this.allBlocks) {
                            if (scan.m_123304_(axis) != newBound) continue;
                            remaining.add(scan);
                            this.edgePositions.add(scan);
                        }
                        this.setBound(facing, newBound);
                    }
                    this.levelBoundListeners.forEach(x -> x.rescan(this.level, this, facing, remaining, facing.positive ? bound + 1 : bound));
                }
                break block11;
            }
            if (this.allBlocks.add(pos) && !this.isWithinBoundsNoEdge(pos)) {
                for (int i = 0; i < Facing.values().length; ++i) {
                    Facing facing = Facing.values()[i];
                    Direction.Axis axis = facing.axis.toVanilla();
                    int bound = this.getBound(facing);
                    if (bound == pos.m_123304_(axis)) {
                        ArrayList<BlockPos> remaining = new ArrayList<BlockPos>();
                        this.edgePositions.add(pos);
                        for (BlockPos blockPos : this.edgePositions) {
                            if (blockPos.m_123304_(axis) != bound) continue;
                            remaining.add(blockPos);
                        }
                        this.levelBoundListeners.forEach(x -> x.rescan(this.level, this, facing, remaining, facing.positive ? bound + 1 : bound));
                        continue;
                    }
                    if (bound <= pos.m_123304_(axis)) continue;
                    Iterator<BlockPos> itr = this.edgePositions.iterator();
                    while (itr.hasNext()) {
                        BlockPos edge = itr.next();
                        if (edge.m_123304_(axis) != bound || this.isEdgeExcept(edge, facing)) continue;
                        itr.remove();
                    }
                    this.edgePositions.add(pos);
                    this.levelBoundListeners.forEach(x -> x.rescan(this.level, this, facing, new SingletonList<BlockPos>(pos), facing.positive ? bound + 1 : bound));
                }
            }
        }
    }
}

