/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.box;

import com.mojang.math.Vector3d;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.matrix.Matrix3;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.math.vec.Vec3f;

public class AlignedBox {
    public float minX;
    public float minY;
    public float minZ;
    public float maxX;
    public float maxY;
    public float maxZ;

    public AlignedBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public AlignedBox(AABB box) {
        this((float)box.f_82288_, (float)box.f_82289_, (float)box.f_82290_, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82293_);
    }

    public AlignedBox() {
        this(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public AlignedBox(AlignedBox cube) {
        this(cube.minX, cube.minY, cube.minZ, cube.maxX, cube.maxY, cube.maxZ);
    }

    public void add(float x, float y, float z) {
        this.minX += x;
        this.minY += y;
        this.minZ += z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
    }

    public void sub(float x, float y, float z) {
        this.minX -= x;
        this.minY -= y;
        this.minZ -= z;
        this.maxX -= x;
        this.maxY -= y;
        this.maxZ -= z;
    }

    public void add(Vector3d vec) {
        this.add((float)vec.f_86214_, (float)vec.f_86215_, (float)vec.f_86216_);
    }

    public void sub(Vector3d vec) {
        this.sub((float)vec.f_86214_, (float)vec.f_86215_, (float)vec.f_86216_);
    }

    public void add(Vec3i vec) {
        this.add(vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
    }

    public void sub(Vec3i vec) {
        this.sub(vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
    }

    public void scale(float scale) {
        this.minX *= scale;
        this.minY *= scale;
        this.minZ *= scale;
        this.maxX *= scale;
        this.maxY *= scale;
        this.maxZ *= scale;
    }

    public Vector3d getSize() {
        return new Vector3d((double)(this.maxX - this.minX), (double)(this.maxY - this.minY), (double)(this.maxZ - this.minZ));
    }

    public Vector3d getCenter() {
        return new Vector3d((double)(this.maxX + this.minX) * 0.5, (double)(this.maxY + this.minY) * 0.5, (double)(this.maxZ + this.minZ) * 0.5);
    }

    public String toString() {
        return "cube[" + this.minX + ", " + this.minY + ", " + this.minZ + " -> " + this.maxX + ", " + this.maxY + ", " + this.maxZ + "]";
    }

    public Vec3f getCorner(BoxCorner corner) {
        return new Vec3f(this.get(corner.x), this.get(corner.y), this.get(corner.z));
    }

    public AABB getBB() {
        return new AABB((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
    }

    public AABB getBB(BlockPos pos) {
        return new AABB((double)(this.minX + (float)pos.m_123341_()), (double)(this.minY + (float)pos.m_123342_()), (double)(this.minZ + (float)pos.m_123343_()), (double)(this.maxX + (float)pos.m_123341_()), (double)(this.maxY + (float)pos.m_123342_()), (double)(this.maxZ + (float)pos.m_123343_()));
    }

    public void rotate(Rotation rotation, Vec3f center) {
        Vec3f low = new Vec3f(this.minX, this.minY, this.minZ);
        Vec3f high = new Vec3f(this.maxX, this.maxY, this.maxZ);
        low.sub(center);
        high.sub(center);
        rotation.getMatrix().transform(low);
        rotation.getMatrix().transform(high);
        low.add(center);
        high.add(center);
        this.set(low.x, low.y, low.z, high.x, high.y, high.z);
    }

    public void rotate(Matrix3 matrix, Vec3f center) {
        Vec3f low = new Vec3f(this.minX, this.minY, this.minZ);
        Vec3f high = new Vec3f(this.maxX, this.maxY, this.maxZ);
        low.sub(center);
        high.sub(center);
        matrix.transform(low);
        matrix.transform(high);
        low.add(center);
        high.add(center);
        this.set(low.x, low.y, low.z, high.x, high.y, high.z);
    }

    public void set(float x, float y, float z, float x2, float y2, float z2) {
        this.minX = Math.min(x, x2);
        this.minY = Math.min(y, y2);
        this.minZ = Math.min(z, z2);
        this.maxX = Math.max(x, x2);
        this.maxY = Math.max(y, y2);
        this.maxZ = Math.max(z, z2);
    }

    public BlockPos getOffset() {
        return new BlockPos((double)this.minX, (double)this.minY, (double)this.minZ);
    }

    public float get(Facing facing) {
        switch (facing) {
            case EAST: {
                return this.maxX;
            }
            case WEST: {
                return this.minX;
            }
            case UP: {
                return this.maxY;
            }
            case DOWN: {
                return this.minY;
            }
            case SOUTH: {
                return this.maxZ;
            }
            case NORTH: {
                return this.minZ;
            }
        }
        return 0.0f;
    }

    public float getSize(Axis axis) {
        switch (axis) {
            case X: {
                return this.maxX - this.minX;
            }
            case Y: {
                return this.maxY - this.minY;
            }
            case Z: {
                return this.maxZ - this.minZ;
            }
        }
        return 0.0f;
    }

    public void setMin(Axis axis, float value) {
        switch (axis) {
            case X: {
                this.minX = value;
                break;
            }
            case Y: {
                this.minY = value;
                break;
            }
            case Z: {
                this.minZ = value;
            }
        }
    }

    public float getMin(Axis axis) {
        switch (axis) {
            case X: {
                return this.minX;
            }
            case Y: {
                return this.minY;
            }
            case Z: {
                return this.minZ;
            }
        }
        return 0.0f;
    }

    public void setMax(Axis axis, float value) {
        switch (axis) {
            case X: {
                this.maxX = value;
                break;
            }
            case Y: {
                this.maxY = value;
                break;
            }
            case Z: {
                this.maxZ = value;
            }
        }
    }

    public float getMax(Axis axis) {
        switch (axis) {
            case X: {
                return this.maxX;
            }
            case Y: {
                return this.maxY;
            }
            case Z: {
                return this.maxZ;
            }
        }
        return 0.0f;
    }

    public void grow(Axis axis, float value) {
        this.setMin(axis, this.getMin(axis) - (value /= 2.0f));
        this.setMax(axis, this.getMax(axis) + value);
    }

    public void shrink(Axis axis, float value) {
        this.setMin(axis, this.getMin(axis) + (value /= 2.0f));
        this.setMax(axis, this.getMax(axis) - value);
    }
}

