/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.box;

import com.mojang.math.Vector3d;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.CreativeAABB;
import team.creative.creativecore.common.util.math.collision.CollidingPlane;
import team.creative.creativecore.common.util.math.matrix.IVecOrigin;

public class OBB
extends CreativeAABB {
    public IVecOrigin origin;
    public CollidingPlane.PlaneCache cache;
    public static final float EPSILON = 0.001f;

    public void buildCache() {
        this.cache = new CollidingPlane.PlaneCache(this);
    }

    public OBB(IVecOrigin origin, double x1, double y1, double z1, double x2, double y2, double z2) {
        super(x1, y1, z1, x2, y2, z2);
        this.origin = origin;
    }

    public OBB(IVecOrigin origin, AABB bb) {
        super(bb.f_82288_, bb.f_82289_, bb.f_82290_, bb.f_82291_, bb.f_82292_, bb.f_82293_);
        this.origin = origin;
    }

    public OBB setMinX(double value) {
        return new OBB(this.origin, value, this.f_82289_, this.f_82290_, this.f_82291_, this.f_82292_, this.f_82293_);
    }

    public OBB setMinY(double value) {
        return new OBB(this.origin, this.f_82288_, value, this.f_82290_, this.f_82291_, this.f_82292_, this.f_82293_);
    }

    public OBB setMinZ(double value) {
        return new OBB(this.origin, this.f_82288_, this.f_82289_, value, this.f_82291_, this.f_82292_, this.f_82293_);
    }

    public OBB setMaxX(double value) {
        return new OBB(this.origin, this.f_82288_, this.f_82289_, this.f_82290_, value, this.f_82292_, this.f_82293_);
    }

    public OBB setMaxY(double value) {
        return new OBB(this.origin, this.f_82288_, this.f_82289_, this.f_82290_, this.f_82291_, value, this.f_82293_);
    }

    public OBB setMaxZ(double value) {
        return new OBB(this.origin, this.f_82288_, this.f_82289_, this.f_82290_, this.f_82291_, this.f_82292_, value);
    }

    public OBB set(Facing facing, double value) {
        switch (facing) {
            case EAST: {
                return new OBB(this.origin, this.f_82288_, this.f_82289_, this.f_82290_, value, this.f_82292_, this.f_82293_);
            }
            case WEST: {
                return new OBB(this.origin, value, this.f_82289_, this.f_82290_, this.f_82291_, this.f_82292_, this.f_82293_);
            }
            case UP: {
                return new OBB(this.origin, this.f_82288_, this.f_82289_, this.f_82290_, this.f_82291_, value, this.f_82293_);
            }
            case DOWN: {
                return new OBB(this.origin, this.f_82288_, value, this.f_82290_, this.f_82291_, this.f_82292_, this.f_82293_);
            }
            case SOUTH: {
                return new OBB(this.origin, this.f_82288_, this.f_82289_, this.f_82290_, this.f_82291_, this.f_82292_, value);
            }
            case NORTH: {
                return new OBB(this.origin, this.f_82288_, this.f_82289_, value, this.f_82291_, this.f_82292_, this.f_82293_);
            }
        }
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof OBB)) {
            return false;
        }
        OBB axisalignedbb = (OBB)((Object)p_equals_1_);
        if (axisalignedbb.origin != this.origin) {
            return false;
        }
        if (Double.compare(axisalignedbb.f_82288_, this.f_82288_) != 0) {
            return false;
        }
        if (Double.compare(axisalignedbb.f_82289_, this.f_82289_) != 0) {
            return false;
        }
        if (Double.compare(axisalignedbb.f_82290_, this.f_82290_) != 0) {
            return false;
        }
        if (Double.compare(axisalignedbb.f_82291_, this.f_82291_) != 0) {
            return false;
        }
        if (Double.compare(axisalignedbb.f_82292_, this.f_82292_) != 0) {
            return false;
        }
        return Double.compare(axisalignedbb.f_82293_, this.f_82293_) == 0;
    }

    public OBB contract(double x, double y, double z) {
        double d0 = this.f_82288_;
        double d1 = this.f_82289_;
        double d2 = this.f_82290_;
        double d3 = this.f_82291_;
        double d4 = this.f_82292_;
        double d5 = this.f_82293_;
        if (x < 0.0) {
            d0 -= x;
        } else if (x > 0.0) {
            d3 -= x;
        }
        if (y < 0.0) {
            d1 -= y;
        } else if (y > 0.0) {
            d4 -= y;
        }
        if (z < 0.0) {
            d2 -= z;
        } else if (z > 0.0) {
            d5 -= z;
        }
        return new OBB(this.origin, d0, d1, d2, d3, d4, d5);
    }

    public OBB expandTowards(double x, double y, double z) {
        double d0 = this.f_82288_;
        double d1 = this.f_82289_;
        double d2 = this.f_82290_;
        double d3 = this.f_82291_;
        double d4 = this.f_82292_;
        double d5 = this.f_82293_;
        if (x < 0.0) {
            d0 += x;
        } else if (x > 0.0) {
            d3 += x;
        }
        if (y < 0.0) {
            d1 += y;
        } else if (y > 0.0) {
            d4 += y;
        }
        if (z < 0.0) {
            d2 += z;
        } else if (z > 0.0) {
            d5 += z;
        }
        return new OBB(this.origin, d0, d1, d2, d3, d4, d5);
    }

    public OBB inflate(double x, double y, double z) {
        double d0 = this.f_82288_ - x;
        double d1 = this.f_82289_ - y;
        double d2 = this.f_82290_ - z;
        double d3 = this.f_82291_ + x;
        double d4 = this.f_82292_ + y;
        double d5 = this.f_82293_ + z;
        return new OBB(this.origin, d0, d1, d2, d3, d4, d5);
    }

    public OBB inflate(double value) {
        return this.inflate(value, value, value);
    }

    public OBB move(double x, double y, double z) {
        return new OBB(this.origin, this.f_82288_ + x, this.f_82289_ + y, this.f_82290_ + z, this.f_82291_ + x, this.f_82292_ + y, this.f_82293_ + z);
    }

    public OBB move(BlockPos pos) {
        return new OBB(this.origin, this.f_82288_ + (double)pos.m_123341_(), this.f_82289_ + (double)pos.m_123342_(), this.f_82290_ + (double)pos.m_123343_(), this.f_82291_ + (double)pos.m_123341_(), this.f_82292_ + (double)pos.m_123342_(), this.f_82293_ + (double)pos.m_123343_());
    }

    public static boolean smallerThanAndEquals(double a, double b) {
        return a < b || OBB.equals(a, b);
    }

    public static boolean greaterThanAndEquals(double a, double b) {
        return a > b || OBB.equals(a, b);
    }

    public static boolean equals(double a, double b) {
        return a == b ? true : Math.abs(a - b) < (double)0.001f;
    }

    public double getMaxTranslated(Axis axis) {
        return this.getMax(axis) + this.origin.translationCombined(axis);
    }

    public double getMinTranslated(Axis axis) {
        return this.getMin(axis) + this.origin.translationCombined(axis);
    }

    public boolean m_82381_(AABB other) {
        if (other instanceof OBB) {
            if (((OBB)other).origin == this.origin) {
                return this.f_82288_ < other.f_82291_ && this.f_82291_ > other.f_82288_ && this.f_82289_ < other.f_82292_ && this.f_82292_ > other.f_82289_ && this.f_82290_ < other.f_82293_ && this.f_82293_ > other.f_82290_;
            }
            OBB converted = ((OBB)other).origin.getOrientatedBox(this.origin.getAxisAlignedBox(this));
            return converted.f_82288_ < other.f_82291_ && converted.f_82291_ > other.f_82288_ && converted.f_82289_ < other.f_82292_ && converted.f_82292_ > other.f_82289_ && converted.f_82290_ < other.f_82293_ && converted.f_82293_ > other.f_82290_;
        }
        return this.m_82314_(other.f_82288_, other.f_82289_, other.f_82290_, other.f_82291_, other.f_82292_, other.f_82293_);
    }

    public boolean m_82314_(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        AABB box = this.origin.getAxisAlignedBox(this);
        return box.f_82288_ < maxX && box.f_82291_ > minX && box.f_82289_ < maxY && box.f_82292_ > minY && box.f_82290_ < maxZ && box.f_82293_ > minZ;
    }

    public String toString() {
        return "box[" + this.f_82288_ + ", " + this.f_82289_ + ", " + this.f_82290_ + " -> " + this.f_82291_ + ", " + this.f_82292_ + ", " + this.f_82293_ + "]";
    }

    public Vector3d getCenter3d() {
        return new Vector3d(this.f_82288_ + (this.f_82291_ - this.f_82288_) * 0.5, this.f_82289_ + (this.f_82292_ - this.f_82289_) * 0.5, this.f_82290_ + (this.f_82293_ - this.f_82290_) * 0.5);
    }

    public double getPushOutScale(double minScale, OBB fakeBox, Vector3d pushVec) {
        boolean pushZ;
        double scale = Double.MAX_VALUE;
        boolean pushX = pushVec.f_86214_ != 0.0;
        boolean pushY = pushVec.f_86215_ != 0.0;
        boolean bl = pushZ = pushVec.f_86216_ != 0.0;
        if (pushX) {
            scale = pushVec.f_86214_ > 0.0 ? Math.min(scale, Math.abs((this.f_82291_ - fakeBox.f_82288_) / pushVec.f_86214_)) : Math.min(scale, Math.abs((this.f_82288_ - fakeBox.f_82291_) / pushVec.f_86214_));
        }
        if (pushY) {
            scale = pushVec.f_86215_ > 0.0 ? Math.min(scale, Math.abs((this.f_82292_ - fakeBox.f_82289_) / pushVec.f_86215_)) : Math.min(scale, Math.abs((this.f_82289_ - fakeBox.f_82292_) / pushVec.f_86215_));
        }
        if (pushZ) {
            scale = pushVec.f_86216_ > 0.0 ? Math.min(scale, Math.abs((this.f_82293_ - fakeBox.f_82290_) / pushVec.f_86216_)) : Math.min(scale, Math.abs((this.f_82290_ - fakeBox.f_82293_) / pushVec.f_86216_));
        }
        if (scale <= minScale) {
            return minScale;
        }
        return scale;
    }
}

