/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.text;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.common.util.text.ItemStackComponent;
import team.creative.creativecore.common.util.text.LinebreakComponent;

public interface AdvancedComponent
extends FormattedText {
    public int getWidth(Font var1);

    public int getHeight(Font var1);

    public boolean canSplit();

    public List<AdvancedComponent> split(int var1, boolean var2);

    public boolean isEmpty();

    public void render(PoseStack var1, Font var2, int var3);

    public static class Serializer
    extends Component.Serializer {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public JsonElement serialize(Component component, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonobject = new JsonObject();
            if (!(component instanceof AdvancedComponent)) return super.serialize(component, typeOfSrc, context);
            if (!component.m_7360_().isEmpty()) {
                JsonArray jsonarray = new JsonArray();
                for (Component child : component.m_7360_()) {
                    jsonarray.add(this.serialize(child, (Type)child.getClass(), context));
                }
                jsonobject.add("extra", (JsonElement)jsonarray);
            }
            if (component instanceof ItemStackComponent) {
                ItemStackComponent stackComponent = (ItemStackComponent)component;
                jsonobject.addProperty("stack", stackComponent.stack.m_41739_(new CompoundTag()).toString());
                return jsonobject;
            } else {
                if (!(component instanceof LinebreakComponent)) throw new IllegalArgumentException("Don't know how to serialize " + component + " as an AdvancedComponent");
                jsonobject.addProperty("linebreak", Boolean.valueOf(true));
            }
            return jsonobject;
        }

        public MutableComponent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!json.isJsonObject()) {
                return super.deserialize(json, typeOfT, context);
            }
            JsonObject jsonobject = json.getAsJsonObject();
            if (jsonobject.has("stack")) {
                try {
                    return new ItemStackComponent(ItemStack.m_41712_((CompoundTag)TagParser.m_129359_((String)jsonobject.get("stack").getAsString())));
                }
                catch (CommandSyntaxException e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            if (jsonobject.has("linebreak")) {
                return new LinebreakComponent();
            }
            return super.deserialize(json, typeOfT, context);
        }
    }
}

