/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.items;

import com.github.talrey.createdeco.blocks.CatwalkBlock;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.placement.PlacementHelpers;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class CatwalkBlockItem
extends BlockItem {
    private final int placementHelperID = PlacementHelpers.register((IPlacementHelper)new CatwalkHelper());

    public CatwalkBlockItem(CatwalkBlock block, Item.Properties props) {
        super((Block)block, props);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        BlockPos pos = ctx.m_8083_();
        Direction face = ctx.m_43719_();
        Level world = ctx.m_43725_();
        Player player = ctx.m_43723_();
        BlockState state = world.m_8055_(pos);
        IPlacementHelper helper = PlacementHelpers.get((int)this.placementHelperID);
        BlockHitResult ray = new BlockHitResult(ctx.m_43720_(), face, pos, true);
        if (helper.matchesState(state) && player != null) {
            return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)this, player, ctx.m_43724_(), ray);
        }
        return super.onItemUseFirst(stack, ctx);
    }

    @MethodsReturnNonnullByDefault
    public static class CatwalkHelper
    implements IPlacementHelper {
        public Predicate<ItemStack> getItemPredicate() {
            return CatwalkBlock::isCatwalk;
        }

        public Predicate<BlockState> getStatePredicate() {
            return state -> CatwalkBlock.isCatwalk(state.m_60734_());
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction face = ray.m_82434_();
            if (face.m_122434_() != Direction.Axis.Y) {
                return PlacementOffset.success((Vec3i)pos.m_141952_(face.m_122436_()), offsetState -> (BlockState)((BlockState)((BlockState)offsetState.m_61124_((Property)CatwalkBlock.LIFTED, (Comparable)((Boolean)state.m_61143_((Property)CatwalkBlock.LIFTED)))).m_61124_((Property)CatwalkBlock.getPropertyFromDirection(face), (Comparable)Boolean.valueOf(!CatwalkBlock.isCatwalk(world.m_8055_(pos.m_141952_(face.m_122436_()).m_141952_(face.m_122436_())).m_60734_())))).m_61124_((Property)CatwalkBlock.getPropertyFromDirection(face.m_122424_()), (Comparable)Boolean.valueOf(false)));
            }
            List dirs = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.m_82450_(), (Direction.Axis)Direction.Axis.Y);
            for (Direction dir : dirs) {
                BlockPos newPos = pos.m_141952_(dir.m_122436_());
                if (!CatwalkBlock.canPlaceCatwalk(world, newPos)) continue;
                return PlacementOffset.success((Vec3i)newPos, offsetState -> (BlockState)((BlockState)((BlockState)offsetState.m_61124_((Property)CatwalkBlock.LIFTED, (Comparable)((Boolean)state.m_61143_((Property)CatwalkBlock.LIFTED)))).m_61124_((Property)CatwalkBlock.getPropertyFromDirection(dir), (Comparable)Boolean.valueOf(!CatwalkBlock.isCatwalk(world.m_8055_(newPos.m_141952_(dir.m_122436_())).m_60734_())))).m_61124_((Property)CatwalkBlock.getPropertyFromDirection(dir.m_122424_()), (Comparable)Boolean.valueOf(false)));
            }
            return PlacementOffset.fail();
        }
    }
}

