/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.client.GuiFunctions;
import shetiphian.core.client.gui.AbstractWidgetList;
import shetiphian.multibeds.client.gui.Textures;
import shetiphian.multibeds.common.inventory.ContainerBlanketLoom;
import shetiphian.multibeds.common.misc.EnumBlanket;

@OnlyIn(value=Dist.CLIENT)
public class GuiBlanketLoom
extends AbstractContainerScreen<ContainerBlanketLoom> {
    private static final Map<EnumBlanket, ResourceLocation> BLANKET_TEXTURES = new HashMap<EnumBlanket, ResourceLocation>();
    private WidgetList patternWidgetList;

    public GuiBlanketLoom(ContainerBlanketLoom container, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)container, playerInv, title);
        if (BLANKET_TEXTURES.isEmpty()) {
            for (EnumBlanket blanket : EnumBlanket.values()) {
                if (blanket == EnumBlanket.NONE || blanket == EnumBlanket.BANNER) continue;
                BLANKET_TEXTURES.put(blanket, new ResourceLocation("multibeds:textures/block/blanket/" + blanket.m_7912_() + ".png"));
            }
        }
        this.f_97726_ = 214;
        this.f_97727_ = 256;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.patternWidgetList = new WidgetList(this.f_96541_, this.f_97735_ + 96, this.f_97736_ + 16, 96, 128);
        for (EnumBlanket.Pattern pattern : EnumBlanket.Pattern.values()) {
            this.patternWidgetList.addEntry(new WidgetEntry(pattern));
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.m_7333_(matrixStack);
        GuiFunctions.enterDrawTextureStateWithBlend();
        RenderSystem.m_157456_((int)0, (ResourceLocation)Textures.BLANKET_LOOM.get());
        int winLeft = (this.f_96543_ - this.f_97726_) / 2;
        int winTop = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(matrixStack, winLeft, winTop, 0, 0, this.f_97726_, this.f_97727_);
        Slot slot = ((ContainerBlanketLoom)this.f_97732_).getSlotBlanket();
        if (!slot.m_6657_()) {
            this.m_93228_(matrixStack, winLeft + slot.f_40220_, winTop + slot.f_40221_, 240, 32, 16, 16);
        }
        if (!(slot = ((ContainerBlanketLoom)this.f_97732_).getSlotDye()).m_6657_()) {
            this.m_93228_(matrixStack, winLeft + slot.f_40220_, winTop + slot.f_40221_, 240, 0, 16, 16);
        }
        if (!(slot = ((ContainerBlanketLoom)this.f_97732_).getSlotString()).m_6657_()) {
            this.m_93228_(matrixStack, winLeft + slot.f_40220_, winTop + slot.f_40221_, 240, 16, 16, 16);
        }
        GuiFunctions.exitDrawTextureStateWithBlend();
        this.patternWidgetList.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Textures.BLANKET_LOOM.get());
        this.m_93228_(matrixStack, this.f_97735_ + 95, this.f_97736_ + 4, 96, 4, 102, 12);
        this.m_93228_(matrixStack, this.f_97735_ + 95, this.f_97736_ + 144, 96, 144, 102, 12);
        GuiFunctions.enterDrawTextureStateWithBlend();
        EnumBlanket blanket = ((ContainerBlanketLoom)this.f_97732_).getEnumBlanket();
        if (blanket != EnumBlanket.NONE && blanket != EnumBlanket.BANNER) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)BLANKET_TEXTURES.get((Object)blanket));
            GuiFunctions.drawTextureScaled((PoseStack)matrixStack, (double)(this.f_97735_ + 18), (double)(this.f_97736_ + 25), (int)1, (int)0, (int)30, (int)23, (double)2.0, (float)1.0f, (int[])new int[]{32});
            if (this.patternWidgetList.m_93511_() == null || ((WidgetEntry)this.patternWidgetList.m_93511_()).pattern != blanket.getPattern()) {
                for (WidgetEntry entry : this.patternWidgetList.m_6702_()) {
                    if (entry.pattern != blanket.getPattern()) continue;
                    this.patternWidgetList.m_6987_(entry);
                    break;
                }
            }
        } else if (this.patternWidgetList.m_93511_() != null) {
            this.patternWidgetList.m_6987_(null);
        }
    }

    protected void m_7027_(PoseStack matrixStack, int x, int y) {
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.patternWidgetList.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.patternWidgetList.m_7920_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char character, int value) {
        if (this.patternWidgetList.m_5534_(character, value)) {
            return true;
        }
        return super.m_5534_(character, value);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.patternWidgetList.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double accelX, double accelY) {
        if (this.patternWidgetList.m_7979_(mouseX, mouseY, button, accelX, accelY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, accelX, accelY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (this.patternWidgetList.m_6050_(mouseX, mouseY, scroll)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    private class WidgetList
    extends AbstractWidgetList<WidgetEntry> {
        WidgetList(Minecraft mc, int x, int y, int width, int height) {
            super(mc, x, y, width, height, 12);
            this.setFadeColors(0, 0);
            this.setScrollBarColors(Integer.MIN_VALUE, -2130706433, -1073741824);
            this.setSelectionBoxColors(Integer.MIN_VALUE, 0, 0);
        }

        protected int addEntry(WidgetEntry entry) {
            return this.m_6702_().contains((Object)entry) ? -1 : super.m_7085_((AbstractSelectionList.Entry)entry);
        }

        protected void renderBackground(PoseStack matrixStack, Tesselator tessellator, BufferBuilder bufferbuilder) {
        }

        protected void renderHoleBackground(PoseStack matrixStack, Tesselator tessellator, BufferBuilder bufferbuilder, int y0, int y1) {
        }
    }

    private class WidgetEntry
    extends AbstractSelectionList.Entry<WidgetEntry> {
        private final EnumBlanket.Pattern pattern;
        private final String name;

        WidgetEntry(EnumBlanket.Pattern pattern) {
            this.pattern = pattern;
            StringBuilder stringBuffer = new StringBuilder();
            String patternName = pattern.m_7912_().replaceAll("_", " ");
            int character = 32;
            for (int i = 0; i < patternName.length(); ++i) {
                if (character == 32 && patternName.charAt(i) != ' ') {
                    stringBuffer.append(Character.toUpperCase(patternName.charAt(i)));
                } else {
                    stringBuffer.append(patternName.charAt(i));
                }
                character = patternName.charAt(i);
            }
            this.name = stringBuffer.toString().trim();
        }

        String getDisplayName() {
            return this.name;
        }

        public void m_6311_(PoseStack matrixStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            boolean hasString = ((ContainerBlanketLoom)GuiBlanketLoom.this.f_97732_).getSlotString().m_6657_();
            if (hovered && hasString) {
                GuiFunctions.drawGradientRect((PoseStack)matrixStack, (double)left, (double)top, (double)(left + width - 3), (double)((float)top + (float)height / 2.0f), (float)0.0f, (int)-2130706688, (int)-2130706688, (int)-256, (int)-256);
                GuiFunctions.drawGradientRect((PoseStack)matrixStack, (double)left, (double)((float)top + (float)height / 2.0f), (double)(left + width - 3), (double)(top + height), (float)0.0f, (int)-256, (int)-256, (int)-2130706688, (int)-2130706688);
                RenderSystem.m_69478_();
            }
            int color = hasString ? 0xFFFFFF : 0xAAAAAA;
            GuiComponent.m_93208_((PoseStack)matrixStack, (Font)GuiBlanketLoom.this.f_96547_, (String)this.getDisplayName(), (int)(left + width / 2), (int)top, (int)color);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 0 && !((ContainerBlanketLoom)GuiBlanketLoom.this.f_97732_).getSlotString().m_7993_().m_41619_()) {
                GuiBlanketLoom.this.patternWidgetList.m_6987_(this);
                MultiPlayerGameMode controller = Minecraft.m_91087_().f_91072_;
                if (controller != null) {
                    controller.m_105208_(((ContainerBlanketLoom)((GuiBlanketLoom)GuiBlanketLoom.this).f_97732_).f_38840_, this.pattern.ordinal());
                    return true;
                }
            }
            return false;
        }
    }
}

