/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.model;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import shetiphian.core.client.model.AssembledBakedModel;
import shetiphian.core.client.model.CompositeBakedModel;
import shetiphian.core.client.model.data.ModelProperties;
import shetiphian.core.common.UseContext;
import shetiphian.multibeds.client.model.CacheBuilder;
import shetiphian.multibeds.client.model.Parts;
import shetiphian.multibeds.client.render.RenderArtOnBed;
import shetiphian.multibeds.common.block.BlockMultiBedBase;
import shetiphian.multibeds.common.item.ItemBlockMultiBed;
import shetiphian.multibeds.common.misc.EnumBedStyle;
import shetiphian.multibeds.common.misc.EnumBlanket;
import shetiphian.multibeds.common.misc.EnumSpreadArt;

@OnlyIn(value=Dist.CLIENT)
public class ModelBed {
    private static void add(List<BakedModel> list, String part, String key, Direction facing, String particle) {
        BakedModel model = CacheBuilder.getBed(part, key, facing, particle);
        if (model != null) {
            list.add(model);
        }
    }

    private static class ItemHandler {
        static ItemHandler INSTANCE = new ItemHandler();
        private static ItemTransforms transforms;

        private ItemHandler() {
        }

        BakedModel getModel(ItemStack stack, BakedModel original) {
            if (!stack.m_41619_() && stack.m_41720_() instanceof ItemBlockMultiBed) {
                if (transforms == null) {
                    this.buildTransforms();
                }
                ItemBlockMultiBed bed = (ItemBlockMultiBed)stack.m_41720_();
                EnumBedStyle style = EnumBedStyle.byBlock(bed.m_40614_());
                String material = CacheBuilder.INSTANCE.getTexture(ItemBlockMultiBed.getTextureStack(stack));
                ArrayList<BakedModel> list = new ArrayList<BakedModel>();
                ModelBed.add(list, "item/parts/pillow", "default", Direction.SOUTH, material);
                ModelBed.add(list, "item/parts/mattress", "default", Direction.SOUTH, material);
                ModelBed.add(list, "item/parts/base_" + style.getBaseType(), material, Direction.SOUTH, material);
                ModelBed.add(list, "item/parts/bed_" + style.getString(), material, Direction.SOUTH, material);
                return new AssembledBakedModel(list, new ItemTransforms[]{transforms});
            }
            return original;
        }

        void buildTransforms() {
            ItemTransform thirdperson = this.create(30.0f, 160.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.23f, 0.23f, 0.23f);
            ItemTransform firstperson = this.create(30.0f, 160.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform gui = this.create(30.0f, 160.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
            ItemTransform ground = this.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.2f, 0.2f, 0.2f);
            ItemTransform head = ItemTransform.f_111754_;
            ItemTransform fixed = this.create(270.0f, 0.0f, 0.0f, 0.0f, 0.0f, -2.0f, 0.5f, 0.5f, 0.5f);
            transforms = new ItemTransforms(thirdperson, thirdperson, firstperson, firstperson, head, gui, ground, fixed);
        }

        private ItemTransform create(float rX, float rY, float rZ, float tX, float tY, float tZ, float sX, float sY, float sZ) {
            Vector3f rotation = new Vector3f(rX, rY, rZ);
            Vector3f translation = new Vector3f(tX, tY, tZ);
            translation.m_122261_(0.0625f);
            translation.m_122242_(-5.0f, 5.0f);
            Vector3f scale = new Vector3f(sX, sY, sZ);
            scale.m_122242_(-4.0f, 4.0f);
            return new ItemTransform(rotation, translation, scale);
        }
    }

    private static class BlockHandler {
        static BlockHandler INSTANCE = new BlockHandler();

        private BlockHandler() {
        }

        List<BakedModel> getList(BlockState state, IModelData data, RenderType layer) {
            boolean railRight;
            CompoundTag nbtTag;
            if (!(state.m_60734_() instanceof BlockMultiBedBase)) {
                return Collections.emptyList();
            }
            String typeLegs = "single";
            String typeBody = "single";
            ItemStack materialItem = ItemStack.f_41583_;
            boolean hasSheet = false;
            boolean hasPillowCase = false;
            EnumBlanket blanket = EnumBlanket.NONE;
            EnumSpreadArt art = EnumSpreadArt.NONE;
            if (data.hasProperty(ModelProperties.NBTProperty) && (nbtTag = (CompoundTag)data.getData(ModelProperties.NBTProperty)) != null) {
                if (nbtTag.m_128441_("bed_type")) {
                    String[] types = nbtTag.m_128461_("bed_type").split("#");
                    typeLegs = types[0];
                    typeBody = types[1];
                }
                if (nbtTag.m_128441_("bed_material")) {
                    materialItem = ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("bed_material"));
                }
                if (nbtTag.m_128441_("has_sheet")) {
                    hasSheet = nbtTag.m_128471_("has_sheet");
                }
                if (nbtTag.m_128441_("has_pillowcase")) {
                    hasPillowCase = nbtTag.m_128471_("has_pillowcase");
                }
                if (nbtTag.m_128441_("blanket_type")) {
                    blanket = EnumBlanket.byName(nbtTag.m_128461_("blanket_type"));
                }
                if (nbtTag.m_128441_("art_type")) {
                    art = EnumSpreadArt.byName(nbtTag.m_128461_("art_type"));
                }
            }
            String typeBlanket = typeBody.contains("bunk") ? "bunk" : typeBody;
            String string = typeBody = typeBody.contains("bunk") ? "single" : typeBody;
            String typePillow = typeBody.contains("left") ? "left" : (typeBody.contains("right") ? "right" : "middle");
            String material = CacheBuilder.INSTANCE.getTexture(materialItem);
            String part = state.m_61143_((Property)BlockMultiBedBase.f_49440_) == BedPart.FOOT ? "foot" : "head";
            Direction facing = (Direction)state.m_61143_((Property)BlockMultiBedBase.f_54117_);
            EnumBedStyle style = EnumBedStyle.byBlock(state.m_60734_());
            String base = style.getBaseType();
            boolean isUp = typeLegs.equalsIgnoreCase("bunk_middle") || typeLegs.equalsIgnoreCase("bunk_top");
            boolean railLeft = isUp && (typeBody.contains("left") || typeBody.contains("single"));
            boolean bl = railRight = isUp && (typeBody.contains("right") || typeBody.contains("single"));
            typeBlanket = typeLegs.contains("bunk") ? (railLeft && !railRight ? "bunk_left" : (!railLeft && railRight ? "bunk_right" : typeBlanket)) : typeBlanket;
            boolean renderFrame = layer == RenderType.m_110451_();
            BlockState materialState = UseContext.getBlockPlacementStateFor((ItemStack)materialItem);
            renderFrame = ItemBlockRenderTypes.canRenderInLayer((BlockState)materialState, (RenderType)RenderType.m_110466_()) ? layer == RenderType.m_110466_() : (ItemBlockRenderTypes.canRenderInLayer((BlockState)materialState, (RenderType)RenderType.m_110463_()) || ItemBlockRenderTypes.canRenderInLayer((BlockState)materialState, (RenderType)RenderType.m_110457_()) ? layer == RenderType.m_110463_() : renderFrame);
            ArrayList<BakedModel> list = new ArrayList<BakedModel>();
            if (renderFrame) {
                if (!base.equalsIgnoreCase("none")) {
                    ModelBed.add(list, "base/" + base + "_" + typeBody + "_" + part, material, facing, material);
                }
                ModelBed.add(list, style + "/" + typeLegs + "_" + part, material, facing, material);
                if (part.equalsIgnoreCase("head")) {
                    if (railLeft) {
                        ModelBed.add(list, style + "/bunk_rail_left", material, facing, material);
                    }
                    if (railRight) {
                        ModelBed.add(list, style + "/bunk_rail_right", material, facing, material);
                    }
                }
            }
            if (layer == RenderType.m_110451_()) {
                if (hasSheet) {
                    ModelBed.add(list, "common/mattress_" + typeBody + "_" + part, Parts.getSheetTexture(), facing, material);
                } else {
                    ModelBed.add(list, "common/mattress_" + typeBody + "_" + part, "default", facing, material);
                }
                if (part.equalsIgnoreCase("head")) {
                    if (hasPillowCase) {
                        ModelBed.add(list, "common/pillow_" + typePillow, Parts.getPillowTexture(), facing, material);
                    } else {
                        ModelBed.add(list, "common/pillow_" + typePillow, "default", facing, material);
                    }
                }
                if (blanket != EnumBlanket.NONE && blanket != EnumBlanket.BANNER) {
                    ModelBed.add(list, "common/blanket_" + typeBlanket + "_" + part, Parts.getBlanketTexture(blanket), facing, material);
                }
            }
            if (layer == RenderType.m_110466_() && blanket != EnumBlanket.NONE && part.equalsIgnoreCase("foot") && art != EnumSpreadArt.NONE && art != EnumSpreadArt.CUSTOM) {
                ModelBed.add(list, "common/art", Parts.getArtTexture(art), facing, material);
            }
            return list;
        }
    }

    public static class Baked
    extends CompositeBakedModel {
        public boolean m_7541_() {
            return false;
        }

        public TextureAtlasSprite getParticleIcon(@Nonnull IModelData data) {
            CompoundTag nbtTag;
            ItemStack materialItem = ItemStack.f_41583_;
            if (data.hasProperty(ModelProperties.NBTProperty) && (nbtTag = (CompoundTag)data.getData(ModelProperties.NBTProperty)) != null && nbtTag.m_128441_("bed_material")) {
                materialItem = ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("bed_material"));
            }
            if (materialItem.m_41619_()) {
                materialItem = new ItemStack((ItemLike)Blocks.f_50041_);
            }
            return CacheBuilder.INSTANCE.getTextureSprite(materialItem);
        }

        protected List<BakedModel> handleBlockState(BlockState state, Direction side, Random rand, IModelData data) {
            return BlockHandler.INSTANCE.getList(state, data, MinecraftForgeClient.getRenderType());
        }

        protected BakedModel handleItemState(BakedModel model, ItemStack stack, Level world, LivingEntity entity) {
            return ItemHandler.INSTANCE.getModel(stack, model);
        }
    }

    public static class Geometry
    implements IModelGeometry<Geometry> {
        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            ArrayList<Material> list = new ArrayList<Material>();
            for (ResourceLocation location : Parts.BED_TEXTURES) {
                list.add(new Material(TextureAtlas.f_118259_, location));
            }
            return ImmutableList.copyOf(list);
        }

        public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            CacheBuilder.INSTANCE.preBakeSetup(bakery, spriteGetter);
            return new Baked();
        }
    }

    public static class Loader
    implements IModelLoader<Geometry> {
        public void m_6213_(ResourceManager resourceManager) {
            CacheBuilder.rebuildCache();
            RenderArtOnBed.rebuildCache();
        }

        public Geometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            return new Geometry();
        }
    }
}

