/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.block;

import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.multibeds.client.render.RenderRegistry;
import shetiphian.multibeds.common.block.HitBoxHelper;
import shetiphian.multibeds.common.item.ItemBlockLadder;
import shetiphian.multibeds.common.item.ItemBlockMultiBed;
import shetiphian.multibeds.common.tileentity.TileEntityLadder;

public abstract class BlockLadderBase
extends LadderBlock
implements EntityBlock,
IColored {
    private static final Table<String, Direction, VoxelShape> HITBOXES = new HitBoxHelper().loadLadderBoxes().get();
    private static final Map<String, VoxelShape> BOXCACHE = new HashMap<String, VoxelShape>();

    protected BlockLadderBase(BlockBehaviour.Properties builder) {
        super(builder);
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.COLORIZE.add((Object)this));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityLadder(pos, state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)f_54337_)) {
            case NORTH: {
                return f_54341_;
            }
            case SOUTH: {
                return f_54342_;
            }
            case WEST: {
                return f_54339_;
            }
        }
        return f_54340_;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        String cacheKey;
        String type = "single";
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileEntityLadder) {
            type = ((TileEntityLadder)tile).getModelType();
        }
        if (!BOXCACHE.containsKey(cacheKey = type + ":" + ((Direction)state.m_61143_((Property)f_54337_)).m_122433_())) {
            VoxelShape shape = null;
            if (!HITBOXES.isEmpty()) {
                shape = (VoxelShape)HITBOXES.get((Object)("ladder_" + type), (Object)state.m_61143_((Property)f_54337_));
            }
            if (shape == null) {
                shape = this.m_5939_(state, world, pos, context);
            }
            BOXCACHE.put(cacheKey, shape);
        }
        return BOXCACHE.get(cacheKey);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return true;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state != null) {
            return (BlockState)((BlockState)state.m_61124_((Property)f_54337_, (Comparable)((Direction)state.m_61143_((Property)f_54337_)).m_122424_())).m_61124_((Property)f_54338_, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
        }
        return state;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntityLadder tile = BlockLadderBase.getTile((BlockGetter)world, pos);
        if (tile != null) {
            ItemStack texture = ItemBlockMultiBed.getTextureStack(stack);
            tile.setBedTextureBlock(texture);
            Function.syncTile((BlockEntity)tile);
        }
        world.m_6289_(pos, Blocks.f_50016_);
        state.m_60701_((LevelAccessor)world, pos, 3);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos neighbor, boolean isMoving) {
        super.m_6861_(state, world, pos, block, neighbor, isMoving);
        TileEntityLadder tile = BlockLadderBase.getTile((BlockGetter)world, pos);
        if (tile != null) {
            Function.syncTile((BlockEntity)tile);
        }
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        TileEntityLadder tile = BlockLadderBase.getTile(world, pos);
        return ItemBlockLadder.createStack((Block)this, tile != null ? tile.getBedTextureBlock() : ItemStack.f_41583_);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    private static TileEntityLadder getTile(BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        return tile instanceof TileEntityLadder ? (TileEntityLadder)tile : null;
    }

    public int getColorFor(IColored.Data data, int index) {
        TileEntityLadder tile;
        if (index > -1 && index < 3 && data.world != null && data.pos != null && (tile = BlockLadderBase.getTile((BlockGetter)data.world, data.pos)) != null && index == 0) {
            return tile.getMaterialColor();
        }
        return 0xFFFFFF;
    }
}

