/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.item;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.client.Localization;
import shetiphian.core.common.IColored;
import shetiphian.multibeds.client.render.RenderRegistry;

public class ItemBlockLadder
extends BlockItem
implements IColored {
    public ItemBlockLadder(Block block, Item.Properties properties) {
        super(block, properties);
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.COLORIZE.add((Object)this));
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> list) {
        if (this.m_41389_(group)) {
            list.add((Object)ItemBlockLadder.createStack(this.m_40614_(), new ItemStack((ItemLike)Blocks.f_50705_)));
        }
    }

    public void m_7836_(ItemStack stack, Level world, Player player) {
        CompoundTag tag = ItemBlockLadder.getTag(stack);
        if (!tag.m_128441_(ItemBlockLadder.getTextureKey())) {
            ItemStack textureStack = new ItemStack((ItemLike)Blocks.f_50705_);
            CompoundTag texture = new CompoundTag();
            textureStack.m_41739_(texture);
            tag.m_128365_(ItemBlockLadder.getTextureKey(), (Tag)texture);
        }
    }

    protected boolean m_7429_(BlockPlaceContext context, BlockState state) {
        return context.m_43725_().m_7731_(context.m_8083_(), state, 18);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack ladderStack, Level world, List<Component> tooltip, TooltipFlag advancedTooltips) {
        if (!ladderStack.m_41619_()) {
            CompoundTag tag = ItemBlockLadder.getTag(ladderStack);
            if (tag.m_128441_(ItemBlockLadder.getTextureKey())) {
                ItemStack tagStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_(ItemBlockLadder.getTextureKey()));
                if (!tagStack.m_41619_()) {
                    tooltip.add((Component)new TextComponent(" * " + Localization.get((String)tagStack.m_41778_())));
                } else {
                    tagStack = new ItemStack((ItemLike)Blocks.f_50705_);
                    tooltip.add((Component)new TextComponent(" * /!\\ " + Localization.get((String)"info.shetiphian.texture.invalid") + " /!\\"));
                    tooltip.add((Component)new TextComponent(" ** " + Localization.get((String)tagStack.m_41778_())));
                    tooltip.add((Component)new TextComponent(" ** " + Localization.get((String)"info.shetiphian.texture.defaulted") + Localization.get((String)tagStack.m_41778_())));
                }
            } else {
                ItemStack tagStack = new ItemStack((ItemLike)Blocks.f_50705_);
                tooltip.add((Component)new TextComponent(" * /!\\ " + Localization.get((String)"info.shetiphian.texture.missing") + " /!\\"));
                tooltip.add((Component)new TextComponent(" ** " + Localization.get((String)"info.shetiphian.texture.defaulted") + Localization.get((String)tagStack.m_41778_())));
            }
        }
    }

    public static ItemStack createStack(Block block, ItemStack textureStack) {
        ItemStack ladderStack;
        if (block != null && !(ladderStack = new ItemStack((ItemLike)block)).m_41619_()) {
            CompoundTag tag = ItemBlockLadder.getTag(ladderStack);
            if (textureStack.m_41619_()) {
                textureStack = new ItemStack((ItemLike)Blocks.f_50705_);
            }
            CompoundTag texture = new CompoundTag();
            textureStack.m_41739_(texture);
            tag.m_128365_(ItemBlockLadder.getTextureKey(), (Tag)texture);
            return ladderStack;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getTextureStack(ItemStack ladderStack) {
        CompoundTag tag;
        if (!ladderStack.m_41619_() && (tag = ItemBlockLadder.getTag(ladderStack)).m_128441_(ItemBlockLadder.getTextureKey())) {
            return ItemStack.m_41712_((CompoundTag)tag.m_128469_(ItemBlockLadder.getTextureKey()));
        }
        return new ItemStack((ItemLike)Blocks.f_50705_);
    }

    private static String getTextureKey() {
        return "texture_item";
    }

    private static CompoundTag getTag(ItemStack stack) {
        return stack.m_41698_("BlockEntityTag");
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index == 0) {
            return Minecraft.m_91087_().getItemColors().m_92676_(ItemBlockLadder.getTextureStack(data.stack), 0);
        }
        return 0xFFFFFF;
    }
}

