/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.Random;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class SugarBlock
extends FallingBlock {
    public SugarBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_142216_(Level level, BlockPos pos, BlockState blockState, BlockState blockState2, FallingBlockEntity fallingBlock) {
        if (this.isWater(blockState2)) {
            level.m_46961_(pos, false);
        }
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (this.touchesLiquid((BlockGetter)level, pos)) {
            level.m_7696_(pos, state.m_60734_(), 1, 0);
        } else {
            super.m_7458_(state, level, pos, random);
        }
    }

    public boolean m_8133_(BlockState state, Level level, BlockPos pos, int id, int param) {
        if (id == 1) {
            if (level.f_46443_) {
                this.dissolve(level, pos);
            }
            if (this.shouldTurnToWater(level, pos)) {
                level.m_46597_(pos, Blocks.f_49990_.m_49966_());
            } else {
                level.m_7471_(pos, false);
            }
            return true;
        }
        return super.m_8133_(state, level, pos, id, param);
    }

    private boolean shouldTurnToWater(Level level, BlockPos pos) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.m_122032_();
        int count = 0;
        for (Direction direction : Direction.values()) {
            if (direction == Direction.DOWN) continue;
            mutableBlockPos.m_122159_((Vec3i)pos, direction);
            BlockState s = level.m_8055_((BlockPos)mutableBlockPos);
            if (direction == Direction.UP && this.isWater(s) || s.m_60734_() == Blocks.f_49990_) {
                ++count;
            }
            if (count < 2) continue;
            return true;
        }
        return false;
    }

    private boolean touchesLiquid(BlockGetter level, BlockPos pos) {
        boolean bl = false;
        BlockPos.MutableBlockPos mutableBlockPos = pos.m_122032_();
        BlockState blockState = level.m_8055_((BlockPos)mutableBlockPos);
        if (this.isWater(blockState)) {
            return true;
        }
        for (Direction direction : Direction.values()) {
            mutableBlockPos.m_122159_((Vec3i)pos, direction);
            blockState = level.m_8055_((BlockPos)mutableBlockPos);
            if (!this.isWater(blockState) || blockState.m_60783_(level, pos, direction.m_122424_())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean isWater(BlockState state) {
        return state.m_60819_().m_205070_(FluidTags.f_13131_);
    }

    public void dissolve(Level level, BlockPos pos) {
        double d2 = 0.25;
        boolean d = false;
        boolean e = false;
        boolean f = false;
        int amount = 4;
        for (int ax = 0; ax < amount; ++ax) {
            for (int ay = 0; ay < amount; ++ay) {
                for (int az = 0; az < amount; ++az) {
                    double s = ((double)ax + 0.5) / (double)amount;
                    double t = ((double)ay + 0.5) / (double)amount;
                    double u = ((double)az + 0.5) / (double)amount;
                    double px = s + (double)d;
                    double py = t + (double)e;
                    double pz = u + (double)f;
                    level.m_7106_((ParticleOptions)ModRegistry.SUGAR_PARTICLE.get(), (double)pos.m_123341_() + px, (double)pos.m_123342_() + py, (double)pos.m_123343_() + pz, s - 0.5, 0.0, u - 0.5);
                }
            }
        }
    }

    public int m_6248_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_60780_((BlockGetter)level, (BlockPos)pos).f_76396_;
    }

    protected void m_142387_(Level level, Player player, BlockPos pos, BlockState state) {
        if (level.f_46443_) {
            this.dissolve(level, pos);
        }
        SoundType soundtype = state.m_60827_();
        level.m_5594_(null, pos, soundtype.m_56775_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
    }
}

