/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.common.world.songs.SongsManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundSetSongPacket {
    private final ResourceLocation song;
    private final UUID id;

    public ClientBoundSetSongPacket(FriendlyByteBuf buf) {
        this.song = buf.m_130281_();
        this.id = buf.m_130259_();
    }

    public ClientBoundSetSongPacket(UUID id, ResourceLocation resourceLocation) {
        this.song = resourceLocation;
        this.id = id;
    }

    public static void buffer(ClientBoundSetSongPacket message, FriendlyByteBuf buf) {
        buf.m_130085_(message.song);
        buf.m_130077_(message.id);
    }

    public static void handler(ClientBoundSetSongPacket message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide().isClient()) {
                SongsManager.setCurrentlyPlaying(message.id, message.song);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

