/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.util;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PlayerInventoryHandler {
    private final Function<Player, Integer> getSlotCount;
    private final BiFunction<Player, Integer, ItemStack> getStackInSlot;
    private final IStackInSlotModifier setStackInSlot;
    private final boolean visibleInGui;
    private final boolean ownRenderer;

    public PlayerInventoryHandler(Function<Player, Integer> getSlotCount, BiFunction<Player, Integer, ItemStack> getStackInSlot, IStackInSlotModifier setStackInSlot, boolean visibleInGui, boolean ownRenderer) {
        this.getSlotCount = getSlotCount;
        this.getStackInSlot = getStackInSlot;
        this.setStackInSlot = setStackInSlot;
        this.visibleInGui = visibleInGui;
        this.ownRenderer = ownRenderer;
    }

    public int getSlotCount(Player player) {
        return this.getSlotCount.apply(player);
    }

    public ItemStack getStackInSlot(Player player, int slot) {
        return this.getStackInSlot.apply(player, slot);
    }

    public boolean isVisibleInGui() {
        return this.visibleInGui;
    }

    public void setStackInSlot(Player player, int slot, ItemStack stack) {
        this.setStackInSlot.accept(player, slot, stack);
    }

    public boolean hasItsOwnRenderer() {
        return this.ownRenderer;
    }

    public static interface IStackInSlotModifier {
        public void accept(Player var1, int var2, ItemStack var3);
    }
}

