/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.common.gui;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.HighStackCountSynchronizer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ISyncedContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageBackgroundProperties;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsContainerBase;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.globaloverridable.GlobalOverridableSettingsContainer;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsContainer;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsContainer;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsContainer;

public abstract class SettingsContainer<S extends IStorageWrapper>
extends AbstractContainerMenu
implements ISyncedContainer {
    private static final Map<String, ISettingsContainerFactory<?, ?>> SETTINGS_CONTAINER_FACTORIES;
    protected final Player player;
    protected final S storageWrapper;
    private final StorageBackgroundProperties storageBackgroundProperties;
    private final List<Slot> storageInventorySlots = new ArrayList<Slot>();
    public final NonNullList<ItemStack> ghostItemStacks = NonNullList.m_122779_();
    private final Map<String, SettingsContainerBase<?>> settingsContainers = new LinkedHashMap();
    public final List<Slot> ghostSlots = new ArrayList<Slot>();

    protected SettingsContainer(MenuType<?> menuType, int windowId, Player player, S storageWrapper) {
        super(menuType, windowId);
        this.player = player;
        this.storageWrapper = storageWrapper;
        this.storageBackgroundProperties = this.getNumberOfSlots() + storageWrapper.getColumnsTaken() * storageWrapper.getNumberOfSlotRows() <= 81 ? StorageBackgroundProperties.REGULAR : StorageBackgroundProperties.WIDE;
        this.addStorageInventorySlots();
        this.addSettingsContainers();
    }

    private void addSettingsContainers() {
        SettingsHandler settingsHandler = this.storageWrapper.getSettingsHandler();
        settingsHandler.getSettingsCategories().forEach((name, category) -> this.settingsContainers.put((String)name, SettingsContainer.instantiateContainer(this, name, category)));
    }

    private void addStorageInventorySlots() {
        InventoryHandler inventoryHandler = this.storageWrapper.getInventoryHandler();
        int slotIndex = 0;
        int yPosition = 18;
        while (slotIndex < inventoryHandler.getSlots()) {
            int lineIndex = slotIndex % this.getSlotsOnLine();
            int finalSlotIndex = slotIndex++;
            this.storageInventorySlots.add(this.m_38897_((Slot)new ViewOnlyStorageInventorySlot((IItemHandler)inventoryHandler, finalSlotIndex, lineIndex, yPosition)));
            if (slotIndex % this.getSlotsOnLine() != 0) continue;
            yPosition += 18;
        }
    }

    protected Slot m_38897_(Slot slot) {
        slot.f_40219_ = this.ghostSlots.size();
        this.ghostSlots.add(slot);
        this.ghostItemStacks.add((Object)ItemStack.f_41583_);
        return slot;
    }

    public void m_38946_() {
        for (int i = 0; i < this.ghostSlots.size(); ++i) {
            ItemStack itemstack = this.ghostSlots.get(i).m_7993_();
            ItemStack itemstack1 = (ItemStack)this.ghostItemStacks.get(i);
            if (ItemStack.m_41728_((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            boolean clientStackChanged = !itemstack1.equals(itemstack, true);
            ItemStack itemstack2 = itemstack.m_41777_();
            this.ghostItemStacks.set(i, (Object)itemstack2);
            if (!clientStackChanged) continue;
            for (ContainerListener icontainerlistener : this.f_38848_) {
                icontainerlistener.m_7934_((AbstractContainerMenu)this, i, itemstack2);
            }
        }
    }

    public abstract void detectSettingsChangeAndReload();

    public void m_38893_(ContainerListener listener) {
        if (listener instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)listener;
            if (this.storageWrapper.getInventoryHandler().getStackSizeMultiplier() > 1) {
                super.m_150416_((ContainerSynchronizer)new HighStackCountSynchronizer(serverPlayer));
                return;
            }
        }
        super.m_38893_(listener);
    }

    public Slot m_38853_(int slotId) {
        return this.ghostSlots.get(slotId);
    }

    public Optional<ItemStack> getMemorizedStackInSlot(int slotId) {
        return this.storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class).getSlotFilterItem(slotId).map(ItemStack::new);
    }

    public int getSlotsOnLine() {
        return this.storageBackgroundProperties.getSlotsOnLine() - this.storageWrapper.getColumnsTaken();
    }

    public int getNumberOfSlots() {
        return this.storageWrapper.getInventoryHandler().getSlots();
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public List<Slot> getStorageInventorySlots() {
        return this.storageInventorySlots;
    }

    @Override
    public void handleMessage(CompoundTag data) {
        String categoryName;
        if (data.m_128441_("categoryName") && this.settingsContainers.containsKey(categoryName = data.m_128461_("categoryName"))) {
            this.settingsContainers.get(categoryName).handleMessage(data);
        }
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
    }

    public StorageBackgroundProperties getStorageBackgroundProperties() {
        return this.storageBackgroundProperties;
    }

    public void forEachSettingsContainer(BiConsumer<String, ? super SettingsContainerBase<?>> consumer) {
        this.settingsContainers.forEach(consumer);
    }

    public Player getPlayer() {
        return this.player;
    }

    public BlockPos getBlockPosition() {
        return BlockPos.f_121853_;
    }

    public int getNumberOfRows() {
        return this.storageWrapper.getNumberOfSlotRows();
    }

    private static <C extends ISettingsCategory, T extends SettingsContainerBase<C>> void addFactory(ImmutableMap.Builder<String, ISettingsContainerFactory<?, ?>> builder, String categoryName, ISettingsContainerFactory<C, T> factory) {
        builder.put((Object)categoryName, factory);
    }

    private static <C extends ISettingsCategory> SettingsContainerBase<C> instantiateContainer(SettingsContainer<?> settingsContainer, String name, C category) {
        return SettingsContainer.getSettingsContainerFactory(name).create(settingsContainer, name, category);
    }

    private static <C extends ISettingsCategory, T extends SettingsContainerBase<C>> ISettingsContainerFactory<C, T> getSettingsContainerFactory(String name) {
        return SETTINGS_CONTAINER_FACTORIES.get(name);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        SettingsContainer.addFactory(builder, "global", GlobalOverridableSettingsContainer::new);
        SettingsContainer.addFactory(builder, "no_sort", NoSortSettingsContainer::new);
        SettingsContainer.addFactory(builder, "memory", MemorySettingsContainer::new);
        SettingsContainer.addFactory(builder, "item_display", ItemDisplaySettingsContainer::new);
        SETTINGS_CONTAINER_FACTORIES = builder.build();
    }

    private static class ViewOnlyStorageInventorySlot
    extends SlotItemHandler {
        public ViewOnlyStorageInventorySlot(IItemHandler inventoryHandler, int slotIndex, int lineIndex, int yPosition) {
            super(inventoryHandler, slotIndex, 8 + lineIndex * 18, yPosition);
        }

        public boolean m_8010_(Player playerIn) {
            return false;
        }
    }

    public static interface ISettingsContainerFactory<C extends ISettingsCategory, T extends SettingsContainerBase<C>> {
        public T create(SettingsContainer<?> var1, String var2, C var3);
    }
}

