/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings.memory;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.IntConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.inventory.Slot;
import net.p3pp3rf1y.sophisticatedcore.client.gui.SettingsScreen;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.Button;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ButtonDefinition;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ImageButton;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.UV;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsTab;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsContainer;

public class MemorySettingsTab
extends SettingsTab<MemorySettingsContainer> {
    private static final TextureBlitData ICON = new TextureBlitData(GuiHelper.ICONS, Dimension.SQUARE_256, new UV(128, 32), Dimension.SQUARE_16);
    private static final TextureBlitData SELECT_ALL_SLOTS_FOREGROUND = new TextureBlitData(GuiHelper.ICONS, new Position(1, 1), Dimension.SQUARE_256, new UV(16, 80), Dimension.SQUARE_16);
    public static final ButtonDefinition SELECT_ALL_SLOTS = new ButtonDefinition(Dimension.SQUARE_16, GuiHelper.DEFAULT_BUTTON_BACKGROUND, GuiHelper.DEFAULT_BUTTON_HOVERED_BACKGROUND, SELECT_ALL_SLOTS_FOREGROUND, new Component[]{new TranslatableComponent(TranslationHelper.INSTANCE.translSettingsButton("select_all_slots"))});
    private static final TextureBlitData UNSELECT_ALL_SLOTS_FOREGROUND = new TextureBlitData(GuiHelper.ICONS, new Position(1, 1), Dimension.SQUARE_256, new UV(48, 80), Dimension.SQUARE_16);
    public static final ButtonDefinition UNSELECT_ALL_SLOTS = new ButtonDefinition(Dimension.SQUARE_16, GuiHelper.DEFAULT_BUTTON_BACKGROUND, GuiHelper.DEFAULT_BUTTON_HOVERED_BACKGROUND, UNSELECT_ALL_SLOTS_FOREGROUND, new Component[]{new TranslatableComponent(TranslationHelper.INSTANCE.translSettingsButton("unselect_all_slots"))});

    public MemorySettingsTab(MemorySettingsContainer container, Position position, SettingsScreen screen) {
        super(container, position, screen, (Component)new TranslatableComponent(TranslationHelper.INSTANCE.translSettings("memory")), (List<Component>)new ImmutableList.Builder().add((Object)new TranslatableComponent(TranslationHelper.INSTANCE.translSettingsTooltip("memory"))).addAll(TranslationHelper.INSTANCE.getTranslatedLines(TranslationHelper.INSTANCE.translSettingsTooltip("memory") + "_detail", null, ChatFormatting.GRAY)).build(), (List<Component>)new ImmutableList.Builder().add((Object)new TranslatableComponent(TranslationHelper.INSTANCE.translSettingsTooltip("memory"))).addAll(TranslationHelper.INSTANCE.getTranslatedLines(TranslationHelper.INSTANCE.translSettingsTooltip("memory") + "_open_detail", null, ChatFormatting.GRAY)).build(), onTabIconClicked -> new ImageButton(new Position(position.x() + 1, position.y() + 4), Dimension.SQUARE_16, ICON, (IntConsumer)onTabIconClicked));
        this.addHideableChild(new Button(new Position(this.x + 3, this.y + 24), SELECT_ALL_SLOTS, button -> container.selectAllSlots()));
        this.addHideableChild(new Button(new Position(this.x + 21, this.y + 24), UNSELECT_ALL_SLOTS, button -> container.unselectAllSlots()));
    }

    @Override
    public Optional<Integer> getSlotOverlayColor(int slotNumber) {
        return Optional.empty();
    }

    @Override
    public void handleSlotClick(Slot slot, int mouseButton) {
        if (mouseButton == 0) {
            ((MemorySettingsContainer)this.getSettingsContainer()).selectSlot(slot.f_40219_);
        } else if (mouseButton == 1) {
            ((MemorySettingsContainer)this.getSettingsContainer()).unselectSlot(slot.f_40219_);
        }
    }
}

